/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat.index;

import edu.ucsb.nceas.metacat.common.query.SolrQueryServiceController;
import edu.ucsb.nceas.metacat.properties.PropertyService;
import edu.ucsb.nceas.utilities.FileUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.solr.schema.SchemaField;
import org.dataone.service.exceptions.NotFound;
import org.dataone.service.exceptions.UnsupportedType;
import org.dataone.service.types.v1_1.QueryEngineDescription;
import org.dataone.service.types.v1_1.QueryField;
import org.xml.sax.SAXException;

public class MetacatSolrEngineDescriptionHandler {
    private static final String UNKNOWN = "Unknown";
    private static final String DESCRIPTIONFILENAME = "solrQueryFieldDescriptions.properties";
    private static final String HTTPSOLRSERVERSCHEMAURLPATH = "/admin/file/?contentType=text/xml;charset=utf-8&file=schema.xml";
    private static MetacatSolrEngineDescriptionHandler handler = null;
    private static Log logger = LogFactory.getLog(MetacatSolrEngineDescriptionHandler.class);
    private QueryEngineDescription qed = null;

    public static MetacatSolrEngineDescriptionHandler getInstance() throws Exception {
        if (handler == null) {
            handler = new MetacatSolrEngineDescriptionHandler();
        }
        return handler;
    }

    public QueryEngineDescription getQueryEngineDescritpion() {
        return this.qed;
    }

    private MetacatSolrEngineDescriptionHandler() throws Exception {
        this.init();
    }

    private void init() throws IOException, UnsupportedType, NotFound, ParserConfigurationException, SAXException {
        Map<String, String> fieldDescriptions = this.loadSchemaFieldDescriptions();
        this.qed = new QueryEngineDescription();
        this.qed.setName("solr");
        this.setSolrVersion();
        Map fieldMap = SolrQueryServiceController.getInstance().getIndexSchemaFields();
        for (SchemaField schemaField : fieldMap.values()) {
            this.qed.addQueryField(this.createQueryFieldFromSchemaField(schemaField, fieldDescriptions));
        }
        Collections.sort(this.qed.getQueryFieldList(), new QueryFieldAlphaComparator());
    }

    private void setSolrVersion() throws UnsupportedType, NotFound, ParserConfigurationException, IOException, SAXException {
        this.qed.setQueryEngineVersion(SolrQueryServiceController.getInstance().getSolrSpecVersion());
    }

    private Map<String, String> loadSchemaFieldDescriptions() throws IOException {
        HashMap<String, String> fieldDescriptions = new HashMap<String, String>();
        Properties descriptionProperties = new Properties();
        String propertyFilePath = PropertyService.CONFIG_FILE_DIR + FileUtil.getFS() + DESCRIPTIONFILENAME;
        descriptionProperties.load(new FileInputStream(new File(propertyFilePath)));
        Set<Object> names = descriptionProperties.keySet();
        for (Object nameObj : names) {
            String name = (String)nameObj;
            String description = (String)descriptionProperties.get(name);
            fieldDescriptions.put(name, description);
        }
        return fieldDescriptions;
    }

    private QueryField createQueryFieldFromSchemaField(SchemaField field, Map<String, String> fieldDescriptions) {
        QueryField queryField = new QueryField();
        queryField.setName(field.getName());
        queryField.setType(field.getType().getTypeName());
        String description = fieldDescriptions.get(field.getName());
        if (description != null && !description.trim().equals("")) {
            queryField.addDescription(description);
        }
        queryField.setSearchable(field.indexed());
        queryField.setReturnable(field.stored());
        queryField.setMultivalued(Boolean.valueOf(field.multiValued()));
        queryField.setSortable(this.isSortable(field));
        return queryField;
    }

    private boolean isSortable(SchemaField field) {
        String type = field.getType().getTypeName();
        return !"int".equals(type) && !"long".equals(type) && !"float".equals(type) && !"double".equals(type);
    }

    private class QueryFieldAlphaComparator
    implements Comparator<QueryField> {
        private QueryFieldAlphaComparator() {
        }

        @Override
        public int compare(QueryField arg0, QueryField arg1) {
            String field1Name = arg0.getName();
            String field2Name = arg1.getName();
            return field1Name.compareToIgnoreCase(field2Name);
        }
    }
}

