/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat.index;

import edu.ucsb.nceas.metacat.DBTransform;
import edu.ucsb.nceas.metacat.common.index.IndexTask;
import edu.ucsb.nceas.metacat.common.query.SolrQueryService;
import edu.ucsb.nceas.metacat.common.query.SolrQueryServiceController;
import edu.ucsb.nceas.metacat.common.query.stream.ContentTypeByteArrayInputStream;
import edu.ucsb.nceas.metacat.dataone.hazelcast.HazelcastService;
import edu.ucsb.nceas.metacat.properties.PropertyService;
import edu.ucsb.nceas.utilities.PropertyNotFoundException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.MultiMapSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.dataone.service.exceptions.NotFound;
import org.dataone.service.exceptions.NotImplemented;
import org.dataone.service.exceptions.UnsupportedType;
import org.dataone.service.types.v1.Identifier;
import org.dataone.service.types.v1.Subject;
import org.dataone.service.types.v2.SystemMetadata;
import org.xml.sax.SAXException;

public class MetacatSolrIndex {
    private static Log log = LogFactory.getLog(MetacatSolrIndex.class);
    private static MetacatSolrIndex solrIndex = null;
    private static String nodeType = null;

    public static MetacatSolrIndex getInstance() throws Exception {
        if (solrIndex == null) {
            solrIndex = new MetacatSolrIndex();
        }
        return solrIndex;
    }

    private MetacatSolrIndex() throws Exception {
        nodeType = PropertyService.getProperty("dataone.nodeType");
    }

    public InputStream query(String query, Set<Subject> authorizedSubjects, boolean isMNadmin) throws SolrServerException, IOException, PropertyNotFoundException, SQLException, ClassNotFoundException, ParserConfigurationException, SAXException, NotImplemented, NotFound, UnsupportedType, SolrException {
        query = query.replaceAll("\\+", "%2B");
        MultiMapSolrParams solrParams = MetacatSolrIndex.parseQueryString(query);
        return this.query((SolrParams)solrParams, authorizedSubjects, isMNadmin);
    }

    private static MultiMapSolrParams parseQueryString(String queryString) {
        HashMap map = new HashMap();
        if (queryString != null && queryString.length() > 0) {
            try {
                for (String kv : queryString.split("&")) {
                    String name;
                    int idx = kv.indexOf(61);
                    if (idx > 0) {
                        name = URLDecoder.decode(kv.substring(0, idx), "UTF-8");
                        String value = URLDecoder.decode(kv.substring(idx + 1), "UTF-8");
                        log.debug((Object)("SolrIndex.parseQueryString - add the name " + name + " and value " + value + " pair to the prama map"));
                        MultiMapSolrParams.addParam((String)name, (String)value, map);
                        continue;
                    }
                    name = URLDecoder.decode(kv, "UTF-8");
                    log.debug((Object)("SolrIndex.parseQueryString - add the name " + name + " to the prama map"));
                    MultiMapSolrParams.addParam((String)name, (String)"", map);
                }
            }
            catch (UnsupportedEncodingException uex) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)uex);
            }
        }
        return new MultiMapSolrParams(map);
    }

    public InputStream query(SolrParams solrParams, Set<Subject> authorizedSubjects, boolean isMNadmin) throws SolrServerException, IOException, PropertyNotFoundException, SQLException, ClassNotFoundException, ParserConfigurationException, SAXException, NotImplemented, NotFound, UnsupportedType {
        return this.query(solrParams, authorizedSubjects, isMNadmin, SolrRequest.METHOD.GET);
    }

    public InputStream query(SolrParams solrParams, Set<Subject> authorizedSubjects, boolean isMNadmin, SolrRequest.METHOD method) throws SolrServerException, IOException, PropertyNotFoundException, SQLException, ClassNotFoundException, ParserConfigurationException, SAXException, NotImplemented, NotFound, UnsupportedType {
        if (authorizedSubjects == null || authorizedSubjects.isEmpty()) {
            Subject subject = new Subject();
            subject.setValue("public");
            authorizedSubjects = new HashSet<Subject>();
            authorizedSubjects.add(subject);
        }
        if (isMNadmin) {
            authorizedSubjects = null;
            log.debug((Object)"MetacatSolrIndex.query - this is the mn admin object and the query will bypass the access controls rules.");
        }
        InputStream inputStream = null;
        String wt = solrParams.get("wt");
        if (SolrQueryService.isSupportedWT((String)wt)) {
            inputStream = SolrQueryServiceController.getInstance().query(solrParams, authorizedSubjects, method);
        } else {
            String qformat = wt;
            wt = "xml";
            ModifiableSolrParams msp = new ModifiableSolrParams(solrParams);
            msp.set("wt", new String[]{wt});
            inputStream = SolrQueryServiceController.getInstance().query((SolrParams)msp, authorizedSubjects, method);
            DBTransform transformer = new DBTransform();
            String documentContent = IOUtils.toString((InputStream)inputStream, (String)"UTF-8");
            String sourceType = "solr";
            String targetType = "-//W3C//HTML//EN";
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)baos, "UTF-8");
            Hashtable<String, String[]> params = new Hashtable<String, String[]>();
            params.put("qformat", new String[]{qformat});
            transformer.transformXMLDocument(documentContent, sourceType, targetType, qformat, writer, params, null);
            inputStream = new ContentTypeByteArrayInputStream(baos.toByteArray());
            ((ContentTypeByteArrayInputStream)inputStream).setContentType("text/html");
        }
        return inputStream;
    }

    public void submitDeleteTask(Identifier pid, SystemMetadata sysMeta) {
        if (nodeType == null || !nodeType.equalsIgnoreCase("mn")) {
            log.info((Object)("MetacatSolrIndex.submit - The node is not configured as a member node. So the object  " + pid.getValue() + " will not be submitted into the index queue on hazelcast service."));
            return;
        }
        IndexTask task = new IndexTask();
        task.setSystemMetadata(sysMeta);
        task.setIsDeleteing(true);
        if (pid != null) {
            log.debug((Object)("MetacatSolrIndex.submitDeleteTask - will put the pid " + pid.getValue() + " into the index queue on hazelcast service."));
            HazelcastService.getInstance().getIndexQueue().put((Object)pid, (Object)task);
            log.info((Object)("MetacatSolrIndex.submitDeleteTask - put the pid " + pid.getValue() + " into the index queue on hazelcast service successfully."));
        }
    }

    public void submit(Identifier pid, SystemMetadata systemMetadata, Map<String, List<Object>> fields, boolean followRevisions) {
        boolean isSysmetaChangeOnly = false;
        this.submit(pid, systemMetadata, isSysmetaChangeOnly, fields, followRevisions);
    }

    public void submit(Identifier pid, SystemMetadata systemMetadata, boolean isSysmetaChangeOnly, Map<String, List<Object>> fields, boolean followRevisions) {
        if (nodeType == null || !nodeType.equalsIgnoreCase("mn")) {
            log.info((Object)("MetacatSolrIndex.submit - The node is not configured as a member node. So the object  " + pid.getValue() + " will not be submitted into the index queue on hazelcast service."));
            return;
        }
        IndexTask task = new IndexTask();
        task.setSystemMetadata(systemMetadata);
        task.setFields(fields);
        long start = System.currentTimeMillis();
        task.setTimeAddToQueque(start);
        task.setSysmetaChangeOnly(isSysmetaChangeOnly);
        if (pid != null) {
            log.debug((Object)("MetacatSolrIndex.submit - will put the pid " + pid.getValue() + " into the index queue on hazelcast service."));
        }
        HazelcastService.getInstance().getIndexQueue().put((Object)pid, (Object)task);
        if (pid != null) {
            log.info((Object)("MetacatSolrIndex.submit - put the pid " + pid.getValue() + " into the index queue on hazelcast service successfully."));
        }
        if (followRevisions && systemMetadata != null && systemMetadata.getObsoletes() != null) {
            Identifier obsoletedPid = systemMetadata.getObsoletes();
            SystemMetadata obsoletedSysMeta = (SystemMetadata)HazelcastService.getInstance().getSystemMetadataMap().get((Object)obsoletedPid);
            Map<String, List<Object>> obsoletedFields = null;
            this.submit(obsoletedPid, obsoletedSysMeta, obsoletedFields, followRevisions);
        }
    }
}

