/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat.lsid;

import com.ibm.lsid.server.LSIDDataService;
import com.ibm.lsid.server.LSIDRequestContext;
import com.ibm.lsid.server.LSIDServerException;
import com.ibm.lsid.server.LSIDServiceConfig;
import edu.ucsb.nceas.metacat.lsid.LSIDDataLookup;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LSIDAuthorityData
implements LSIDDataService {
    private LSIDDataLookup lookup = null;
    private static Log logger = LogFactory.getLog((String)"edu.ucsb.nceas.metacat.lsid");

    public InputStream getData(LSIDRequestContext lsid) throws LSIDServerException {
        logger.debug((Object)("Getting data (Metacat): " + lsid.getLsid().toString()));
        if (this.lookup == null) {
            throw new LSIDServerException(500, "Cannot query database");
        }
        return this.lookup.lsidData(lsid.getLsid());
    }

    public InputStream getDataByRange(LSIDRequestContext lsid, int start, int end) throws LSIDServerException {
        if (this.lookup == null) {
            throw new LSIDServerException(500, "Cannot query database");
        }
        return this.lookup.lsidData(lsid.getLsid());
    }

    public void initService(LSIDServiceConfig cf) throws LSIDServerException {
        logger.info((Object)"Starting LSIDAuthorityData (Metacat).");
        this.lookup = new LSIDDataLookup();
    }
}

