/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat.oaipmh.harvester;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Date;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xpath.XPathAPI;
import org.apache.xpath.objects.XObject;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class HarvesterVerb {
    private static Log logger = LogFactory.getLog(HarvesterVerb.class);
    public static final String SCHEMA_LOCATION_V2_0 = "http://www.openarchives.org/OAI/2.0/ http://www.openarchives.org/OAI/2.0/OAI-PMH.xsd";
    private static HashMap<Thread, DocumentBuilder> builderMap = new HashMap();
    private static DocumentBuilderFactory documentBuilderFactory = null;
    private static Element namespaceElement = null;
    private static TransformerFactory transformerFactory = TransformerFactory.newInstance();
    private Document document = null;
    private String schemaLocation = null;
    private String requestURL = null;

    public HarvesterVerb() {
    }

    public HarvesterVerb(String requestURL) throws IOException, ParserConfigurationException, SAXException, TransformerException {
        this.requestURL = requestURL;
    }

    public Document getDocument() {
        return this.document;
    }

    public NodeList getErrors() throws TransformerException {
        if (SCHEMA_LOCATION_V2_0.equals(this.getSchemaLocation())) {
            return this.getNodeList("/oai20:OAI-PMH/oai20:error");
        }
        return null;
    }

    public NodeList getNodeList(String xpath) throws TransformerException {
        Document document = this.getDocument();
        return XPathAPI.selectNodeList((Node)document, (String)xpath, (Node)namespaceElement);
    }

    public String getRequestURL() {
        return this.requestURL;
    }

    public String getSchemaLocation() {
        return this.schemaLocation;
    }

    public String getSingleString(String xpath) throws TransformerException {
        Document document = this.getDocument();
        XObject xobject = XPathAPI.eval((Node)document, (String)xpath, (Node)namespaceElement);
        String str = xobject.str();
        return str;
    }

    public void runVerb() throws IOException, ParserConfigurationException, SAXException, TransformerException {
        String schemaLocationStr;
        InputStream in = null;
        URL url = new URL(this.requestURL);
        HttpURLConnection con = null;
        int responseCode = 0;
        do {
            con = (HttpURLConnection)url.openConnection();
            con.setRequestProperty("User-Agent", "OAIHarvester/2.0");
            con.setRequestProperty("Accept-Encoding", "compress, gzip, identify");
            try {
                responseCode = con.getResponseCode();
            }
            catch (FileNotFoundException e) {
                logger.info((Object)this.requestURL, (Throwable)e);
                responseCode = 503;
            }
            if (responseCode != 503) continue;
            long retrySeconds = con.getHeaderFieldInt("Retry-After", -1);
            if (retrySeconds == -1L) {
                long now = new Date().getTime();
                long retryDate = con.getHeaderFieldDate("Retry-After", now);
                retrySeconds = retryDate - now;
            }
            if (retrySeconds == 0L) {
                throw new FileNotFoundException("Bad URL?");
            }
            System.err.println("Server response: Retry-After=" + retrySeconds);
            if (retrySeconds <= 0L) continue;
            try {
                Thread.sleep(retrySeconds * 1000L);
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        } while (responseCode == 503);
        String contentEncoding = con.getHeaderField("Content-Encoding");
        if ("compress".equals(contentEncoding)) {
            ZipInputStream zis = new ZipInputStream(con.getInputStream());
            zis.getNextEntry();
            in = zis;
        } else {
            in = "gzip".equals(contentEncoding) ? new GZIPInputStream(con.getInputStream()) : ("deflate".equals(contentEncoding) ? new InflaterInputStream(con.getInputStream()) : con.getInputStream());
        }
        InputSource data = new InputSource(in);
        Thread t = Thread.currentThread();
        DocumentBuilder builder = builderMap.get(t);
        if (builder == null) {
            builder = documentBuilderFactory.newDocumentBuilder();
            builderMap.put(t, builder);
        }
        this.document = builder.parse(data);
        String singleString = this.getSingleString("/*/@xsi:schemaLocation");
        StringTokenizer tokenizer = new StringTokenizer(singleString, " ");
        StringBuffer sb = new StringBuffer();
        while (tokenizer.hasMoreTokens()) {
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append(tokenizer.nextToken());
        }
        this.schemaLocation = schemaLocationStr = sb.toString();
    }

    public String toString() {
        Document document = this.getDocument();
        DOMSource source = new DOMSource(document);
        StringWriter stringWriter = new StringWriter();
        StreamResult result = new StreamResult(stringWriter);
        try {
            Transformer idTransformer = transformerFactory.newTransformer();
            idTransformer.setOutputProperty("omit-xml-declaration", "no");
            idTransformer.transform(source, result);
            String returnString = stringWriter.toString();
            return returnString;
        }
        catch (TransformerException e) {
            return e.getMessage();
        }
    }

    static {
        try {
            documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            Thread thread = Thread.currentThread();
            DocumentBuilder builder = documentBuilderFactory.newDocumentBuilder();
            builderMap.put(thread, builder);
            DOMImplementation impl = builder.getDOMImplementation();
            Document namespaceHolder = impl.createDocument("http://www.oclc.org/research/software/oai/harvester", "harvester:namespaceHolder", null);
            namespaceElement = namespaceHolder.getDocumentElement();
            namespaceElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:harvester", "http://www.oclc.org/research/software/oai/harvester");
            namespaceElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
            namespaceElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:oai20", "http://www.openarchives.org/OAI/2.0/");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

