/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat.object.handler;

import edu.ucsb.nceas.metacat.DocumentImpl;
import edu.ucsb.nceas.metacat.EventLog;
import edu.ucsb.nceas.metacat.EventLogData;
import edu.ucsb.nceas.metacat.IdentifierManager;
import edu.ucsb.nceas.metacat.dataone.D1NodeService;
import edu.ucsb.nceas.metacat.properties.PropertyService;
import edu.ucsb.nceas.metacat.replication.ForceReplicationHandler;
import edu.ucsb.nceas.metacat.restservice.multipart.DetailedFileInputStream;
import edu.ucsb.nceas.utilities.PropertyNotFoundException;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dataone.service.exceptions.InvalidRequest;
import org.dataone.service.exceptions.InvalidSystemMetadata;
import org.dataone.service.exceptions.NotAuthorized;
import org.dataone.service.exceptions.ServiceFailure;
import org.dataone.service.exceptions.UnsupportedType;
import org.dataone.service.types.v1.Checksum;
import org.dataone.service.types.v1.Identifier;
import org.dataone.service.types.v1.Session;
import org.dataone.service.types.v1.SystemMetadata;

public abstract class NonXMLMetadataHandler {
    private static Log logMetacat = LogFactory.getLog(NonXMLMetadataHandler.class);
    private static String metadataStoragePath = null;
    private File tmpFile = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String save(InputStream source, SystemMetadata sysmeta, Session session, EventLogData event) throws UnsupportedType, ServiceFailure, InvalidRequest, InvalidSystemMetadata, NotAuthorized {
        if (sysmeta == null) {
            throw new InvalidRequest("1102", "NonXMLMetadataHandler.save - the system metadata parameter should not be null.");
        }
        Identifier pid = sysmeta.getIdentifier();
        Checksum expectedChecksum = sysmeta.getChecksum();
        String docType = sysmeta.getFormatId().getValue();
        if (pid == null || pid.getValue() == null || pid.getValue().trim().equals("")) {
            throw new InvalidRequest("1102", "NonXMLMetadataHandler.save - the pid parameter should not be blank.");
        }
        logMetacat.debug((Object)("NonXMLMetadataHandler.save - save the object " + pid.getValue() + " with doctype " + docType));
        String localId = null;
        boolean valid = false;
        InputStream data = this.checkValidation(source, pid);
        try {
            if (metadataStoragePath == null) {
                throw new ServiceFailure("1190", "NonXMLMetadataHandler.save - cannot save the metadata object " + pid.getValue() + " into disk since the property - application.documentfilepath is not found in the metacat.properties file ");
            }
            localId = D1NodeService.insertObject(data, docType, pid, metadataStoragePath, session, expectedChecksum, event);
        }
        finally {
            if (this.tmpFile != null) {
                this.tmpFile.delete();
            }
            try {
                source.close();
            }
            catch (IOException ee) {
                logMetacat.warn((Object)("NonXMLMetadataHandler.save - cannot close the source stream since " + ee.getMessage()));
            }
            try {
                data.close();
            }
            catch (IOException ee) {
                logMetacat.warn((Object)("NonXMLMetadataHandler.save - cannot close the source stream since " + ee.getMessage()));
            }
        }
        return localId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveReplication(InputStream source, String localId, SystemMetadata sysmeta, String owner, int serverCode, String replicationNotificationServer, EventLogData event) throws UnsupportedType, ServiceFailure, InvalidRequest, InvalidSystemMetadata, NotAuthorized {
        if (sysmeta == null) {
            throw new InvalidRequest("1102", "NonXMLMetadataHandler.saveReplication - the system metadata parameter should not be null.");
        }
        Identifier pid = sysmeta.getIdentifier();
        Checksum expectedChecksum = sysmeta.getChecksum();
        String docType = sysmeta.getFormatId().getValue();
        if (pid == null || pid.getValue() == null || pid.getValue().trim().equals("")) {
            throw new InvalidRequest("1102", "NonXMLMetadataHandler.saveReplication - the pid parameter should not be blank.");
        }
        logMetacat.debug((Object)("NonXMLMetadataHandler.saveReplication - save the object " + pid.getValue() + " with doctype " + docType));
        InputStream data = this.checkValidation(source, pid);
        try {
            if (metadataStoragePath == null) {
                throw new ServiceFailure("1190", "NonXMLMetadataHandler.saveReplication - cannot save the metadata object " + pid.getValue() + " into disk since the property - application.documentfilepath is not found in the metacat.properties file ");
            }
            D1NodeService.writeStreamToFile(new File(metadataStoragePath), localId, source, expectedChecksum, pid);
            try {
                DocumentImpl.registerDocument(localId, docType, localId, owner, null, serverCode);
            }
            catch (Exception e) {
                boolean isMetadata = true;
                try {
                    DocumentImpl.deleteFromFileSystem(localId, isMetadata);
                }
                catch (Exception ee) {
                    logMetacat.error((Object)("NonXMLMetadataHandler.saveReplication - In the exception route, Metacat cannot delete " + localId + " in order to undo the transaction since " + ee.getMessage()));
                }
                throw new ServiceFailure("1190", "NonXMLMetadataHandler.saveReplication - cannot register the local id " + localId + " for the pid " + pid.getValue() + " into the xml_table since " + e.getMessage());
            }
            IdentifierManager.getInstance().createMapping(pid.getValue(), localId);
            try {
                logMetacat.debug((Object)"Logging the creation event.");
                EventLog.getInstance().log(event.getIpAddress(), event.getUserAgent(), "replication", localId, "create");
            }
            catch (Exception e) {
                logMetacat.warn((Object)("D1NodeService.insertDataObject - can't log the create event for the object " + pid.getValue()));
            }
            boolean isMeta = true;
            ForceReplicationHandler forceReplicationHandler = new ForceReplicationHandler(localId, "insert", isMeta, replicationNotificationServer);
        }
        finally {
            if (this.tmpFile != null) {
                this.tmpFile.delete();
            }
            try {
                source.close();
            }
            catch (IOException ee) {
                logMetacat.warn((Object)("NonXMLMetadataHandler.save - cannot close the source stream since " + ee.getMessage()));
            }
            try {
                data.close();
            }
            catch (IOException ee) {
                logMetacat.warn((Object)("NonXMLMetadataHandler.save - cannot close the source stream since " + ee.getMessage()));
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private InputStream checkValidation(InputStream validationInput, Identifier pid) throws ServiceFailure, InvalidRequest {
        boolean valid;
        boolean needCloseValidationInput;
        InputStream data;
        block26: {
            data = null;
            boolean canReset = false;
            needCloseValidationInput = false;
            if (validationInput instanceof DetailedFileInputStream) {
                logMetacat.debug((Object)("NonXMLMetadataHandler.checkValidation - in the DetailedFileInputStream route for pid " + pid.getValue()));
                DetailedFileInputStream input = (DetailedFileInputStream)validationInput;
                File sourceFile = input.getFile();
                try {
                    validationInput = new FileInputStream(sourceFile);
                    data = input;
                    needCloseValidationInput = true;
                }
                catch (FileNotFoundException e) {
                    throw new ServiceFailure("1190", "NonXMLMetadataHandler.checkValidation - cannot valid the meta data object  because cannot find the file associated with the detailed file input stream  for the object " + pid.getValue() + " since " + e.getMessage());
                }
            }
            if (validationInput.markSupported() && validationInput instanceof ByteArrayInputStream) {
                logMetacat.debug((Object)("NonXMLMetadataHandler.checkValidation - in the resetable input stream route for pid " + pid.getValue()));
                data = validationInput;
                canReset = true;
            } else {
                logMetacat.debug((Object)("NonXMLMetadataHandler.checkValidation - in the another type of the input stream route for pid " + pid.getValue()));
                FileOutputStream out = null;
                try {
                    this.tmpFile = NonXMLMetadataHandler.generateTempFile("NonXML");
                    out = new FileOutputStream(this.tmpFile);
                    IOUtils.copyLarge((InputStream)validationInput, (OutputStream)out);
                    validationInput = new FileInputStream(this.tmpFile);
                    data = new FileInputStream(this.tmpFile);
                }
                catch (IOException e) {
                    try {
                        if (this.tmpFile == null) throw new ServiceFailure("1190", "NonXMLMetadataHandler.checkValidation - cannot save the meta data object " + pid.getValue() + " into a temporary file since " + e.getMessage());
                        this.tmpFile.delete();
                        throw new ServiceFailure("1190", "NonXMLMetadataHandler.checkValidation - cannot save the meta data object " + pid.getValue() + " into a temporary file since " + e.getMessage());
                    }
                    catch (Throwable throwable) {
                        try {
                            IOUtils.close(out);
                            throw throwable;
                        }
                        catch (IOException e2) {
                            logMetacat.warn((Object)("NonXMLMetadataHandler.checkValidation - cannot close the out put stream after saving the object for pid " + pid.getValue() + "into a temporary file"));
                        }
                        throw throwable;
                    }
                }
                try {
                    IOUtils.close((Closeable)out);
                }
                catch (IOException e) {
                    logMetacat.warn((Object)("NonXMLMetadataHandler.checkValidation - cannot close the out put stream after saving the object for pid " + pid.getValue() + "into a temporary file"));
                }
            }
            valid = false;
            try {
                valid = this.validate(validationInput);
                if (!canReset) break block26;
                try {
                    data.reset();
                }
                catch (IOException e) {
                    throw new ServiceFailure("1190", "NonXMLMetadataHandler.checkValidation - cannot save the object  because Metacat cannot reset the input stream even though the inputstream " + data.getClass().getCanonicalName() + " for the object " + pid.getValue() + " claim sit is resetable since " + e.getMessage());
                }
            }
            catch (InvalidRequest e) {
                try {
                    if (this.tmpFile != null) {
                        this.tmpFile.delete();
                    }
                    if (validationInput == null) throw new InvalidRequest("1102", "NonXMLMetadataHandler.checkValidation - the metadata object " + pid.getValue() + " is invalid: " + e.getMessage());
                    validationInput.close();
                    throw new InvalidRequest("1102", "NonXMLMetadataHandler.checkValidation - the metadata object " + pid.getValue() + " is invalid: " + e.getMessage());
                }
                catch (IOException ee) {
                    logMetacat.warn((Object)("NonXMLMetadataHandler.checkValidation - cannot close the invalidation stream since " + ee.getMessage()));
                }
                throw new InvalidRequest("1102", "NonXMLMetadataHandler.checkValidation - the metadata object " + pid.getValue() + " is invalid: " + e.getMessage());
            }
        }
        if (!valid) {
            try {
                if (this.tmpFile != null) {
                    this.tmpFile.delete();
                }
                if (validationInput == null) throw new InvalidRequest("1102", "NonXMLMetadataHandler.checkValidation - the metadata object " + pid.getValue() + " is invalid.");
                validationInput.close();
                throw new InvalidRequest("1102", "NonXMLMetadataHandler.checkValidation - the metadata object " + pid.getValue() + " is invalid.");
            }
            catch (IOException ee) {
                logMetacat.warn((Object)("NonXMLMetadataHandler.checkValidation - cannot close the invalidation stream since " + ee.getMessage()));
            }
            throw new InvalidRequest("1102", "NonXMLMetadataHandler.checkValidation - the metadata object " + pid.getValue() + " is invalid.");
        }
        if (!needCloseValidationInput) return data;
        try {
            validationInput.close();
            return data;
        }
        catch (IOException e) {
            throw new ServiceFailure("1190", "NonXMLMetadataHandler.checkValidation - cannot save the object  because Metacat cannot reset the input stream even though the inputstream " + data.getClass().getCanonicalName() + " for the object " + pid.getValue() + " claim sit is resetable since " + e.getMessage());
        }
    }

    public abstract boolean validate(InputStream var1) throws InvalidRequest;

    private static File generateTempFile(String prefix) throws IOException {
        File tmpDir = null;
        try {
            tmpDir = new File(PropertyService.getProperty("application.tempDir"));
        }
        catch (PropertyNotFoundException pnfe) {
            logMetacat.error((Object)"NonXMLMetadataHandler.generateTempFile: application.tmpDir not found.  Using /tmp instead.");
            tmpDir = new File("/tmp");
        }
        String newPrefix = prefix + "-" + System.currentTimeMillis();
        String suffix = null;
        File newFile = null;
        try {
            newFile = File.createTempFile(newPrefix, suffix, tmpDir);
        }
        catch (Exception e) {
            newFile = File.createTempFile(newPrefix, suffix, tmpDir);
        }
        logMetacat.debug((Object)("StreamingMultiplePartRequestResolver.generateTmepFile - the new file  is " + newFile.getCanonicalPath()));
        return newFile;
    }

    static {
        try {
            metadataStoragePath = PropertyService.getProperty("application.documentfilepath");
        }
        catch (PropertyNotFoundException e) {
            logMetacat.error((Object)("NonXMLMetadataHandler.static - cannot find the metadata object storage path since " + e.getMessage()));
        }
    }
}

