/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat.properties;

import edu.ucsb.nceas.metacat.properties.PropertiesInterface;
import edu.ucsb.nceas.metacat.shared.BaseService;
import edu.ucsb.nceas.metacat.shared.ServiceException;
import edu.ucsb.nceas.utilities.FileUtil;
import edu.ucsb.nceas.utilities.GeneralPropertyException;
import edu.ucsb.nceas.utilities.PropertiesMetaData;
import edu.ucsb.nceas.utilities.PropertyNotFoundException;
import edu.ucsb.nceas.utilities.SortedProperties;
import java.util.Map;
import java.util.Vector;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dataone.configuration.Settings;

public class PropertyService
extends BaseService {
    private static PropertyService propertyService = null;
    private static PropertiesInterface properties = null;
    public static final String CONFIGURED = "true";
    public static final String UNCONFIGURED = "false";
    public static final String BYPASSED = "bypassed";
    private static String DEFAULT_CONFIG_FILE_DIR = "WEB-INF";
    public static String CONFIG_FILE_DIR = null;
    public static String CONFIG_FILE_NAME = null;
    public static String CONFIG_FILE_PATH = null;
    public static String TEST_CONFIG_FILE_NAME = null;
    private static String DEFAULT_PROPERTY_CLASS_NAME = "edu.ucsb.nceas.metacat.properties.ConfigurableProperties";
    private static String PROPERTY_CLASS_NAME = null;
    private static String RECOMMENDED_EXTERNAL_DIR = null;
    private static Log logMetacat = LogFactory.getLog(PropertyService.class);

    private PropertyService() throws ServiceException {
        this._serviceName = "PropertyService";
        this.initialize();
    }

    public static PropertyService getInstance(ServletContext context) throws ServiceException {
        if (propertyService == null) {
            String applicationName = (String)context.getAttribute("APPLICATION_NAME");
            CONFIG_FILE_DIR = context.getInitParameter("configFileDir");
            if (CONFIG_FILE_DIR == null) {
                String configDir;
                CONFIG_FILE_DIR = configDir = context.getRealPath(DEFAULT_CONFIG_FILE_DIR);
            }
            CONFIG_FILE_PATH = CONFIG_FILE_DIR + FileUtil.getFS() + applicationName + ".properties";
            PROPERTY_CLASS_NAME = context.getInitParameter("propertyClassName");
            if (PROPERTY_CLASS_NAME == null) {
                PROPERTY_CLASS_NAME = DEFAULT_PROPERTY_CLASS_NAME;
            }
            propertyService = new PropertyService();
        }
        return propertyService;
    }

    public static PropertyService getInstance(String testConfigFileDir) throws ServiceException {
        if (propertyService == null) {
            CONFIG_FILE_DIR = testConfigFileDir;
            PROPERTY_CLASS_NAME = DEFAULT_PROPERTY_CLASS_NAME;
            propertyService = new PropertyService();
        }
        return propertyService;
    }

    public static PropertyService getInstance() throws ServiceException {
        if (propertyService == null) {
            throw new ServiceException("PropertyService.getInstance - cannot call getInstance without parameters until property service has been created with either servlet context or config file path.");
        }
        return propertyService;
    }

    @Override
    public boolean refreshable() {
        return true;
    }

    @Override
    public void doRefresh() throws ServiceException {
        this.initialize();
    }

    @Override
    public void stop() throws ServiceException {
    }

    private void initialize() throws ServiceException {
        logMetacat.debug((Object)"Initializing PropertyService");
        try {
            Class<?> classDef = Class.forName(PROPERTY_CLASS_NAME);
            properties = (PropertiesInterface)classDef.newInstance();
        }
        catch (InstantiationException ie) {
            throw new ServiceException("Could not instantiate property class: " + PROPERTY_CLASS_NAME + " " + ie.getMessage());
        }
        catch (IllegalAccessException iae) {
            throw new ServiceException("Access error when intantiating property class: " + PROPERTY_CLASS_NAME + " " + iae.getMessage());
        }
        catch (ClassNotFoundException cnfe) {
            throw new ServiceException("Could not find property class: " + PROPERTY_CLASS_NAME + " " + cnfe.getMessage());
        }
    }

    public static String getProperty(String propertyName) throws PropertyNotFoundException {
        return properties.getProperty(propertyName);
    }

    public static Vector<String> getPropertyNames() {
        return properties.getPropertyNames();
    }

    public static Vector<String> getPropertyNamesByGroup(String groupName) {
        return properties.getPropertyNamesByGroup(groupName);
    }

    public static Map<String, String> getPropertiesByGroup(String groupName) throws PropertyNotFoundException {
        return properties.getPropertiesByGroup(groupName);
    }

    public static void setProperty(String propertyName, String newValue) throws GeneralPropertyException {
        properties.setProperty(propertyName, newValue);
        properties.persistProperties();
    }

    public static void addProperty(String propertyName, String value) throws GeneralPropertyException {
        properties.addProperty(propertyName, value);
        properties.persistProperties();
    }

    public static void setPropertyNoPersist(String propertyName, String newValue) throws GeneralPropertyException {
        properties.setPropertyNoPersist(propertyName, newValue);
    }

    public static void persistProperties() throws GeneralPropertyException {
        properties.persistProperties();
    }

    public static SortedProperties getMainBackupProperties() throws GeneralPropertyException {
        return properties.getMainBackupProperties();
    }

    public static SortedProperties getAuthBackupProperties() throws GeneralPropertyException {
        return properties.getAuthBackupProperties();
    }

    public static PropertiesMetaData getMainMetaData() throws GeneralPropertyException {
        return properties.getMainMetaData();
    }

    public static PropertiesMetaData getAuthMetaData() throws GeneralPropertyException {
        return properties.getAuthMetaData();
    }

    public static void persistMainBackupProperties() throws GeneralPropertyException {
        properties.persistMainBackupProperties();
    }

    public static void persistAuthBackupProperties(ServletContext servletContext) throws GeneralPropertyException {
        properties.persistAuthBackupProperties(servletContext);
    }

    public static boolean arePropertiesConfigured() throws GeneralPropertyException {
        return properties.arePropertiesConfigured();
    }

    public static boolean doBypass() throws GeneralPropertyException {
        return properties.doBypass();
    }

    public static void bypassConfiguration() throws GeneralPropertyException {
        properties.bypassConfiguration();
    }

    public static boolean checkAndSetProperty(HttpServletRequest request, String propertyName) throws GeneralPropertyException {
        return properties.checkAndSetProperty(request, propertyName);
    }

    public static void setRecommendedExternalDir(String extBaseDir) {
        RECOMMENDED_EXTERNAL_DIR = extBaseDir;
    }

    public static String getRecommendedExternalDir() {
        return RECOMMENDED_EXTERNAL_DIR;
    }

    public static void syncToSettings() throws GeneralPropertyException {
        try {
            Settings.getConfiguration();
            Settings.augmentConfiguration((String)CONFIG_FILE_PATH);
        }
        catch (ConfigurationException e) {
            e.printStackTrace();
            throw new GeneralPropertyException(e.getMessage());
        }
    }
}

