/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat.replication;

import edu.ucsb.nceas.metacat.properties.PropertyService;
import edu.ucsb.nceas.metacat.replication.ReplicationServer;
import edu.ucsb.nceas.metacat.replication.ReplicationServerList;
import edu.ucsb.nceas.metacat.replication.ReplicationService;
import edu.ucsb.nceas.metacat.shared.ServiceException;
import edu.ucsb.nceas.metacat.util.MetacatUtil;
import edu.ucsb.nceas.utilities.PropertyNotFoundException;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ForceReplicationHandler
implements Runnable {
    private Thread btThread;
    private String docid;
    private String action;
    private boolean xmlDocument;
    private boolean dbactionFlag = true;
    private ReplicationServerList serverLists = null;
    private int homeServerCode = 0;
    private String notificationServer = null;
    private static Log logReplication = LogFactory.getLog((String)"ReplicationLogging");
    private static Log logMetacat = LogFactory.getLog(ForceReplicationHandler.class);

    public ForceReplicationHandler(String docid, String action, boolean xml, String myNotificationServer) {
        this.docid = docid;
        this.action = action;
        this.xmlDocument = xml;
        this.serverLists = new ReplicationServerList();
        try {
            this.homeServerCode = ReplicationService.getHomeServerCodeForDocId(docid);
        }
        catch (ServiceException se) {
            logMetacat.error((Object)("ForceReplicationHandler() - " + ReplicationService.METACAT_REPL_ERROR_MSG));
            logReplication.error((Object)("ForceReplicationHandler() - Service issue in constructor: " + se.getMessage()));
        }
        this.notificationServer = myNotificationServer;
        if (this.action.equals("")) {
            this.dbactionFlag = false;
        }
        this.btThread = new Thread(this);
        this.btThread.setPriority(1);
        this.btThread.start();
    }

    public ForceReplicationHandler(String docid, boolean xml, String myNotificationServer) {
        this.docid = docid;
        this.xmlDocument = xml;
        this.dbactionFlag = false;
        this.serverLists = new ReplicationServerList();
        try {
            this.homeServerCode = ReplicationService.getHomeServerCodeForDocId(docid);
        }
        catch (ServiceException se) {
            logMetacat.error((Object)("ForceReplicationHandler() - " + ReplicationService.METACAT_REPL_ERROR_MSG));
            logReplication.error((Object)("ForceReplicationHandler()- Service issue in constructor: " + se.getMessage()));
        }
        this.notificationServer = myNotificationServer;
        this.btThread = new Thread(this);
        this.btThread.setPriority(1);
        this.btThread.start();
    }

    @Override
    public void run() {
        URL comeAndGetIt = null;
        if (this.serverLists.isEmpty()) {
            return;
        }
        try {
            int sleepTime = Integer.parseInt(PropertyService.getProperty("replication.forcereplicationwaitingtime"));
            Thread.sleep(sleepTime);
        }
        catch (PropertyNotFoundException pnfe) {
            logMetacat.error((Object)("ForceReplicationHandler.run - " + ReplicationService.METACAT_REPL_ERROR_MSG));
            logReplication.error((Object)("ForceReplicationHandler.run - property error: " + pnfe.getMessage()));
        }
        catch (InterruptedException ie) {
            logMetacat.error((Object)("ForceReplicationHandler.run - " + ReplicationService.METACAT_REPL_ERROR_MSG));
            logReplication.error((Object)("ForceReplicationHandler.run - Thread sleep error: " + ie.getMessage()));
        }
        logReplication.info((Object)("ForceReplicationHandler.run - notification server:" + this.notificationServer));
        for (int i = 0; i < this.serverLists.size(); ++i) {
            comeAndGetIt = null;
            ReplicationServer replicationServer = this.serverLists.serverAt(i);
            String server = replicationServer.getServerName();
            try {
                if (server == null || server.equals(this.notificationServer)) continue;
                if (this.dbactionFlag) {
                    if (this.xmlDocument && replicationServer.getReplication()) {
                        if (this.homeServerCode == 1) {
                            logReplication.info((Object)("ForceReplicationHandler.run - force xml replicating to " + server));
                            comeAndGetIt = new URL("https://" + server + "?action=forcereplicate&server=" + MetacatUtil.getLocalReplicationServerName() + "&docid=" + this.docid + "&dbaction=" + this.action);
                            if (this.action != null && (this.action.equals("forcereplicatedelete") || this.action.equals("forcereplicatedeleteall"))) {
                                comeAndGetIt = new URL("https://" + server + "?action=" + this.action + "&docid=" + this.docid + "&server=" + MetacatUtil.getLocalReplicationServerName());
                            }
                        } else if (replicationServer.getHub() || server.equals(ReplicationService.getServerNameForServerCode(this.homeServerCode))) {
                            logReplication.info((Object)("ForceReplicationHandler.run - force xml replicating to " + server));
                            comeAndGetIt = new URL("https://" + server + "?action=forcereplicate&server=" + MetacatUtil.getLocalReplicationServerName() + "&docid=" + this.docid + "&dbaction=" + this.action);
                            if (this.action != null && (this.action.equals("forcereplicatedelete") || this.action.equals("forcereplicatedeleteall"))) {
                                comeAndGetIt = new URL("https://" + server + "?action=" + this.action + "&docid=" + this.docid + "&server=" + MetacatUtil.getLocalReplicationServerName());
                            }
                        }
                    } else if (replicationServer.getDataReplication()) {
                        if (this.homeServerCode == 1) {
                            logReplication.info((Object)("ForceReplicationHandler.run - force data replicating to " + server));
                            comeAndGetIt = new URL("https://" + server + "?action=forcereplicatedatafile&server=" + MetacatUtil.getLocalReplicationServerName() + "&docid=" + this.docid + "&dbaction=" + this.action);
                            if (this.action != null && (this.action.equals("forcereplicatedelete") || this.action.equals("forcereplicatedeleteall"))) {
                                comeAndGetIt = new URL("https://" + server + "?action=" + this.action + "&docid=" + this.docid + "&server=" + MetacatUtil.getLocalReplicationServerName());
                            }
                        } else if (replicationServer.getHub() || server.equals(ReplicationService.getServerNameForServerCode(this.homeServerCode))) {
                            logReplication.info((Object)("ForceReplicationHandler.run - force data replicating to " + server));
                            comeAndGetIt = new URL("https://" + server + "?action=forcereplicatedatafile&server=" + MetacatUtil.getLocalReplicationServerName() + "&docid=" + this.docid + "&dbaction=" + this.action);
                            if (this.action != null && (this.action.equals("forcereplicatedelete") || this.action.equals("forcereplicatedeleteall"))) {
                                comeAndGetIt = new URL("https://" + server + "?action=" + this.action + "&docid=" + this.docid + "&server=" + MetacatUtil.getLocalReplicationServerName());
                            }
                        }
                    }
                } else {
                    logReplication.info((Object)("ForceReplicationHandler.run - force replicating (default action) to )" + server));
                    if (this.xmlDocument && replicationServer.getReplication()) {
                        if (this.homeServerCode == 1) {
                            comeAndGetIt = new URL("https://" + server + "?action=forcereplicate&server=" + MetacatUtil.getLocalReplicationServerName() + "&docid=" + this.docid);
                        } else if (replicationServer.getHub() || server.equals(ReplicationService.getServerNameForServerCode(this.homeServerCode))) {
                            comeAndGetIt = new URL("https://" + server + "?action=forcereplicate&server=" + MetacatUtil.getLocalReplicationServerName() + "&docid=" + this.docid);
                        }
                    } else if (replicationServer.getDataReplication()) {
                        if (this.homeServerCode == 1) {
                            comeAndGetIt = new URL("https://" + server + "?action=forcereplicatedatafile&server=" + MetacatUtil.getLocalReplicationServerName() + "&docid=" + this.docid);
                        } else if (replicationServer.getHub() || server.equals(ReplicationService.getServerNameForServerCode(this.homeServerCode))) {
                            comeAndGetIt = new URL("https://" + server + "?action=forcereplicatedatafile&server=" + MetacatUtil.getLocalReplicationServerName() + "&docid=" + this.docid);
                        }
                    }
                }
                if (comeAndGetIt == null || comeAndGetIt.equals("")) continue;
                logReplication.warn((Object)("ForceReplicationHandler.run - sending message: " + comeAndGetIt.toString()));
                String string = ReplicationService.getURLContent(comeAndGetIt);
                continue;
            }
            catch (MalformedURLException mue) {
                logMetacat.error((Object)("ForceReplicationHandler.run - " + ReplicationService.METACAT_REPL_ERROR_MSG));
                logReplication.error((Object)("ForceReplicationHandler.run - URL error in ForceReplicationHandler.run for server " + server + " : " + mue.getMessage()));
                continue;
            }
            catch (Exception io) {
                logMetacat.error((Object)("ForceReplicationHandler.run - " + ReplicationService.METACAT_REPL_ERROR_MSG));
                logReplication.error((Object)("ForceReplicationHandler.run - Error in ForceReplicationHandler.run for server " + server + " : " + io.getMessage()));
            }
        }
        logReplication.warn((Object)"ForceReplicationHandler.run - exiting ForceReplicationHandler Thread");
    }
}

