/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat.restservice;

import edu.ucsb.nceas.metacat.AuthSession;
import edu.ucsb.nceas.metacat.properties.PropertyService;
import edu.ucsb.nceas.metacat.restservice.multipart.MultipartRequestWithSysmeta;
import edu.ucsb.nceas.metacat.restservice.multipart.StreamingMultipartRequestResolver;
import edu.ucsb.nceas.metacat.service.SessionService;
import edu.ucsb.nceas.metacat.util.RequestUtil;
import edu.ucsb.nceas.metacat.util.SessionData;
import edu.ucsb.nceas.utilities.PropertyNotFoundException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dataone.client.v2.itk.D1Client;
import org.dataone.configuration.Settings;
import org.dataone.exceptions.MarshallingException;
import org.dataone.mimemultipart.MultipartRequest;
import org.dataone.mimemultipart.MultipartRequestResolver;
import org.dataone.portal.PortalCertificateManager;
import org.dataone.service.exceptions.BaseException;
import org.dataone.service.exceptions.InvalidRequest;
import org.dataone.service.exceptions.NotFound;
import org.dataone.service.exceptions.ServiceFailure;
import org.dataone.service.types.v1.Group;
import org.dataone.service.types.v1.Person;
import org.dataone.service.types.v1.Session;
import org.dataone.service.types.v1.Subject;
import org.dataone.service.types.v1.SubjectInfo;

public class D1ResourceHandler {
    public static final byte GET = 1;
    public static final byte POST = 2;
    public static final byte PUT = 3;
    public static final byte DELETE = 4;
    public static final byte HEAD = 5;
    protected static int MAX_UPLOAD_SIZE = 1000000000;
    protected static final String RESOURCE_BASE_URL = "d1";
    protected static final String RESOURCE_OBJECTS = "object";
    protected static final String RESOURCE_META = "meta";
    protected static final String RESOURCE_LOG = "log";
    protected static final String RESOURCE_QUERY = "query";
    protected static final String RESOURCE_IS_AUTHORIZED = "isAuthorized";
    protected static final String RESOURCE_ACCESS_RULES = "accessRules";
    protected static final String RESOURCE_VIEWS = "views";
    protected static final String FUNCTION_NAME_INSERT = "insert";
    protected static final String FUNCTION_NAME_UPDATE = "update";
    protected static AuthSession auth = null;
    protected static int authCacheSzie = Settings.getConfiguration().getInt("auth.groupCacheSize", 100);
    protected static boolean enableAppendLdapGroups = Settings.getConfiguration().getBoolean("dataone.session.appendLdapGroups.enabled", true);
    protected ServletContext servletContext;
    protected static Log logMetacat;
    protected HttpServletRequest request;
    protected HttpServletResponse response;
    protected boolean enableSessionFromHeader = false;
    protected String proxyKey = null;
    protected Hashtable<String, String[]> params;
    protected Map<String, List<String>> multipartparams;
    protected Session session;

    public D1ResourceHandler(ServletContext servletContext, HttpServletRequest request, HttpServletResponse response) {
        this.servletContext = servletContext;
        this.request = request;
        this.response = response;
        logMetacat = LogFactory.getLog(D1ResourceHandler.class);
        try {
            MAX_UPLOAD_SIZE = Integer.parseInt(PropertyService.getProperty("dataone.max_upload_size"));
            this.enableSessionFromHeader = Boolean.parseBoolean(PropertyService.getProperty("dataone.certificate.fromHttpHeader.enabled"));
            this.proxyKey = PropertyService.getProperty("dataone.certificate.fromHttpHeader.proxyKey");
        }
        catch (PropertyNotFoundException e) {
            logMetacat.warn((Object)"Property not found: dataone.max_upload_size");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(byte httpVerb) {
        logMetacat = LogFactory.getLog(D1ResourceHandler.class);
        try {
            this.session = PortalCertificateManager.getInstance().getSession(this.request);
            if (this.session == null) {
                SessionData sessionData = RequestUtil.getSessionData(this.request);
                if (sessionData != null && !SessionService.getInstance().getPublicSession().getUserName().equals(sessionData.getUserName())) {
                    this.session = new Session();
                    String userName = sessionData.getUserName();
                    String[] groupNames = sessionData.getGroupNames();
                    Subject userSubject = new Subject();
                    userSubject.setValue(userName);
                    this.session.setSubject(userSubject);
                    SubjectInfo subjectInfo = new SubjectInfo();
                    Person person = new Person();
                    person.setSubject(userSubject);
                    if (groupNames != null && groupNames.length > 0) {
                        for (String groupName : groupNames) {
                            Group group = new Group();
                            group.setGroupName(groupName);
                            Subject groupSubject = new Subject();
                            groupSubject.setValue(groupName);
                            group.setSubject(groupSubject);
                            subjectInfo.addGroup(group);
                            person.addIsMemberOf(groupSubject);
                        }
                    }
                    subjectInfo.addPerson(person);
                    this.session.setSubjectInfo(subjectInfo);
                }
            } else if (enableAppendLdapGroups) {
                logMetacat.debug((Object)"D1ReourceHandler.handle - Metacat is configured to append the local ldap group information to a session.");
                Subject subject = this.session.getSubject();
                if (subject != null) {
                    String dn = subject.getValue();
                    logMetacat.debug((Object)("D1ReourceHandler.handle - the subject dn in the session is " + dn + " This dn will be used to look up the group information"));
                    if (dn != null) {
                        String username = null;
                        String password = null;
                        String[] groups = null;
                        if (auth == null) {
                            try {
                                Class<D1ResourceHandler> person = D1ResourceHandler.class;
                                synchronized (D1ResourceHandler.class) {
                                    if (auth == null) {
                                        auth = new AuthSession(authCacheSzie);
                                    }
                                    // ** MonitorExit[person] (shouldn't be in output)
                                    groups = auth.getGroups(username, password, dn);
                                }
                            }
                            catch (Exception e) {
                                logMetacat.warn((Object)("D1ReourceHandler.handle - we can't get group information for the user " + dn + " from the authentication interface since :"), (Throwable)e);
                            }
                        } else {
                            try {
                                groups = auth.getGroups(username, password, dn);
                            }
                            catch (Exception e) {
                                logMetacat.warn((Object)("D1ReourceHandler.handle - we can't get group information for the user " + dn + " from the authentication interface since :"), (Throwable)e);
                            }
                        }
                        {
                            if (groups != null) {
                                SubjectInfo subjectInfo = this.session.getSubjectInfo();
                                if (subjectInfo != null) {
                                    logMetacat.debug((Object)"D1ReourceHandler.handle - the subject information is NOT null when we try to figure out the group information.");
                                    List persons = subjectInfo.getPersonList();
                                    Person targetPerson = null;
                                    if (persons != null) {
                                        for (Person person : persons) {
                                            if (!person.getSubject().equals((Object)subject)) continue;
                                            targetPerson = person;
                                            logMetacat.debug((Object)("D1ReourceHandler.handle - we find a person with the subject " + dn + " in the subject info."));
                                            break;
                                        }
                                    }
                                    boolean newPerson = false;
                                    if (targetPerson == null) {
                                        newPerson = true;
                                        targetPerson = new Person();
                                        targetPerson.setSubject(subject);
                                    }
                                    for (int i = 0; i < groups.length; ++i) {
                                        logMetacat.debug((Object)("D1ReourceHandler.handle - create the group " + groups[i] + " for an existing subject info."));
                                        Group group = new Group();
                                        group.setGroupName(groups[i]);
                                        Subject groupSubject = new Subject();
                                        groupSubject.setValue(groups[i]);
                                        group.setSubject(groupSubject);
                                        subjectInfo.addGroup(group);
                                        targetPerson.addIsMemberOf(groupSubject);
                                    }
                                    if (newPerson) {
                                        subjectInfo.addPerson(targetPerson);
                                    }
                                } else {
                                    logMetacat.debug((Object)"D1ReourceHandler.handle - the subject information is NOT null when we try to figure out the group information.");
                                    subjectInfo = new SubjectInfo();
                                    Person person = new Person();
                                    person.setSubject(subject);
                                    for (int i = 0; i < groups.length; ++i) {
                                        logMetacat.debug((Object)("D1ReourceHandler.handle - create the group " + groups[i] + " for a new subject info."));
                                        Group group = new Group();
                                        group.setGroupName(groups[i]);
                                        Subject groupSubject = new Subject();
                                        groupSubject.setValue(groups[i]);
                                        group.setSubject(groupSubject);
                                        subjectInfo.addGroup(group);
                                        person.addIsMemberOf(groupSubject);
                                    }
                                    subjectInfo.addPerson(person);
                                    this.session.setSubjectInfo(subjectInfo);
                                }
                            }
                        }
                    }
                }
            } else {
                logMetacat.debug((Object)"D1ReourceHandler.handle - Metacat is configured NOT to append the local ldap group information to a session.");
            }
            {
                if (this.session == null) {
                    this.getSessionFromHeader();
                }
                this.params = new Hashtable();
                this.initParams();
            }
        }
        catch (Exception e) {
            this.response.setStatus(400);
            this.printError("Incorrect resource!", this.response);
            logMetacat.error((Object)(e.getClass() + ": " + e.getMessage()), (Throwable)e);
        }
    }

    protected boolean isD1Enabled() {
        return true;
    }

    protected String parseTrailing(String resource, String token) {
        String extra = null;
        if (resource.indexOf(token) != -1) {
            extra = resource.substring(resource.indexOf(token) + token.length());
            if (extra.startsWith("/")) {
                extra = extra.substring(1);
            }
            if (extra.length() == 0) {
                extra = null;
            }
        }
        return extra;
    }

    protected void collectMultipartParams() throws IOException, FileUploadException, Exception {
        File tmpDir = D1ResourceHandler.getTempDirectory();
        MultipartRequest mr = null;
        logMetacat.debug((Object)"Parsing rights holder info from the mime multipart entity");
        MultipartRequestResolver mrr = new MultipartRequestResolver(tmpDir.getAbsolutePath(), MAX_UPLOAD_SIZE, 0);
        mr = mrr.resolveMultipart(this.request);
        logMetacat.debug((Object)"Resolved the rights holder info from the mime multipart entity.");
        this.multipartparams = mr.getMultipartParameters();
    }

    protected Map<String, File> collectMultipartFiles() throws ServiceFailure, InvalidRequest {
        logMetacat.debug((Object)"Disassembling MIME multipart form");
        File tmpDir = D1ResourceHandler.getTempDirectory();
        logMetacat.debug((Object)("temp dir: " + tmpDir.getAbsolutePath()));
        MultipartRequestResolver mrr = new MultipartRequestResolver(tmpDir.getAbsolutePath(), MAX_UPLOAD_SIZE, 0);
        MultipartRequest mr = null;
        try {
            mr = mrr.resolveMultipart(this.request);
        }
        catch (Exception e) {
            throw new ServiceFailure("1202", "Could not resolve multipart files: " + e.getMessage());
        }
        logMetacat.debug((Object)"resolved multipart request");
        Map files = mr.getMultipartFiles();
        if (files == null) {
            throw new ServiceFailure("1202", "no multipart files found");
        }
        logMetacat.debug((Object)"got multipart files");
        if (files.keySet() == null) {
            logMetacat.error((Object)"No file keys in MMP request.");
            throw new ServiceFailure("1202", "No file keys found in MMP.");
        }
        this.multipartparams = mr.getMultipartParameters();
        if (logMetacat.isDebugEnabled()) {
            String key;
            Iterator<Object> it = files.keySet().iterator();
            logMetacat.debug((Object)"iterating through files");
            while (it.hasNext()) {
                key = (String)it.next();
                logMetacat.debug((Object)("files key: " + key));
                logMetacat.debug((Object)("files value: " + files.get(key)));
            }
            it = this.multipartparams.keySet().iterator();
            logMetacat.debug((Object)"iterating through multipartparams");
            while (it.hasNext()) {
                key = (String)it.next();
                logMetacat.debug((Object)("multipartparams key: " + key));
                logMetacat.debug((Object)("multipartparams value: " + this.multipartparams.get(key)));
            }
            it = this.params.keySet().iterator();
            logMetacat.debug((Object)"iterating through params");
            while (it.hasNext()) {
                key = (String)it.next();
                logMetacat.debug((Object)("param key: " + key));
                logMetacat.debug((Object)("param value: " + this.params.get(key)));
            }
            logMetacat.debug((Object)"done iterating the request...");
        }
        return files;
    }

    protected MultipartRequestWithSysmeta collectObjectFiles() throws IOException, FileUploadException, InstantiationException, IllegalAccessException, NoSuchAlgorithmException, MarshallingException {
        logMetacat.debug((Object)"Disassembling MIME multipart form with object files");
        File tmpDir = D1ResourceHandler.getTempDirectory();
        logMetacat.debug((Object)("temp dir: " + tmpDir.getAbsolutePath()));
        StreamingMultipartRequestResolver resolver = new StreamingMultipartRequestResolver(tmpDir.getAbsolutePath(), MAX_UPLOAD_SIZE);
        MultipartRequestWithSysmeta mq = null;
        mq = (MultipartRequestWithSysmeta)resolver.resolveMultipart(this.request);
        this.multipartparams = mq.getMultipartParameters();
        return mq;
    }

    protected void initParams() {
        String name = null;
        String[] value = null;
        Enumeration paramlist = this.request.getParameterNames();
        while (paramlist.hasMoreElements()) {
            name = (String)paramlist.nextElement();
            value = this.request.getParameterValues(name);
            this.params.put(name, value);
        }
    }

    protected void initMultipartParams() throws Exception {
        logMetacat.debug((Object)"Disassembling MIME multipart form");
        File tmpDir = D1ResourceHandler.getTempDirectory();
        logMetacat.debug((Object)("temp dir: " + tmpDir.getAbsolutePath()));
        MultipartRequestResolver mrr = new MultipartRequestResolver(tmpDir.getAbsolutePath(), MAX_UPLOAD_SIZE, 0);
        MultipartRequest mr = mrr.resolveMultipart(this.request);
        this.multipartparams = mr.getMultipartParameters();
    }

    protected static String[] findBoundaryString(InputStream is) throws IOException {
        String[] endResult = new String[2];
        String boundary = "";
        String searchString = "boundary=";
        byte[] b = new byte[1024];
        int numbytes = is.read(b, 0, 1024);
        while (numbytes != -1) {
            String s = new String(b, 0, numbytes);
            int searchStringIndex = s.indexOf(searchString);
            if (s.indexOf("\"", searchStringIndex + searchString.length() + 1) == -1) {
                boundary = s.substring(searchStringIndex + searchString.length() + 1, s.length());
                continue;
            }
            if (!boundary.startsWith("--")) {
                boundary = s.substring(searchStringIndex + searchString.length() + 1, s.indexOf("\"", searchStringIndex + searchString.length() + 1));
                endResult[0] = boundary = "--" + boundary;
                endResult[1] = s.substring(s.indexOf("\"", searchStringIndex + searchString.length() + 1) + 1, s.length());
                break;
            }
            searchString = "\"";
            searchStringIndex = s.indexOf(searchString);
            boundary = boundary + s.substring(0, searchStringIndex);
            endResult[0] = boundary = "--" + boundary;
            endResult[1] = s.substring(s.indexOf("\"", searchStringIndex + searchString.length() + 1) + 1, s.length());
            break;
        }
        return endResult;
    }

    protected static File getTempDirectory() {
        File tmpDir = null;
        Log logMetacat = LogFactory.getLog(D1ResourceHandler.class);
        try {
            tmpDir = new File(PropertyService.getProperty("application.tempDir"));
        }
        catch (PropertyNotFoundException pnfe) {
            logMetacat.error((Object)"D1ResourceHandler.writeMMPPartstoFiles: application.tmpDir not found.  Using /tmp instead.");
            tmpDir = new File("/tmp");
        }
        return tmpDir;
    }

    protected void printError(String message, HttpServletResponse response) {
        try {
            logMetacat.error((Object)("D1ResourceHandler: Printing error to servlet response: " + message));
            PrintWriter out = response.getWriter();
            response.setContentType("text/xml");
            out.println("<?xml version=\"1.0\"?>");
            out.println("<error>");
            out.println(message);
            out.println("</error>");
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void serializeException(BaseException e, OutputStream out) {
        this.response.setContentType("text/xml");
        this.response.setStatus(e.getCode());
        if (e instanceof NotFound) {
            logMetacat.info((Object)("D1ResourceHandler: Serializing exception with code " + e.getCode() + ": " + e.getMessage()));
        } else {
            logMetacat.error((Object)("D1ResourceHandler: Serializing exception with code " + e.getCode() + ": " + e.getMessage()), (Throwable)e);
        }
        try {
            IOUtils.write((String)e.serialize(0), (OutputStream)out);
        }
        catch (IOException e1) {
            logMetacat.error((Object)("Error writing exception to stream. " + e1.getMessage()));
        }
        finally {
            IOUtils.closeQuietly((OutputStream)out);
        }
    }

    public static String decode(String s) {
        String result = null;
        if (s != null) {
            try {
                result = URLDecoder.decode(s, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                result = URLDecoder.decode(s);
            }
            logMetacat.info((Object)("D1ResourceHandler.decode - the string after decoding is " + result));
        }
        return result;
    }

    protected void getSessionFromHeader() {
        if (this.enableSessionFromHeader) {
            logMetacat.debug((Object)"D1ResourceHandler.getSessionFromHeader - In the route to get the session from a http header");
            if (this.proxyKey == null || this.proxyKey.trim().equals("")) {
                logMetacat.warn((Object)"D1ResourceHandler.getSessionFromHeader - Metacat is not configured to handle the feature passing  the certificate by headers since the proxy key is blank");
                return;
            }
            String proxyKeyFromHttp = this.request.getHeader("X-Proxy-Key");
            if (proxyKeyFromHttp == null || proxyKeyFromHttp.trim().equals("")) {
                logMetacat.warn((Object)"D1ResourceHandler.getSessionFromHeader - the value of the header X-Proxy-Key is null or blank. So Metacat do NOT trust the request.");
                return;
            }
            if (!this.proxyKey.equals(proxyKeyFromHttp)) {
                logMetacat.warn((Object)"D1ResourceHandler.getSessionFromHeader - the value of the header X-Proxy-Key does not match the one  stored in Metacat. So Metacat do NOT trust the request.");
                return;
            }
            String verify = this.request.getHeader("Ssl-Client-Verify");
            logMetacat.info((Object)("D1ResourceHandler.getSessionFromHeader - the status of the ssl client verification is " + verify));
            if (verify != null && verify.equalsIgnoreCase("SUCCESS")) {
                String dn = this.request.getHeader("Ssl-Client-Subject-Dn");
                logMetacat.info((Object)("D1ResourceHandler.getSessionFromHeader - the ssl client was verified and the subject from the header is " + dn));
                if (dn != null) {
                    Subject subject = new Subject();
                    subject.setValue(dn);
                    this.session = new Session();
                    this.session.setSubject(subject);
                    SubjectInfo subjectInfo = null;
                    try {
                        subjectInfo = D1Client.getCN().getSubjectInfo(null, subject);
                    }
                    catch (Exception be) {
                        logMetacat.warn((Object)("D1ResourceHandler.getSessionFromHeader - can not get subject information for subject" + dn + " since " + be.getMessage()));
                    }
                    if (subjectInfo == null) {
                        subjectInfo = new SubjectInfo();
                        Person person = new Person();
                        person.setSubject(subject);
                        person.setFamilyName("Unknown");
                        person.addGivenName("Unknown");
                        subjectInfo.setPersonList(Arrays.asList(person));
                    }
                    this.session.setSubjectInfo(subjectInfo);
                }
            }
        }
    }
}

