/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat.restservice.v1;

import edu.ucsb.nceas.metacat.ReadOnlyChecker;
import edu.ucsb.nceas.metacat.common.query.stream.ContentTypeInputStream;
import edu.ucsb.nceas.metacat.dataone.D1AuthHelper;
import edu.ucsb.nceas.metacat.dataone.v1.MNodeService;
import edu.ucsb.nceas.metacat.properties.PropertyService;
import edu.ucsb.nceas.metacat.restservice.D1ResourceHandler;
import edu.ucsb.nceas.metacat.restservice.multipart.CheckedFile;
import edu.ucsb.nceas.metacat.restservice.multipart.DetailedFileInputStream;
import edu.ucsb.nceas.metacat.restservice.multipart.MultipartRequestWithSysmeta;
import edu.ucsb.nceas.metacat.restservice.multipart.StreamingMultipartRequestResolver;
import edu.ucsb.nceas.utilities.PropertyNotFoundException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.servlet.ServletContext;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.LogFactory;
import org.dataone.client.v2.formats.ObjectFormatInfo;
import org.dataone.exceptions.MarshallingException;
import org.dataone.mimemultipart.MultipartRequest;
import org.dataone.mimemultipart.MultipartRequestResolver;
import org.dataone.portal.TokenGenerator;
import org.dataone.service.exceptions.BaseException;
import org.dataone.service.exceptions.IdentifierNotUnique;
import org.dataone.service.exceptions.InsufficientResources;
import org.dataone.service.exceptions.InvalidRequest;
import org.dataone.service.exceptions.InvalidSystemMetadata;
import org.dataone.service.exceptions.InvalidToken;
import org.dataone.service.exceptions.NotAuthorized;
import org.dataone.service.exceptions.NotFound;
import org.dataone.service.exceptions.NotImplemented;
import org.dataone.service.exceptions.ServiceFailure;
import org.dataone.service.exceptions.SynchronizationFailed;
import org.dataone.service.exceptions.UnsupportedType;
import org.dataone.service.types.v1.Checksum;
import org.dataone.service.types.v1.DescribeResponse;
import org.dataone.service.types.v1.Event;
import org.dataone.service.types.v1.Identifier;
import org.dataone.service.types.v1.Log;
import org.dataone.service.types.v1.Node;
import org.dataone.service.types.v1.NodeReference;
import org.dataone.service.types.v1.ObjectFormatIdentifier;
import org.dataone.service.types.v1.ObjectList;
import org.dataone.service.types.v1.Permission;
import org.dataone.service.types.v1.Person;
import org.dataone.service.types.v1.SystemMetadata;
import org.dataone.service.types.v1_1.QueryEngineDescription;
import org.dataone.service.types.v1_1.QueryEngineList;
import org.dataone.service.util.DateTimeMarshaller;
import org.dataone.service.util.ExceptionHandler;
import org.dataone.service.util.TypeMarshaller;
import org.xml.sax.SAXException;

public class MNResourceHandler
extends D1ResourceHandler {
    protected static final String RESOURCE_MONITOR = "monitor";
    protected static final String RESOURCE_REPLICATE = "replicate";
    protected static final String RESOURCE_REPLICAS = "replica";
    protected static final String RESOURCE_NODE = "node";
    protected static final String RESOURCE_ERROR = "error";
    protected static final String RESOURCE_META_CHANGED = "dirtySystemMetadata";
    protected static final String RESOURCE_GENERATE_ID = "generate";
    protected static final String RESOURCE_PUBLISH = "publish";
    protected static final String RESOURCE_PACKAGE = "packages";
    protected static final String RESOURCE_VIEWS = "views";
    protected static final String RESOURCE_TOKEN = "token";
    private static ExecutorService executor = null;

    public MNResourceHandler(ServletContext servletContext, HttpServletRequest request, HttpServletResponse response) {
        super(servletContext, request, response);
        logMetacat = LogFactory.getLog(MNResourceHandler.class);
    }

    @Override
    protected boolean isD1Enabled() {
        boolean enabled = false;
        try {
            enabled = Boolean.parseBoolean(PropertyService.getProperty("dataone.mn.services.enabled"));
        }
        catch (PropertyNotFoundException e) {
            logMetacat.error((Object)("Could not check if DataONE is enabled: " + e.getMessage()));
        }
        return enabled;
    }

    @Override
    public void handle(byte httpVerb) {
        block84: {
            super.handle(httpVerb);
            try {
                if (!this.isD1Enabled()) {
                    ServiceFailure se = new ServiceFailure("0000", "DataONE services are not enabled on this node");
                    this.serializeException((BaseException)((Object)se), (OutputStream)this.response.getOutputStream());
                    return;
                }
                String resource = this.request.getPathInfo();
                if ((resource = resource.substring(resource.indexOf("/") + 1)).equals("")) {
                    resource = RESOURCE_NODE;
                }
                String extra = null;
                logMetacat.info((Object)("MNResourceHanlder.handle - V1 handling verb " + httpVerb + " request with resource '" + resource + "'"));
                logMetacat.debug((Object)("resource: '" + resource + "'"));
                boolean status = false;
                if (resource != null) {
                    if (resource.startsWith(RESOURCE_NODE)) {
                        this.node();
                        status = true;
                    } else if (resource.startsWith(RESOURCE_TOKEN)) {
                        logMetacat.debug((Object)"Using resource 'token'");
                        if (httpVerb == 1) {
                            this.getToken();
                            status = true;
                        }
                    } else if (resource.startsWith("isAuthorized")) {
                        if (httpVerb == 1) {
                            extra = this.parseTrailing(resource, "isAuthorized");
                            extra = MNResourceHandler.decode(extra);
                            this.isAuthorized(extra);
                            status = true;
                            logMetacat.debug((Object)"done getting access");
                        }
                    } else if (resource.startsWith("meta")) {
                        logMetacat.debug((Object)"Using resource 'meta'");
                        if (httpVerb == 1) {
                            extra = this.parseTrailing(resource, "meta");
                            extra = MNResourceHandler.decode(extra);
                            this.getSystemMetadataObject(extra);
                            status = true;
                        }
                    } else if (resource.startsWith("object")) {
                        logMetacat.debug((Object)"Using resource 'object'");
                        extra = this.parseTrailing(resource, "object");
                        logMetacat.debug((Object)("objectId(before decoded: " + extra));
                        extra = MNResourceHandler.decode(extra);
                        logMetacat.debug((Object)("objectId: " + extra));
                        logMetacat.debug((Object)("verb:" + httpVerb));
                        if (httpVerb == 1) {
                            this.getObject(extra);
                            status = true;
                        } else if (httpVerb == 2) {
                            this.putObject(null, "insert");
                            status = true;
                        } else if (httpVerb == 3) {
                            this.putObject(extra, "update");
                            status = true;
                        } else if (httpVerb == 4) {
                            this.deleteObject(extra);
                            status = true;
                        } else if (httpVerb == 5) {
                            this.describeObject(extra);
                            status = true;
                        }
                    } else if (resource.startsWith("log")) {
                        logMetacat.debug((Object)"Using resource 'log'");
                        if (httpVerb == 1) {
                            this.getLog();
                            status = true;
                        }
                    } else if (resource.startsWith("archive")) {
                        logMetacat.debug((Object)"Using resource archive");
                        if (httpVerb == 3) {
                            extra = this.parseTrailing(resource, "archive");
                            extra = MNResourceHandler.decode(extra);
                            this.archive(extra);
                            status = true;
                        }
                    } else if (resource.startsWith("checksum")) {
                        logMetacat.debug((Object)"Using resource 'checksum'");
                        if (httpVerb == 1) {
                            extra = this.parseTrailing(resource, "checksum");
                            extra = MNResourceHandler.decode(extra);
                            this.checksum(extra);
                            status = true;
                        }
                    } else if (resource.startsWith(RESOURCE_MONITOR)) {
                        if (httpVerb == 1) {
                            extra = this.parseTrailing(resource, RESOURCE_MONITOR);
                            if ((extra = MNResourceHandler.decode(extra)).toLowerCase().equals("ping")) {
                                logMetacat.debug((Object)"processing ping request");
                                Date result = MNodeService.getInstance(this.request).ping();
                                status = true;
                            }
                        }
                    } else if (resource.startsWith(RESOURCE_REPLICATE)) {
                        if (httpVerb == 2) {
                            logMetacat.debug((Object)"processing replicate request");
                            this.replicate();
                            status = true;
                        }
                    } else if (resource.startsWith(RESOURCE_ERROR)) {
                        if (httpVerb == 2) {
                            this.syncError();
                            status = true;
                        }
                    } else if (resource.startsWith(RESOURCE_META_CHANGED)) {
                        if (httpVerb == 2) {
                            this.systemMetadataChanged();
                            status = true;
                        }
                    } else if (resource.startsWith(RESOURCE_REPLICAS)) {
                        if (httpVerb == 1) {
                            extra = this.parseTrailing(resource, RESOURCE_REPLICAS);
                            extra = MNResourceHandler.decode(extra);
                            this.getReplica(extra);
                            status = true;
                        }
                    } else if (resource.startsWith("query")) {
                        logMetacat.debug((Object)"Using resource query");
                        extra = this.parseTrailing(resource, "query");
                        logMetacat.debug((Object)("query extra: " + extra));
                        String engine = null;
                        String query = null;
                        if (extra != null) {
                            int engineIndex = extra.length();
                            if (extra.indexOf("/") > -1) {
                                engineIndex = extra.indexOf("/");
                            }
                            engine = extra.substring(0, engineIndex);
                            engine = MNResourceHandler.decode(engine);
                            logMetacat.debug((Object)("query engine: " + engine));
                            query = this.request.getQueryString();
                            if (query == null) {
                                query = extra.substring(engineIndex, extra.length());
                                if (query != null && query.length() == 0) {
                                    query = null;
                                } else if (query.startsWith("/")) {
                                    query = query.substring(1);
                                }
                            }
                            query = MNResourceHandler.decode(query);
                            logMetacat.debug((Object)("query: " + query));
                        }
                        logMetacat.debug((Object)("verb:" + httpVerb));
                        if (httpVerb == 1) {
                            this.doQuery(engine, query);
                            status = true;
                        }
                    } else if (resource.startsWith(RESOURCE_GENERATE_ID)) {
                        if (httpVerb == 2) {
                            this.generateIdentifier();
                            status = true;
                        }
                    } else if (resource.startsWith(RESOURCE_PUBLISH)) {
                        logMetacat.debug((Object)"Using resource: publish");
                        if (httpVerb == 3) {
                            extra = this.parseTrailing(resource, RESOURCE_PUBLISH);
                            extra = MNResourceHandler.decode(extra);
                            this.publish(extra);
                            status = true;
                        }
                    } else if (resource.startsWith(RESOURCE_PACKAGE)) {
                        logMetacat.debug((Object)"Using resource: packages");
                        if (httpVerb == 1) {
                            extra = this.parseTrailing(resource, RESOURCE_PACKAGE);
                            extra = MNResourceHandler.decode(extra);
                            this.getPackage(extra);
                            status = true;
                        }
                    } else if (resource.startsWith(RESOURCE_VIEWS)) {
                        logMetacat.debug((Object)"Using resource views");
                        extra = this.parseTrailing(resource, RESOURCE_VIEWS);
                        logMetacat.debug((Object)("view extra: " + extra));
                        String format = null;
                        String pid = null;
                        if (extra != null) {
                            int formatIndex = extra.length();
                            if (extra.indexOf("/") > -1) {
                                formatIndex = extra.indexOf("/");
                            }
                            format = extra.substring(0, formatIndex);
                            format = MNResourceHandler.decode(format);
                            logMetacat.debug((Object)("view format: " + format));
                            pid = extra.substring(formatIndex, extra.length());
                            if (pid != null && pid.length() == 0) {
                                pid = null;
                            } else if (pid.startsWith("/")) {
                                pid = pid.substring(1);
                            }
                            pid = MNResourceHandler.decode(pid);
                            logMetacat.debug((Object)("pid: " + pid));
                        }
                        logMetacat.debug((Object)("verb:" + httpVerb));
                        if (httpVerb == 1) {
                            this.doViews(format, pid);
                            status = true;
                        }
                    } else {
                        throw new InvalidRequest("0000", "No resource matched for " + resource);
                    }
                    if (!status) {
                        throw new ServiceFailure("0000", "Unknown error, status = " + status);
                    }
                    break block84;
                }
                throw new InvalidRequest("0000", "No resource matched for " + resource);
            }
            catch (BaseException be) {
                ServletOutputStream out = null;
                try {
                    out = this.response.getOutputStream();
                }
                catch (IOException e) {
                    logMetacat.error((Object)"Could not get output stream from response", (Throwable)e);
                }
                this.serializeException(be, (OutputStream)out);
            }
            catch (Exception e) {
                logMetacat.error((Object)(e.getClass() + ": " + e.getMessage()), (Throwable)e);
                ServletOutputStream out = null;
                try {
                    out = this.response.getOutputStream();
                }
                catch (IOException ioe) {
                    logMetacat.error((Object)"Could not get output stream from response", (Throwable)ioe);
                }
                ServiceFailure se = new ServiceFailure("0000", e.getMessage());
                this.serializeException((BaseException)((Object)se), (OutputStream)out);
            }
        }
    }

    private void getToken() throws Exception {
        if (this.session != null) {
            String userId = this.session.getSubject().getValue();
            String fullName = null;
            try {
                Person person = this.session.getSubjectInfo().getPerson(0);
                fullName = person.getGivenName(0) + " " + person.getFamilyName();
            }
            catch (Exception e) {
                logMetacat.warn((Object)e.getMessage(), (Throwable)e);
            }
            String token = null;
            token = TokenGenerator.getInstance().getJWT(userId, fullName);
            this.response.setStatus(200);
            this.response.setContentType("text/plain");
            ServletOutputStream out = this.response.getOutputStream();
            out.write(token.getBytes("UTF-8"));
            out.close();
        } else {
            this.response.setStatus(401);
            this.response.setContentType("text/plain");
            ServletOutputStream out = this.response.getOutputStream();
            out.write("No session information found".getBytes("UTF-8"));
            out.close();
        }
    }

    private void doQuery(String engine, String query) {
        ServletOutputStream out = null;
        try {
            if (engine == null) {
                MNodeService mnode = MNodeService.getInstance(this.request);
                mnode.setSession(this.session);
                QueryEngineList qel = mnode.listQueryEngines();
                this.response.setContentType("text/xml");
                this.response.setStatus(200);
                out = this.response.getOutputStream();
                TypeMarshaller.marshalTypeToOutputStream((Object)qel, (OutputStream)out);
                return;
            }
            if (query != null) {
                MNodeService mnode = MNodeService.getInstance(this.request);
                mnode.setSession(this.session);
                InputStream stream = mnode.query(engine, query);
                if (stream instanceof ContentTypeInputStream) {
                    this.response.setContentType(((ContentTypeInputStream)stream).getContentType());
                }
                this.response.setStatus(200);
                out = this.response.getOutputStream();
                IOUtils.copyLarge((InputStream)stream, (OutputStream)out);
                return;
            }
            MNodeService mnode = MNodeService.getInstance(this.request);
            mnode.setSession(this.session);
            QueryEngineDescription qed = mnode.getQueryEngineDescription(engine);
            this.response.setContentType("text/xml");
            this.response.setStatus(200);
            out = this.response.getOutputStream();
            TypeMarshaller.marshalTypeToOutputStream((Object)qed, (OutputStream)out);
            return;
        }
        catch (BaseException be) {
            try {
                out = this.response.getOutputStream();
            }
            catch (IOException e) {
                logMetacat.error((Object)"Could not get output stream from response", (Throwable)e);
            }
            this.serializeException(be, (OutputStream)out);
        }
        catch (Exception e) {
            logMetacat.error((Object)(e.getClass() + ": " + e.getMessage()), (Throwable)e);
            try {
                out = this.response.getOutputStream();
            }
            catch (IOException ioe) {
                logMetacat.error((Object)"Could not get output stream from response", (Throwable)ioe);
            }
            ServiceFailure se = new ServiceFailure("0000", e.getMessage());
            this.serializeException((BaseException)((Object)se), (OutputStream)out);
        }
    }

    private void doViews(String format, String pid) {
        ServletOutputStream out = null;
        MNodeService mnode = MNodeService.getInstance(this.request);
        try {
            if (pid != null) {
                Identifier identifier = new Identifier();
                identifier.setValue(pid);
                InputStream stream = mnode.view(this.session, format, identifier);
                if (stream instanceof ContentTypeInputStream) {
                    this.response.setContentType(((ContentTypeInputStream)stream).getContentType());
                }
                this.response.setStatus(200);
                out = this.response.getOutputStream();
                IOUtils.copyLarge((InputStream)stream, (OutputStream)out);
                return;
            }
            NotImplemented ni = new NotImplemented("9999", "MN.listViews() is not implemented at this node");
            throw ni;
        }
        catch (BaseException be) {
            try {
                out = this.response.getOutputStream();
            }
            catch (IOException e) {
                logMetacat.error((Object)"Could not get output stream from response", (Throwable)e);
            }
            this.serializeException(be, (OutputStream)out);
        }
        catch (Exception e) {
            logMetacat.error((Object)(e.getClass() + ": " + e.getMessage()), (Throwable)e);
            try {
                out = this.response.getOutputStream();
            }
            catch (IOException ioe) {
                logMetacat.error((Object)"Could not get output stream from response", (Throwable)ioe);
            }
            ServiceFailure se = new ServiceFailure("0000", e.getMessage());
            this.serializeException((BaseException)((Object)se), (OutputStream)out);
        }
    }

    private void systemMetadataChanged() throws NotImplemented, ServiceFailure, NotAuthorized, InvalidRequest, InvalidToken {
        ReadOnlyChecker checker = new ReadOnlyChecker();
        boolean isReadOnlyMode = checker.isReadOnly();
        if (isReadOnlyMode) {
            throw new ServiceFailure("1333", "The Metacat member node is on the read-only mode and your request can't be fulfiled. Please try again later.");
        }
        long serialVersion = 0L;
        String serialVersionStr = null;
        Date dateSysMetaLastModified = null;
        String dateSysMetaLastModifiedStr = null;
        Identifier pid = null;
        try {
            this.initMultipartParams();
        }
        catch (Exception e1) {
            throw new ServiceFailure("1333", "Could not collect the multipart params for the request");
        }
        try {
            String id = (String)((List)this.multipartparams.get("pid")).get(0);
            pid = new Identifier();
            pid.setValue(id);
        }
        catch (NullPointerException e) {
            String msg = "The 'pid' must be provided as a parameter and was not.";
            logMetacat.error((Object)msg);
            throw new InvalidRequest("1334", msg);
        }
        try {
            serialVersionStr = (String)((List)this.multipartparams.get("serialVersion")).get(0);
            serialVersion = new Long(serialVersionStr);
        }
        catch (NullPointerException e) {
            String msg = "The 'serialVersion' must be provided as a parameter and was not.";
            logMetacat.error((Object)msg);
            throw new InvalidRequest("1334", msg);
        }
        try {
            dateSysMetaLastModifiedStr = (String)((List)this.multipartparams.get("dateSysMetaLastModified")).get(0);
            dateSysMetaLastModified = DateTimeMarshaller.deserializeDateToUTC((String)dateSysMetaLastModifiedStr);
        }
        catch (NullPointerException e) {
            String msg = "The 'dateSysMetaLastModified' must be provided as a parameter and was not, or was an invalid representation of the timestamp.";
            logMetacat.error((Object)msg);
            throw new InvalidRequest("1334", msg);
        }
        MNodeService.getInstance(this.request).systemMetadataChanged(this.session, pid, serialVersion, dateSysMetaLastModified);
        this.response.setStatus(200);
    }

    private void generateIdentifier() throws InvalidToken, ServiceFailure, NotAuthorized, NotImplemented, InvalidRequest, IOException, MarshallingException {
        try {
            this.initMultipartParams();
        }
        catch (Exception e1) {
            throw new ServiceFailure("1333", "Could not collect the multipart params for the request");
        }
        String scheme = null;
        try {
            scheme = (String)((List)this.multipartparams.get("scheme")).get(0);
        }
        catch (NullPointerException e) {
            String msg = "The 'scheme' parameter was not provided, using default";
            logMetacat.warn((Object)msg);
        }
        String fragment = null;
        try {
            fragment = (String)((List)this.multipartparams.get("fragment")).get(0);
        }
        catch (NullPointerException e) {
            String msg = "The 'fragment' parameter was not provided, using default";
            logMetacat.warn((Object)msg);
        }
        Identifier identifier = MNodeService.getInstance(this.request).generateIdentifier(this.session, scheme, fragment);
        this.response.setStatus(200);
        this.response.setContentType("text/xml");
        ServletOutputStream out = this.response.getOutputStream();
        TypeMarshaller.marshalTypeToOutputStream((Object)identifier, (OutputStream)out);
    }

    private boolean isAuthorized(String id) throws ServiceFailure, InvalidToken, NotFound, NotAuthorized, NotImplemented, InvalidRequest {
        Identifier pid = new Identifier();
        pid.setValue(id);
        Permission permission = null;
        try {
            String perm = ((String[])this.params.get("action"))[0];
            permission = Permission.convert((String)perm);
        }
        catch (Exception e) {
            logMetacat.warn((Object)"No permission specified");
        }
        boolean result = MNodeService.getInstance(this.request).isAuthorized(this.session, pid, permission);
        this.response.setStatus(200);
        this.response.setContentType("text/xml");
        return result;
    }

    private void syncError() throws NotImplemented, ServiceFailure, NotAuthorized, InvalidRequest, MarshallingException, IOException, InstantiationException, IllegalAccessException, InvalidToken {
        SynchronizationFailed syncFailed = null;
        try {
            syncFailed = this.collectSynchronizationFailed();
        }
        catch (ParserConfigurationException e) {
            throw new ServiceFailure("2161", e.getMessage());
        }
        catch (SAXException e) {
            throw new ServiceFailure("2161", e.getMessage());
        }
        MNodeService.getInstance(this.request).synchronizationFailed(this.session, syncFailed);
    }

    private void checksum(String pid) throws NotImplemented, MarshallingException, IOException, InvalidToken, ServiceFailure, NotAuthorized, NotFound, InvalidRequest {
        String checksumAlgorithm = "MD5";
        try {
            checksumAlgorithm = PropertyService.getProperty("dataone.checksumAlgorithm.default");
        }
        catch (Exception e) {
            logMetacat.warn((Object)("Could not lookup configured default checksum algorithm, using: " + checksumAlgorithm));
        }
        Identifier pidid = new Identifier();
        pidid.setValue(pid);
        try {
            checksumAlgorithm = ((String[])this.params.get("checksumAlgorithm"))[0];
        }
        catch (Exception e) {
            logMetacat.warn((Object)("No algorithm specified, using default: " + checksumAlgorithm));
        }
        logMetacat.debug((Object)("getting checksum for object " + pid + " with algorithm " + checksumAlgorithm));
        Checksum c = MNodeService.getInstance(this.request).getChecksum(this.session, pidid, checksumAlgorithm);
        logMetacat.debug((Object)("got checksum " + c.getValue()));
        this.response.setStatus(200);
        logMetacat.debug((Object)"serializing response");
        TypeMarshaller.marshalTypeToOutputStream((Object)c, (OutputStream)this.response.getOutputStream());
        logMetacat.debug((Object)"done serializing response.");
    }

    private void replicate() throws ServiceFailure, InvalidRequest, IOException, FileUploadException, MarshallingException, NotImplemented, NotAuthorized, InsufficientResources, UnsupportedType, InstantiationException, IllegalAccessException, InvalidToken {
        logMetacat.debug((Object)"in POST replicate()");
        ReadOnlyChecker checker = new ReadOnlyChecker();
        boolean isReadOnlyMode = checker.isReadOnly();
        if (isReadOnlyMode) {
            throw new ServiceFailure("2151", "The Metacat member node is on the read-only mode and your request can't be fulfiled. Please try again later.");
        }
        boolean allowed = false;
        if (this.session == null) {
            String msg = "No session was provided.";
            NotAuthorized failure = new NotAuthorized("2152", msg);
            throw failure;
        }
        D1AuthHelper authDel = new D1AuthHelper(this.request, null, "2152", "????");
        authDel.doAdminAuthorization(this.session);
        Map<String, File> files = this.collectMultipartFiles();
        final SystemMetadata sysmeta = (SystemMetadata)TypeMarshaller.unmarshalTypeFromFile(SystemMetadata.class, (File)files.get("sysmeta"));
        String sn = (String)((List)this.multipartparams.get("sourceNode")).get(0);
        logMetacat.debug((Object)("sourceNode: " + sn));
        final NodeReference sourceNode = new NodeReference();
        sourceNode.setValue(sn);
        Runnable runner = new Runnable(){

            @Override
            public void run() {
                try {
                    MNodeService.getInstance(MNResourceHandler.this.request).replicate(MNResourceHandler.this.session, sysmeta, sourceNode);
                }
                catch (Exception e) {
                    logMetacat.error((Object)("Error running replication: " + e.getMessage()), (Throwable)e);
                    throw new RuntimeException(e.getMessage(), e);
                }
            }
        };
        executor.submit(runner);
        this.response.setStatus(200);
    }

    private void getReplica(String id) throws InvalidRequest, InvalidToken, NotAuthorized, NotImplemented, ServiceFailure, NotFound, InsufficientResources {
        Identifier pid = new Identifier();
        pid.setValue(id);
        ServletOutputStream out = null;
        InputStream dataBytes = null;
        try {
            dataBytes = MNodeService.getInstance(this.request).getReplica(this.session, pid);
            this.response.setContentType("application/octet-stream");
            this.response.setStatus(200);
            out = this.response.getOutputStream();
            IOUtils.copyLarge((InputStream)dataBytes, (OutputStream)out);
        }
        catch (IOException e) {
            String msg = "There was an error writing the output: " + e.getMessage();
            logMetacat.error((Object)msg);
            throw new ServiceFailure("2181", msg);
        }
    }

    private void node() throws MarshallingException, IOException, NotImplemented, NotAuthorized, ServiceFailure, InvalidRequest {
        Node n = MNodeService.getInstance(this.request).getCapabilities();
        this.response.setContentType("text/xml");
        this.response.setStatus(200);
        TypeMarshaller.marshalTypeToOutputStream((Object)n, (OutputStream)this.response.getOutputStream());
    }

    private void describeObject(String pid) throws InvalidToken, ServiceFailure, NotAuthorized, NotFound, NotImplemented, InvalidRequest {
        this.response.setContentType("text/xml");
        Identifier id = new Identifier();
        id.setValue(pid);
        DescribeResponse dr = null;
        try {
            dr = MNodeService.getInstance(this.request).describe(this.session, id);
        }
        catch (BaseException e) {
            this.response.setStatus(e.getCode());
            this.response.addHeader("DataONE-Exception-Name", ((Object)((Object)e)).getClass().getName());
            this.response.addHeader("DataONE-Exception-DetailCode", e.getDetail_code());
            this.response.addHeader("DataONE-Exception-Description", e.getDescription());
            this.response.addHeader("DataONE-Exception-PID", id.getValue());
            return;
        }
        this.response.setStatus(200);
        this.response.addHeader("DataONE-Checksum", dr.getDataONE_Checksum().getAlgorithm() + "," + dr.getDataONE_Checksum().getValue());
        this.response.addHeader("Content-Length", dr.getContent_Length() + "");
        this.response.addHeader("Last-Modified", DateTimeMarshaller.serializeDateToUTC((Date)dr.getLast_Modified()));
        this.response.addHeader("DataONE-ObjectFormat", dr.getDataONE_ObjectFormatIdentifier().getValue());
        this.response.addHeader("DataONE-SerialVersion", dr.getSerialVersion().toString());
    }

    private void getLog() throws InvalidToken, ServiceFailure, NotAuthorized, InvalidRequest, NotImplemented, IOException, MarshallingException {
        Date fromDate = null;
        Date toDate = null;
        Event event = null;
        Integer start = null;
        Integer count = null;
        String pidFilter = null;
        try {
            String fromDateS = ((String[])this.params.get("fromDate"))[0];
            logMetacat.debug((Object)("param fromDateS: " + fromDateS));
            fromDate = DateTimeMarshaller.deserializeDateToUTC((String)fromDateS);
        }
        catch (Exception e) {
            logMetacat.warn((Object)("Could not parse fromDate: " + e.getMessage()));
        }
        try {
            String toDateS = ((String[])this.params.get("toDate"))[0];
            logMetacat.debug((Object)("param toDateS: " + toDateS));
            toDate = DateTimeMarshaller.deserializeDateToUTC((String)toDateS);
        }
        catch (Exception e) {
            logMetacat.warn((Object)("Could not parse toDate: " + e.getMessage()));
        }
        try {
            String eventS = ((String[])this.params.get("event"))[0];
            event = Event.convert((String)eventS);
        }
        catch (Exception e) {
            logMetacat.warn((Object)("Could not parse event: " + e.getMessage()));
        }
        logMetacat.debug((Object)("fromDate: " + fromDate + " toDate: " + toDate));
        try {
            start = Integer.parseInt(((String[])this.params.get("start"))[0]);
        }
        catch (Exception e) {
            logMetacat.warn((Object)("Could not parse start: " + e.getMessage()));
        }
        try {
            count = Integer.parseInt(((String[])this.params.get("count"))[0]);
        }
        catch (Exception e) {
            logMetacat.warn((Object)("Could not parse count: " + e.getMessage()));
        }
        try {
            pidFilter = ((String[])this.params.get("pidFilter"))[0];
        }
        catch (Exception e) {
            logMetacat.warn((Object)("Could not parse pidFilter: " + e.getMessage()));
        }
        logMetacat.debug((Object)"calling getLogRecords");
        Log log = MNodeService.getInstance(this.request).getLogRecords(this.session, fromDate, toDate, event, pidFilter, start, count);
        ServletOutputStream out = this.response.getOutputStream();
        this.response.setStatus(200);
        this.response.setContentType("text/xml");
        TypeMarshaller.marshalTypeToOutputStream((Object)log, (OutputStream)out);
    }

    protected void getObject(String pid) throws InvalidToken, ServiceFailure, NotAuthorized, NotFound, InvalidRequest, NotImplemented, IOException, MarshallingException, InsufficientResources {
        ServletOutputStream out = null;
        if (pid != null) {
            Identifier id = new Identifier();
            id.setValue(pid);
            InputStream data = MNodeService.getInstance(this.request).get(this.session, id);
            SystemMetadata sm = MNodeService.getInstance(this.request).getSystemMetadata(this.session, id);
            String mimeType = ObjectFormatInfo.instance().getMimeType(sm.getFormatId().getValue());
            if (mimeType == null) {
                mimeType = "application/octet-stream";
            }
            String extension = ObjectFormatInfo.instance().getExtension(sm.getFormatId().getValue());
            String filename = id.getValue();
            if (extension != null && filename != null && !filename.endsWith(extension)) {
                filename = id.getValue() + extension;
            }
            this.response.setContentType(mimeType);
            this.response.setHeader("Content-Disposition", "inline; filename=\"" + filename + "\"");
            out = this.response.getOutputStream();
            IOUtils.copyLarge((InputStream)data, (OutputStream)out);
        } else {
            Date startTime = null;
            Date endTime = null;
            ObjectFormatIdentifier formatId = null;
            boolean replicaStatus = true;
            int start = 0;
            int count = 1000;
            Enumeration paramlist = this.request.getParameterNames();
            while (paramlist.hasMoreElements()) {
                String name = (String)paramlist.nextElement();
                String[] value = this.request.getParameterValues(name);
                if (name.equals("fromDate") && value != null) {
                    try {
                        startTime = DateTimeMarshaller.deserializeDateToUTC((String)value[0]);
                        continue;
                    }
                    catch (Exception e) {
                        logMetacat.warn((Object)("Could not parse fromDate: " + value[0]), (Throwable)e);
                        throw new InvalidRequest("1540", "Could not parse fromDate: " + value[0] + " since " + e.getMessage());
                    }
                }
                if (name.equals("toDate") && value != null) {
                    try {
                        endTime = DateTimeMarshaller.deserializeDateToUTC((String)value[0]);
                        continue;
                    }
                    catch (Exception e) {
                        logMetacat.warn((Object)("Could not parse toDate: " + value[0]), (Throwable)e);
                        throw new InvalidRequest("1540", "Could not parse toDate: " + value[0] + " since " + e.getMessage());
                    }
                }
                if (name.equals("formatId") && value != null) {
                    formatId = new ObjectFormatIdentifier();
                    formatId.setValue(value[0]);
                    continue;
                }
                if (name.equals("replicaStatus") && value != null) {
                    if (value == null || value.length <= 0 || !value[0].equalsIgnoreCase("false") && !value[0].equalsIgnoreCase("no")) continue;
                    replicaStatus = false;
                    continue;
                }
                if (name.equals("start") && value != null) {
                    start = new Integer(value[0]);
                    continue;
                }
                if (!name.equals("count") || value == null) continue;
                count = new Integer(value[0]);
            }
            logMetacat.debug((Object)("session: " + this.session + " startTime: " + startTime + " endTime: " + endTime + " formatId: " + formatId + " replicaStatus: " + replicaStatus + " start: " + start + " count: " + count));
            ObjectList ol = MNodeService.getInstance(this.request).listObjects(this.session, startTime, endTime, formatId, replicaStatus, start, count);
            out = this.response.getOutputStream();
            this.response.setStatus(200);
            this.response.setContentType("text/xml");
            TypeMarshaller.marshalTypeToOutputStream((Object)ol, (OutputStream)out);
        }
    }

    protected void getPackage(String pid) throws InvalidToken, ServiceFailure, NotAuthorized, NotFound, NotImplemented, IOException, InvalidRequest {
        Identifier id = new Identifier();
        id.setValue(pid);
        InputStream is = MNodeService.getInstance(this.request).getPackage(this.session, null, id);
        String filename = pid.replaceAll("\\W", "_") + ".zip";
        this.response.setHeader("Content-Disposition", "inline; filename=\"" + filename + "\"");
        this.response.setContentType("application/zip");
        this.response.setStatus(200);
        ServletOutputStream out = this.response.getOutputStream();
        IOUtils.copyLarge((InputStream)is, (OutputStream)out);
    }

    protected void publish(String pid) throws InvalidToken, ServiceFailure, NotAuthorized, NotFound, NotImplemented, IOException, MarshallingException, InvalidRequest, IdentifierNotUnique, UnsupportedType, InsufficientResources, InvalidSystemMetadata {
        Identifier originalIdentifier = new Identifier();
        originalIdentifier.setValue(pid);
        Identifier newIdentifier = MNodeService.getInstance(this.request).publish(this.session, originalIdentifier);
        this.response.setStatus(200);
        this.response.setContentType("text/xml");
        ServletOutputStream out = this.response.getOutputStream();
        TypeMarshaller.marshalTypeToOutputStream((Object)newIdentifier, (OutputStream)out);
    }

    protected void getSystemMetadataObject(String pid) throws InvalidToken, ServiceFailure, NotAuthorized, NotFound, InvalidRequest, NotImplemented, IOException, MarshallingException {
        Identifier id = new Identifier();
        id.setValue(pid);
        SystemMetadata sysmeta = MNodeService.getInstance(this.request).getSystemMetadata(this.session, id);
        this.response.setContentType("text/xml");
        this.response.setStatus(200);
        ServletOutputStream out = this.response.getOutputStream();
        TypeMarshaller.marshalTypeToOutputStream((Object)sysmeta, (OutputStream)out);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void putObject(String trailingPid, String action) throws ServiceFailure, InvalidRequest, MarshallingException, InvalidToken, NotAuthorized, IdentifierNotUnique, UnsupportedType, InsufficientResources, InvalidSystemMetadata, NotImplemented, NotFound, IOException, InstantiationException, IllegalAccessException, NoSuchAlgorithmException, FileUploadException {
        CheckedFile objFile = null;
        try {
            MultipartRequestWithSysmeta multiparts = this.collectObjectFiles();
            DetailedFileInputStream object = null;
            Map files = multiparts.getMultipartFiles();
            objFile = (CheckedFile)files.get("object");
            if (objFile == null) {
                throw new InvalidRequest("1102", "The object param must contain the object bytes.");
            }
            object = new DetailedFileInputStream(objFile, objFile.getChecksum());
            Identifier pid = new Identifier();
            if (trailingPid == null) {
                String pidString = (String)((List)this.multipartparams.get("pid")).get(0);
                if (pidString == null) throw new InvalidRequest("1102", "The pid param must be included and contain the identifier.");
                pid.setValue(pidString);
            } else {
                pid.setValue(trailingPid);
            }
            logMetacat.debug((Object)("putObject with pid " + pid.getValue()));
            logMetacat.debug((Object)("Entering putObject: " + pid.getValue() + "/" + action));
            SystemMetadata smd = multiparts.getSystemMetadata();
            if (smd == null) {
                throw new InvalidRequest("1102", "The sysmeta param must contain the system metadata document.");
            }
            this.response.setStatus(200);
            this.response.setContentType("text/xml");
            ServletOutputStream out = this.response.getOutputStream();
            if (action.equals("insert")) {
                logMetacat.debug((Object)"Commence creation...");
                logMetacat.debug((Object)("creating object with pid " + pid.getValue()));
                Identifier rId = MNodeService.getInstance(this.request).create(this.session, pid, object, smd);
                TypeMarshaller.marshalTypeToOutputStream((Object)rId, (OutputStream)out);
                return;
            }
            if (!action.equals("update")) throw new InvalidRequest("1000", "Operation must be create or update.");
            Identifier newPid = null;
            try {
                String newPidString = (String)((List)this.multipartparams.get("newPid")).get(0);
                newPid = new Identifier();
                newPid.setValue(newPidString);
            }
            catch (Exception e) {
                logMetacat.error((Object)"Could not get newPid from request");
            }
            logMetacat.debug((Object)"Commence update...");
            Identifier rId = MNodeService.getInstance(this.request).update(this.session, pid, object, newPid, smd);
            TypeMarshaller.marshalTypeToOutputStream((Object)rId, (OutputStream)out);
            return;
        }
        catch (Exception e) {
            if (objFile == null) throw e;
            StreamingMultipartRequestResolver.deleteTempFile(objFile);
            throw e;
        }
    }

    private void deleteObject(String pid) throws IOException, InvalidToken, ServiceFailure, NotAuthorized, NotFound, NotImplemented, InvalidRequest, MarshallingException {
        ServletOutputStream out = this.response.getOutputStream();
        this.response.setStatus(200);
        this.response.setContentType("text/xml");
        Identifier id = new Identifier();
        id.setValue(pid);
        logMetacat.debug((Object)"Calling delete");
        MNodeService.getInstance(this.request).delete(this.session, id);
        TypeMarshaller.marshalTypeToOutputStream((Object)id, (OutputStream)out);
    }

    private void archive(String pid) throws InvalidToken, ServiceFailure, NotAuthorized, NotFound, NotImplemented, IOException, MarshallingException {
        ServletOutputStream out = this.response.getOutputStream();
        this.response.setStatus(200);
        this.response.setContentType("text/xml");
        Identifier id = new Identifier();
        id.setValue(pid);
        logMetacat.debug((Object)"Calling archive");
        MNodeService.getInstance(this.request).archive(this.session, id);
        TypeMarshaller.marshalTypeToOutputStream((Object)id, (OutputStream)out);
    }

    protected SynchronizationFailed collectSynchronizationFailed() throws IOException, ServiceFailure, InvalidRequest, MarshallingException, InstantiationException, IllegalAccessException, ParserConfigurationException, SAXException {
        logMetacat.debug((Object)"Disassembling MIME multipart form");
        FileInputStream sf = null;
        File tmpDir = MNResourceHandler.getTempDirectory();
        logMetacat.debug((Object)("temp dir: " + tmpDir.getAbsolutePath()));
        MultipartRequestResolver mrr = new MultipartRequestResolver(tmpDir.getAbsolutePath(), MAX_UPLOAD_SIZE, 0);
        MultipartRequest mr = null;
        try {
            mr = mrr.resolveMultipart(this.request);
        }
        catch (Exception e) {
            throw new ServiceFailure("2161", "Could not resolve multipart: " + e.getMessage());
        }
        logMetacat.debug((Object)"resolved multipart request");
        Map files = mr.getMultipartFiles();
        if (files == null || files.keySet() == null) {
            throw new InvalidRequest("2163", "must have multipart file with name 'message'");
        }
        logMetacat.debug((Object)"got multipart files");
        this.multipartparams = mr.getMultipartParameters();
        File sfFile = (File)files.get("message");
        if (sfFile == null) {
            throw new InvalidRequest("2163", "Missing the required file-part 'message' from the multipart request.");
        }
        logMetacat.debug((Object)("sfFile: " + sfFile.getAbsolutePath()));
        sf = new FileInputStream(sfFile);
        SynchronizationFailed syncFailed = (SynchronizationFailed)ExceptionHandler.deserializeXml((InputStream)sf, (String)"Error deserializing exception");
        return syncFailed;
    }

    static {
        int availableProcessors = Runtime.getRuntime().availableProcessors();
        int nThreads = availableProcessors * 1;
        --nThreads;
        nThreads = Math.max(1, nThreads);
        executor = Executors.newFixedThreadPool(nThreads);
    }
}

