/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat.service;

import edu.ucsb.nceas.metacat.service.XMLSchemaService;
import edu.ucsb.nceas.metacat.util.SystemUtil;
import edu.ucsb.nceas.utilities.FileUtil;
import edu.ucsb.nceas.utilities.PropertyNotFoundException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class XMLSchema {
    private String fileNamespace = null;
    private String externalFileUri = null;
    private String fileName = null;
    private String localFileUri = null;
    private String localFileDir = null;
    private String formatId = null;
    private static final String type = "Schema";
    private static final String FILE_PROTOCOL = "file://";
    private Log logMetacat = LogFactory.getLog(XMLSchema.class);

    public XMLSchema(String fileNamespace, String externalFileUri, String formatId) {
        this.setFileNamespace(fileNamespace);
        this.setExternalFileUri(externalFileUri);
        this.setFormatId(formatId);
    }

    public void setFileName(String fileName) {
        if (fileName.startsWith("/schema/")) {
            fileName = fileName.substring("/schema/".length());
        } else if (fileName.startsWith("http") && fileName.contains("/schema/")) {
            int index = fileName.lastIndexOf("/schema/") + "/schema/".length();
            fileName = fileName.substring(index);
        } else if (fileName.startsWith("http")) {
            fileName = fileName.substring(fileName.lastIndexOf(47) + 1);
        }
        this.fileName = fileName;
        try {
            String fileDir = SystemUtil.getContextDir() + "/schema/" + fileName;
            this.localFileDir = FileUtil.normalizePath((String)fileDir);
            this.logMetacat.debug((Object)("XMLSchema.setFileName - localFileDir: " + this.localFileDir));
        }
        catch (PropertyNotFoundException pnfe) {
            this.localFileDir = "/schema/" + fileName;
            this.logMetacat.warn((Object)("XMLSchema.setFileName - Could not get context directory. Setting localFileDir to: " + this.localFileDir));
        }
        this.localFileUri = FILE_PROTOCOL + this.localFileDir;
        this.logMetacat.debug((Object)("XMLSchema.setFileName - Setting localFileUri to: " + this.localFileUri));
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileNamespace(String fileNamespace) {
        this.fileNamespace = fileNamespace;
    }

    public String getFileNamespace() {
        return this.fileNamespace;
    }

    public void setExternalFileUri(String externalFileUri) {
        this.externalFileUri = externalFileUri;
        String fileName = XMLSchemaService.getSchemaFileNameFromUri(externalFileUri);
        this.setFileName(fileName);
    }

    public String getExternalFileUri() {
        return this.externalFileUri;
    }

    public String getLocalFileUri() {
        return this.localFileUri;
    }

    public String getLocalFileDir() {
        return this.localFileDir;
    }

    public String getFormatId() {
        return this.formatId;
    }

    public void setFormatId(String formatId) {
        this.formatId = formatId;
    }

    public static String getType() {
        return type;
    }
}

