/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat.service;

import edu.ucsb.nceas.metacat.properties.PropertyService;
import edu.ucsb.nceas.utilities.PropertyNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class XMLSchemaParser
extends DefaultHandler {
    private static String INCLUDE = "include";
    private static String SCHEMALOCATION = "schemaLocation";
    private Vector<String> includedSchemaFilePaths = new Vector();
    private InputStream schemaIn = null;
    private XMLReader parser = null;

    public XMLSchemaParser(InputStream schemaIn) throws SAXException, PropertyNotFoundException {
        this.schemaIn = schemaIn;
        this.initParser();
    }

    private void initParser() throws SAXException, PropertyNotFoundException {
        String parserName = PropertyService.getProperty("xml.saxparser");
        this.parser = XMLReaderFactory.createXMLReader(parserName);
        this.parser.setContentHandler(this);
    }

    public void parse() throws SAXException, IOException {
        this.parser.parse(new InputSource(this.schemaIn));
    }

    public Vector<String> getIncludedSchemaFilePathes() {
        return this.includedSchemaFilePaths;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        if (localName != null && localName.equals(INCLUDE) && atts != null) {
            for (int i = 0; i < atts.getLength(); ++i) {
                String attributeValue;
                String attributeName = atts.getQName(i);
                if (attributeName == null || !attributeName.equals(SCHEMALOCATION) || (attributeValue = atts.getValue(i)) == null && attributeValue.trim().equals("")) continue;
                this.includedSchemaFilePaths.add(attributeValue);
            }
        }
    }
}

