/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat.spatial;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.PrecisionModel;
import edu.ucsb.nceas.metacat.database.DBConnection;
import edu.ucsb.nceas.metacat.properties.PropertyService;
import edu.ucsb.nceas.metacat.spatial.SpatialFeatureSchema;
import edu.ucsb.nceas.metacat.util.MetacatUtil;
import edu.ucsb.nceas.metacat.util.SystemUtil;
import edu.ucsb.nceas.utilities.PropertyNotFoundException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

public class SpatialDocument {
    private DBConnection dbconn;
    private static Log log = LogFactory.getLog((String)SpatialDocument.class.getName());
    private SpatialFeatureSchema featureSchema = new SpatialFeatureSchema();
    Vector west = new Vector();
    Vector south = new Vector();
    Vector east = new Vector();
    Vector north = new Vector();
    String title = "";
    String docid = null;

    public SpatialDocument(String docid, DBConnection dbconn) {
        this.docid = docid;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        this.dbconn = dbconn;
        boolean isSpatialDocument = false;
        String thisDocname = null;
        String westPath = null;
        String eastPath = null;
        String northPath = null;
        String southPath = null;
        String query = "SELECT docname FROM xml_documents WHERE docid = ?";
        String docname = "";
        try {
            pstmt = dbconn.prepareStatement(query);
            pstmt.setString(1, docid.trim());
            pstmt.execute();
            rs = pstmt.getResultSet();
            while (rs.next()) {
                docname = rs.getString(1);
            }
            rs.close();
            pstmt.close();
        }
        catch (Exception e) {
            log.error((Object)(" ---- Could not get docname for " + docid));
            e.printStackTrace();
        }
        if (docname == null) {
            docname = "";
        }
        try {
            Vector<String> spatialDocnames = MetacatUtil.getOptionList(PropertyService.getProperty("spatial.spatialDocnameList"));
            for (int i = 0; i < spatialDocnames.size(); ++i) {
                thisDocname = spatialDocnames.elementAt(i).trim();
                if (!docname.trim().equals(thisDocname)) continue;
                isSpatialDocument = true;
                westPath = PropertyService.getProperty("spatial." + thisDocname + "_westBoundingCoordinatePath");
                eastPath = PropertyService.getProperty("spatial." + thisDocname + "_eastBoundingCoordinatePath");
                northPath = PropertyService.getProperty("spatial." + thisDocname + "_northBoundingCoordinatePath");
                southPath = PropertyService.getProperty("spatial." + thisDocname + "_southBoundingCoordinatePath");
            }
        }
        catch (PropertyNotFoundException pnfe) {
            log.error((Object)("Could not find spatialDocnameList or bounding coordinate path for: " + docid));
            pnfe.printStackTrace();
        }
        if (isSpatialDocument) {
            query = "SELECT path, nodedatanumerical, parentnodeid FROM xml_path_index WHERE docid = ? AND docid IN (SELECT distinct id.docid FROM identifier id, xml_access xa, xml_documents xd  WHERE id.docid = ? AND id.docid = xd.docid  AND id.rev = xd.rev  AND id.guid = xa.guid  AND xa.principal_name = 'public' AND xa.perm_type = 'allow') AND (path = '" + westPath + "'  OR path = '" + southPath + "'  OR path = '" + eastPath + "'  OR path = '" + northPath + "' ) ORDER BY parentnodeid;";
            try {
                pstmt = dbconn.prepareStatement(query);
                pstmt.setString(1, docid.trim());
                pstmt.setString(2, docid.trim());
                pstmt.execute();
                rs = pstmt.getResultSet();
                while (rs.next()) {
                    if (rs.getString(1).equals(westPath)) {
                        this.west.add(new Float(rs.getFloat(2)));
                        continue;
                    }
                    if (rs.getString(1).equals(southPath)) {
                        this.south.add(new Float(rs.getFloat(2)));
                        continue;
                    }
                    if (rs.getString(1).equals(eastPath)) {
                        this.east.add(new Float(rs.getFloat(2)));
                        continue;
                    }
                    if (rs.getString(1).equals(northPath)) {
                        this.north.add(new Float(rs.getFloat(2)));
                        continue;
                    }
                    log.error((Object)("** An xml path not related to your bounding coordinates was returned by this query \n" + query + "\n"));
                }
                rs.close();
                pstmt.close();
            }
            catch (Exception e) {
                log.error((Object)(" ---- Could not get bounding coordinates for " + docid));
                e.printStackTrace();
            }
            try {
                String docTitlePath = PropertyService.getProperty("spatial.docTitle");
                query = "select nodedata from xml_path_index where path = ? and docid = ?";
                pstmt = dbconn.prepareStatement(query);
                pstmt.setString(1, docTitlePath.trim());
                pstmt.setString(2, docid.trim());
                pstmt.execute();
                rs = pstmt.getResultSet();
                if (rs.next()) {
                    this.title = rs.getString(1);
                }
                rs.close();
                pstmt.close();
            }
            catch (Exception e) {
                log.error((Object)(" **** Error getting docids from getTitle for docid = " + docid));
                e.printStackTrace();
                this.title = docid;
            }
        }
    }

    public SimpleFeature getPolygonFeature() {
        SpatialDocument spatialDocument = this;
        SimpleFeatureType polyType = spatialDocument.featureSchema.getPolygonFeatureType();
        MultiPolygon theGeom = this.getPolygonGeometry();
        if (theGeom == null) {
            return null;
        }
        try {
            SimpleFeatureBuilder builder = new SimpleFeatureBuilder(polyType);
            builder.addAll(new Object[]{theGeom, this.docid, this.getUrl(this.docid), this.title});
            SimpleFeature polyFeature = builder.buildFeature(this.docid);
            return polyFeature;
        }
        catch (Exception e) {
            log.error((Object)("Problem getting polygon feature: " + e.getMessage()));
            return null;
        }
    }

    public SimpleFeature getPointFeature() {
        SpatialDocument spatialDocument = this;
        SimpleFeatureType pointType = spatialDocument.featureSchema.getPointFeatureType();
        MultiPoint theGeom = this.getPointGeometry();
        if (theGeom == null) {
            return null;
        }
        try {
            SimpleFeatureBuilder builder = new SimpleFeatureBuilder(pointType);
            builder.addAll(new Object[]{theGeom, this.docid, this.getUrl(this.docid), this.title});
            SimpleFeature pointFeature = builder.buildFeature(this.docid);
            return pointFeature;
        }
        catch (Exception e) {
            log.error((Object)("Problem getting point feature: " + e.getMessage()));
            return null;
        }
    }

    private String getUrl(String docid) {
        String docUrl = null;
        try {
            docUrl = SystemUtil.getServletURL() + "?action=read&docid=" + docid + "&qformat=" + PropertyService.getProperty("application.default-style");
        }
        catch (PropertyNotFoundException pnfe) {
            log.error((Object)("Could not get access url because of unavailable property: " + pnfe.getMessage()));
        }
        return docUrl;
    }

    private MultiPolygon getPolygonGeometry() {
        PrecisionModel precModel = new PrecisionModel();
        GeometryFactory geomFac = new GeometryFactory(precModel, SpatialFeatureSchema.srid);
        Vector<Polygon> polygons = new Vector<Polygon>();
        if (this.west.size() == this.south.size() && this.south.size() == this.east.size() && this.east.size() == this.north.size()) {
            for (int i = 0; i < this.west.size(); ++i) {
                float w = ((Float)this.west.elementAt(i)).floatValue();
                float s = ((Float)this.south.elementAt(i)).floatValue();
                float e = ((Float)this.east.elementAt(i)).floatValue();
                float n = ((Float)this.north.elementAt(i)).floatValue();
                if ((double)w == 0.0 && (double)s == 0.0 && (double)e == 0.0 && (double)n == 0.0) {
                    log.warn((Object)"        Invalid or empty coodinates ... skipping");
                    continue;
                }
                if (Float.compare(w, e) == 0 && Float.compare(n, s) == 0) {
                    log.warn((Object)"        Point coordinates only.. skipping polygon generation");
                    continue;
                }
                float dl = 180.0f;
                float _dl = -180.0f;
                if (w > e && s > n) {
                    log.info((Object)"Crosses both the dateline and the poles .. split into 2 polygons, swap n & s");
                    polygons.add(this.createPolygonFromBbox(geomFac, w, n, dl, s));
                    polygons.add(this.createPolygonFromBbox(geomFac, _dl, n, e, s));
                    continue;
                }
                if (w > e) {
                    log.info((Object)"Crosses the dateline .. split into 2 polygons");
                    polygons.add(this.createPolygonFromBbox(geomFac, w, s, dl, n));
                    polygons.add(this.createPolygonFromBbox(geomFac, _dl, s, e, n));
                    continue;
                }
                if (s > n) {
                    log.info((Object)"Crosses the poles .. swap north and south");
                    polygons.add(this.createPolygonFromBbox(geomFac, w, n, e, s));
                    continue;
                }
                polygons.add(this.createPolygonFromBbox(geomFac, w, s, e, n));
            }
        } else {
            log.error((Object)" *** Something went wrong.. your east,west,north and south bounding arrays are different sizes!");
        }
        if (polygons.size() > 0) {
            Polygon[] polyArray = GeometryFactory.toPolygonArray(polygons);
            MultiPolygon multiPolyGeom = geomFac.createMultiPolygon(polyArray);
            return multiPolyGeom;
        }
        return null;
    }

    private Polygon createPolygonFromBbox(GeometryFactory geomFac, float w, float s, float e, float n) {
        Coordinate[] linestringCoordinates = new Coordinate[]{new Coordinate((double)w, (double)s), new Coordinate((double)w, (double)n), new Coordinate((double)e, (double)n), new Coordinate((double)e, (double)s), new Coordinate((double)w, (double)s)};
        return geomFac.createPolygon(geomFac.createLinearRing(linestringCoordinates), null);
    }

    private MultiPoint getPointGeometry() {
        PrecisionModel precModel = new PrecisionModel();
        GeometryFactory geomFac = new GeometryFactory(precModel, SpatialFeatureSchema.srid);
        Object pstmt = null;
        Object rs = null;
        Vector<Point> points = new Vector<Point>();
        if (this.west.size() == this.south.size() && this.south.size() == this.east.size() && this.east.size() == this.north.size()) {
            for (int i = 0; i < this.west.size(); ++i) {
                float yCenter;
                float xCenter;
                float w = ((Float)this.west.elementAt(i)).floatValue();
                float s = ((Float)this.south.elementAt(i)).floatValue();
                float e = ((Float)this.east.elementAt(i)).floatValue();
                float n = ((Float)this.north.elementAt(i)).floatValue();
                if (w == 0.0f && s == 0.0f && e == 0.0f && n == 0.0f) {
                    log.warn((Object)"        Invalid or empty coodinates ... skipping");
                    continue;
                }
                if (w > e) {
                    log.info((Object)"Crosses the dateline .. ");
                    xCenter = (360.0f - w + e) / 2.0f + w;
                    if (xCenter > 180.0f) {
                        xCenter -= 360.0f;
                    }
                    yCenter = (s + n) / 2.0f;
                } else {
                    xCenter = (w + e) / 2.0f;
                    yCenter = (s + n) / 2.0f;
                }
                points.add(geomFac.createPoint(new Coordinate((double)xCenter, (double)yCenter)));
            }
        } else {
            log.error((Object)" *** Something went wrong.. your east,west,north and south bounding vectors are different sizes!");
        }
        if (points.size() > 0) {
            Point[] pointArray = GeometryFactory.toPointArray(points);
            MultiPoint multiPointGeom = geomFac.createMultiPoint(pointArray);
            return multiPointGeom;
        }
        return null;
    }
}

