/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat.spatial;

import edu.ucsb.nceas.metacat.database.DBConnection;
import edu.ucsb.nceas.metacat.spatial.SpatialDataset;
import edu.ucsb.nceas.metacat.spatial.SpatialDocument;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.opengis.feature.simple.SimpleFeature;

public class SpatialHarvester {
    private static Log log = LogFactory.getLog((String)SpatialHarvester.class.getName());
    private DBConnection dbconn;

    public SpatialHarvester() {
        try {
            this.dbconn = new DBConnection();
        }
        catch (Exception e) {
            log.error((Object)"Error getting docids from queryAllDocids");
            e.printStackTrace();
        }
    }

    public void destroy() {
        try {
            this.dbconn.close();
        }
        catch (SQLException e) {
            log.error((Object)"Error closing out dbconn in spatial harvester");
            e.printStackTrace();
        }
    }

    protected Vector<String> queryAllDocids() {
        Vector<String> _docs = new Vector<String>();
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        String query = "select distinct id.docid from xml_access xa, identifier id, xml_documents xd where xa.guid = id.guid and id.docid = xd.docid and id.rev = xd.rev and xa.principal_name = 'public' and xa.perm_type = 'allow'";
        try {
            pstmt = this.dbconn.prepareStatement(query);
            pstmt.execute();
            rs = pstmt.getResultSet();
            while (rs.next()) {
                String docid = rs.getString(1);
                if (docid == null) continue;
                _docs.add(docid);
            }
            rs.close();
            pstmt.close();
        }
        catch (Exception e) {
            log.error((Object)"Error getting docids from queryAllDocids");
            e.printStackTrace();
        }
        return _docs;
    }

    public void addToUpdateQue(String docid) {
        this.harvestDocument(docid);
    }

    public void addToDeleteQue(String docid) {
        this.deleteDocument(docid);
    }

    public void deleteDocument(String docid) {
        try {
            SpatialDataset sds = new SpatialDataset();
            sds.delete("polygon", docid);
            sds.delete("point", docid);
        }
        catch (IOException e) {
            log.error((Object)"IOException while deleting from spatial cache");
        }
        log.info((Object)(" --------- Spatial Harvester - Deleted from spatial cache : " + docid));
    }

    public void harvestDocument(String docid) {
        long before = System.currentTimeMillis();
        try {
            SpatialDataset sds = new SpatialDataset();
            SpatialDocument sdoc = new SpatialDocument(docid, this.dbconn);
            SimpleFeature polygonFeature = sdoc.getPolygonFeature();
            sds.insertOrUpdate("polygon", polygonFeature, docid);
            SimpleFeature pointFeature = sdoc.getPointFeature();
            sds.insertOrUpdate("point", pointFeature, docid);
            long after = System.currentTimeMillis();
            log.info((Object)(" ------- Spatial Harvester - spatial cache updated for : " + docid + ".... Time  " + (after - before) + "ms"));
        }
        catch (IOException e) {
            log.error((Object)"IOException while performing spatial harvest ");
        }
    }

    public void regenerate() throws IOException {
        SpatialDataset sds = new SpatialDataset();
        Vector<String> docids = this.queryAllDocids();
        for (int i = 0; i < docids.size(); ++i) {
            SpatialDocument sdoc = new SpatialDocument(docids.elementAt(i), this.dbconn);
            SimpleFeature polygonFeature = sdoc.getPolygonFeature();
            sds.add("polygon", polygonFeature);
            SimpleFeature pointFeature = sdoc.getPointFeature();
            sds.add("point", pointFeature);
            log.info((Object)(" ****** Spatial harvest of docid " + docids.elementAt(i)));
        }
        sds.save();
    }
}

