/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat.util;

import edu.ucsb.nceas.metacat.AuthSession;
import edu.ucsb.nceas.metacat.dataone.D1AuthHelper;
import edu.ucsb.nceas.metacat.properties.PropertyService;
import edu.ucsb.nceas.metacat.service.SessionService;
import edu.ucsb.nceas.metacat.shared.MetacatUtilException;
import edu.ucsb.nceas.metacat.shared.ServiceException;
import edu.ucsb.nceas.metacat.util.SessionData;
import edu.ucsb.nceas.utilities.PropertyNotFoundException;
import java.util.Calendar;
import java.util.Vector;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dataone.service.exceptions.ServiceFailure;
import org.dataone.service.types.v1.Group;
import org.dataone.service.types.v1.Person;
import org.dataone.service.types.v1.Session;
import org.dataone.service.types.v1.Subject;
import org.dataone.service.types.v1.SubjectInfo;

public class AuthUtil {
    public static Log logMetacat = LogFactory.getLog(AuthUtil.class);
    public static String DELIMITER = ":";
    public static String ESCAPECHAR = "\\";
    private static Vector<String> administrators = null;
    private static Vector<String> moderators = null;
    private static Vector<String> allowedSubmitters = null;
    private static Vector<String> deniedSubmitters = null;

    private AuthUtil() {
    }

    public static Vector<String> getAdministrators() throws MetacatUtilException {
        if (administrators == null) {
            AuthUtil.populateAdministrators();
        }
        return administrators;
    }

    public static Vector<String> getAllowedSubmitters() throws MetacatUtilException {
        if (allowedSubmitters == null) {
            AuthUtil.populateAllowedSubmitters();
        }
        return allowedSubmitters;
    }

    public static Vector<String> getDeniedSubmitters() throws MetacatUtilException {
        if (deniedSubmitters == null) {
            AuthUtil.populateDeniedSubmitters();
        }
        return deniedSubmitters;
    }

    public static Vector<String> getModerators() throws MetacatUtilException {
        if (moderators == null) {
            AuthUtil.populateModerators();
        }
        return moderators;
    }

    private static void populateAdministrators() throws MetacatUtilException {
        String administratorString = null;
        try {
            administratorString = PropertyService.getProperty("auth.administrators");
        }
        catch (PropertyNotFoundException pnfe) {
            throw new MetacatUtilException("Could not get metacat property: auth.administrators. There will be no registered metacat adminstrators: " + pnfe.getMessage());
        }
        administrators = AuthUtil.split(administratorString, DELIMITER, ESCAPECHAR);
        String d1NodeAdmin = null;
        try {
            d1NodeAdmin = PropertyService.getProperty("dataone.subject");
            administrators.add(d1NodeAdmin);
        }
        catch (PropertyNotFoundException e) {
            String msg = "Could not get metacat property: dataone.subject There will be no registered DataONE adminstrator";
            logMetacat.error((Object)msg, (Throwable)e);
        }
    }

    public static void populateAllowedSubmitters() throws MetacatUtilException {
        String allowedSubmitterString = null;
        try {
            allowedSubmitterString = PropertyService.getProperty("auth.allowedSubmitters");
        }
        catch (PropertyNotFoundException pnfe) {
            throw new MetacatUtilException("Could not get metacat property: auth.allowedSubmitters. Anyone will be allowed to submit: " + pnfe.getMessage());
        }
        allowedSubmitters = AuthUtil.split(allowedSubmitterString, DELIMITER, ESCAPECHAR);
    }

    private static void populateDeniedSubmitters() throws MetacatUtilException {
        String deniedSubmitterString = null;
        try {
            deniedSubmitterString = PropertyService.getProperty("auth.deniedSubmitters");
        }
        catch (PropertyNotFoundException pnfe) {
            throw new MetacatUtilException("Could not get metacat property: auth.deniedSubmitters: " + pnfe.getMessage());
        }
        deniedSubmitters = AuthUtil.split(deniedSubmitterString, DELIMITER, ESCAPECHAR);
    }

    private static void populateModerators() throws MetacatUtilException {
        String moderatorString = null;
        try {
            moderatorString = PropertyService.getProperty("auth.moderators");
        }
        catch (PropertyNotFoundException pnfe) {
            throw new MetacatUtilException("Could not get metacat property: auth.moderators. There will be no registered metacat moderators: " + pnfe.getMessage());
        }
        moderators = AuthUtil.split(moderatorString, DELIMITER, ESCAPECHAR);
    }

    public static boolean logUserIn(HttpServletRequest request, String userName, String password) throws MetacatUtilException {
        AuthSession authSession = null;
        if (userName == null || password == null) {
            throw new MetacatUtilException("null username or password when logging user in");
        }
        try {
            authSession = new AuthSession();
        }
        catch (Exception e) {
            throw new MetacatUtilException("Could not instantiate AuthSession: " + e.getMessage());
        }
        if (!authSession.authenticate(request, userName, password)) {
            throw new MetacatUtilException(authSession.getMessage());
        }
        HttpSession session = authSession.getSessions();
        String sessionId = session.getId();
        try {
            SessionService.getInstance().registerSession(sessionId, (String)session.getAttribute("username"), (String[])session.getAttribute("groupnames"), (String)session.getAttribute("password"), (String)session.getAttribute("name"));
        }
        catch (ServiceException se) {
            throw new MetacatUtilException("Problem registering session: " + se.getMessage());
        }
        return true;
    }

    public static boolean isUserLoggedIn(HttpServletRequest request) throws MetacatUtilException {
        SessionData sessionData = null;
        String sessionId = request.getSession().getId();
        try {
            if (sessionId != null && SessionService.getInstance().isSessionRegistered(sessionId)) {
                sessionData = SessionService.getInstance().getRegisteredSession(sessionId);
                String sessionTimeout = PropertyService.getProperty("auth.timeoutMinutes");
                int sessionTimeoutInt = Integer.parseInt(sessionTimeout);
                Calendar lastAccessedTime = sessionData.getLastAccessedTime();
                Calendar now = Calendar.getInstance();
                now.add(12, 0 - sessionTimeoutInt);
                if (lastAccessedTime.before(now)) {
                    SessionService.getInstance().unRegisterSession(sessionId);
                    return false;
                }
                return true;
            }
        }
        catch (PropertyNotFoundException pnfe) {
            throw new MetacatUtilException("Could not determine if user is logged in because of property error: " + pnfe.getMessage());
        }
        catch (NumberFormatException nfe) {
            throw new MetacatUtilException("Could not determine if user is logged in because of number conversion error: " + nfe.getMessage());
        }
        return false;
    }

    public static boolean isUserLoggedInAsAdmin(HttpServletRequest request) throws MetacatUtilException {
        if (!AuthUtil.isUserLoggedIn(request)) {
            return false;
        }
        String userName = AuthUtil.getUserName(request);
        boolean isAdmin = AuthUtil.isAdministrator(userName, null);
        return isAdmin;
    }

    public static String getUserName(HttpServletRequest request) {
        String userName = (String)request.getSession().getAttribute("username");
        return userName;
    }

    public static String[] getGroupNames(HttpServletRequest request) {
        String sessionId = request.getSession().getId();
        SessionData sessionData = SessionService.getInstance().getRegisteredSession(sessionId);
        String[] groupNames = new String[]{""};
        if (sessionData != null) {
            groupNames = sessionData.getGroupNames();
        }
        return groupNames;
    }

    public static String createLDAPString(String username, String organization, Vector<String> dnList) throws MetacatUtilException {
        if (username == null || organization == null || dnList == null || dnList.size() == 0) {
            throw new MetacatUtilException("Could not generate LDAP user string.  One of the following is null: username, organization or dnlist");
        }
        String ldapString = "uid=" + username + ",o=" + organization;
        for (String dn : dnList) {
            ldapString = ldapString + "," + dn;
        }
        return ldapString;
    }

    public static boolean isAuthConfigured() throws MetacatUtilException {
        String authConfiguredString = "false";
        try {
            authConfiguredString = PropertyService.getProperty("configutil.authConfigured");
        }
        catch (PropertyNotFoundException pnfe) {
            throw new MetacatUtilException("Could not determine if LDAP is configured: " + pnfe.getMessage());
        }
        return !authConfiguredString.equals("false");
    }

    public static boolean isAdministrator(String username, String[] groups) throws MetacatUtilException {
        return AuthUtil.onAccessList(AuthUtil.getAdministrators(), username, groups);
    }

    public static boolean isModerator(String username, String[] groups) throws MetacatUtilException {
        return AuthUtil.onAccessList(AuthUtil.getModerators(), username, groups);
    }

    public static boolean isAllowedSubmitter(String username, String[] groups) throws MetacatUtilException {
        if (AuthUtil.getAllowedSubmitters().size() == 0) {
            return true;
        }
        boolean allow = AuthUtil.onAccessList(AuthUtil.getAllowedSubmitters(), username, groups);
        if (!allow) {
            D1AuthHelper helper = new D1AuthHelper(null, null, null, null);
            Session session = AuthUtil.buildSession(username, groups);
            try {
                allow = helper.isLocalMNAdmin(session);
            }
            catch (ServiceFailure e) {
                throw new MetacatUtilException(e.getMessage());
            }
        }
        return allow;
    }

    public static boolean isDeniedSubmitter(String username, String[] groups) throws MetacatUtilException {
        return AuthUtil.onAccessList(AuthUtil.getDeniedSubmitters(), username, groups);
    }

    public static boolean canInsertOrUpdate(String username, String[] groups) throws MetacatUtilException {
        if (logMetacat.isDebugEnabled()) {
            logMetacat.debug((Object)("AuthUtil.canInsertOrUpdate - The user is " + username));
            if (groups == null) {
                logMetacat.debug((Object)"AuthUtil.canInsertOrUpdate -The group is null");
            } else if (groups.length == 0) {
                logMetacat.debug((Object)"AuthUtil.canInsertOrUpdate -The group is empty");
            } else {
                logMetacat.debug((Object)"AuthUtil.canInsertOrUpdate -And this user is in the group(s)");
                for (int i = 0; i < groups.length; ++i) {
                    logMetacat.debug((Object)("AuthUtil.canInsertOrUpdate -Group " + groups[i]));
                }
            }
        }
        return AuthUtil.isAllowedSubmitter(username, groups) && !AuthUtil.isDeniedSubmitter(username, groups);
    }

    private static boolean onAccessList(Vector<String> accessList, String username, String[] groups) {
        if (accessList == null) {
            return false;
        }
        for (String accessString : accessList) {
            if (username != null && username.equals(accessString)) {
                logMetacat.debug((Object)("AuthUtil.onAccessList - user " + username + " is in the access list."));
                return true;
            }
            if (groups == null) continue;
            for (int j = 0; j < groups.length; ++j) {
                if (groups[j] == null || !groups[j].equals(accessString)) continue;
                logMetacat.debug((Object)("AuthUtil.onAccessList - user " + username + " has a grouup which is in the access list."));
                return true;
            }
        }
        return false;
    }

    public static Vector<String> split(String text, String delimiter, String escapeChar) {
        Vector<String> results = new Vector<String>();
        if (text != null && text.length() > 0 && delimiter != null && escapeChar != null) {
            String regex = "(?<!" + Pattern.quote(escapeChar) + ")" + Pattern.quote(delimiter);
            logMetacat.debug((Object)("AuthUtil.split - The regex is " + regex));
            String[] strArray = text.split(regex);
            if (strArray != null) {
                for (int i = 0; i < strArray.length; ++i) {
                    logMetacat.debug((Object)("AuthUtil.split - the splitted original value " + strArray[i]));
                    String remove = strArray[i].replaceAll(Pattern.quote(escapeChar + delimiter), delimiter);
                    logMetacat.debug((Object)("AuthUtil.split - the value after removed escpate char is " + remove));
                    results.add(remove);
                }
            }
        }
        return results;
    }

    private static Session buildSession(String user, String[] groups) {
        Session session = new Session();
        Subject userSubject = new Subject();
        userSubject.setValue(user);
        session.setSubject(userSubject);
        SubjectInfo subjectInfo = new SubjectInfo();
        Person person = new Person();
        person.setSubject(userSubject);
        if (groups != null && groups.length > 0) {
            for (String groupName : groups) {
                Group group = new Group();
                group.setGroupName(groupName);
                Subject groupSubject = new Subject();
                groupSubject.setValue(groupName);
                group.setSubject(groupSubject);
                subjectInfo.addGroup(group);
                person.addIsMemberOf(groupSubject);
            }
        }
        subjectInfo.addPerson(person);
        session.setSubjectInfo(subjectInfo);
        return session;
    }
}

