/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat.util;

import edu.ucsb.nceas.metacat.database.DBVersion;
import edu.ucsb.nceas.metacat.properties.PropertyService;
import edu.ucsb.nceas.metacat.shared.MetacatUtilException;
import edu.ucsb.nceas.utilities.PropertyNotFoundException;
import java.util.Map;
import java.util.TreeSet;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DatabaseUtil {
    private static Log logMetacat = LogFactory.getLog(DatabaseUtil.class);

    private DatabaseUtil() {
    }

    public static boolean isDatabaseConfigured() throws MetacatUtilException {
        String databaseConfiguredString = "false";
        try {
            databaseConfiguredString = PropertyService.getProperty("configutil.databaseConfigured");
        }
        catch (PropertyNotFoundException pnfe) {
            throw new MetacatUtilException("Could not determine if database is configured: " + pnfe.getMessage());
        }
        return !databaseConfiguredString.equals("false");
    }

    public static TreeSet<DBVersion> getUpgradeVersions() throws PropertyNotFoundException {
        TreeSet<DBVersion> versionSet = new TreeSet<DBVersion>();
        Vector<String> upgradeVersionKeys = PropertyService.getPropertyNamesByGroup("database.upgradeVersion");
        for (String upgradeVersionKey : upgradeVersionKeys) {
            String upgradeVersionId = upgradeVersionKey.substring(24);
            logMetacat.debug((Object)("Creating DBVersion object for version: " + upgradeVersionId));
            DBVersion dbVersion = new DBVersion(upgradeVersionId);
            versionSet.add(dbVersion);
        }
        return versionSet;
    }

    public static Map<String, String> getScriptSuffixes() throws PropertyNotFoundException {
        return PropertyService.getPropertiesByGroup("database.scriptsuffix");
    }
}

