/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat.util;

import edu.ucsb.nceas.dbadapter.AbstractDatabase;
import edu.ucsb.nceas.metacat.properties.PropertyService;
import edu.ucsb.nceas.metacat.util.SystemUtil;
import edu.ucsb.nceas.utilities.FileUtil;
import edu.ucsb.nceas.utilities.PropertyNotFoundException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MetacatUtil {
    public static final String XMLFORMAT = "xml";
    public static AbstractDatabase dbAdapter;
    private static boolean debugErrorDisplayed;
    private static Log logMetacat;

    public static Hashtable<String, String> parseQuery(String query) throws MalformedURLException {
        String[][] params = new String[200][2];
        Hashtable<String, String> parameters = new Hashtable<String, String>();
        String temp = "";
        boolean ampflag = true;
        boolean poundflag = false;
        int arrcount = 0;
        if (query != null) {
            for (int i = 0; i < query.length(); ++i) {
                if (query.charAt(i) == '=') {
                    if (poundflag || !ampflag) {
                        throw new MalformedURLException("metacatURL: Two parameter names not allowed in sequence");
                    }
                    params[arrcount][0] = temp.trim();
                    temp = "";
                    poundflag = true;
                    ampflag = false;
                    continue;
                }
                if (query.charAt(i) == '&' || i == query.length() - 1) {
                    if (i == query.length() - 1 && query.charAt(i) != '=') {
                        temp = temp + query.charAt(i);
                    }
                    if (!ampflag && poundflag) {
                        params[arrcount][1] = temp.trim();
                        parameters.put(params[arrcount][0], params[arrcount][1]);
                        temp = "";
                        ++arrcount;
                    } else {
                        throw new MalformedURLException("metacatURL: Two parameter values not allowed in sequence");
                    }
                    poundflag = false;
                    ampflag = true;
                    continue;
                }
                temp = temp + query.charAt(i);
            }
        }
        return parameters;
    }

    public static Vector<String> getOptionList(String optiontext) {
        Vector<String> optionsVector = new Vector<String>();
        if (optiontext.indexOf(",") == -1) {
            optionsVector.addElement(optiontext);
            return optionsVector;
        }
        while (optiontext.indexOf(",") != -1) {
            String s = optiontext.substring(0, optiontext.indexOf(","));
            optionsVector.addElement(s.trim());
            if ((optiontext = optiontext.substring(optiontext.indexOf(",") + 1, optiontext.length())).indexOf(",") != -1) continue;
            optionsVector.addElement(optiontext.trim());
        }
        return optionsVector;
    }

    public static String normalize(String s) {
        StringBuffer str = new StringBuffer();
        int len = s != null ? s.length() : 0;
        block7: for (int i = 0; i < len; ++i) {
            char ch = s.charAt(i);
            switch (ch) {
                case '<': {
                    str.append("&lt;");
                    continue block7;
                }
                case '>': {
                    str.append("&gt;");
                    continue block7;
                }
                case '&': {
                    if (i + 1 < len - 1 && s.charAt(i + 1) == '#') {
                        str.append("&#");
                        ch = s.charAt(i += 2);
                        while (i < len && ch != ';') {
                            str.append(ch);
                            ch = s.charAt(++i);
                        }
                        str.append(';');
                        continue block7;
                    }
                    if (i + 4 < len && s.charAt(i + 1) == 'a' && s.charAt(i + 2) == 'm' && s.charAt(i + 3) == 'p' && s.charAt(i + 4) == ';') {
                        str.append("&amp;");
                        i += 4;
                        continue block7;
                    }
                    if (i + 3 < len && s.charAt(i + 1) == 'l' && s.charAt(i + 2) == 't' && s.charAt(i + 3) == ';') {
                        str.append("&lt;");
                        i += 3;
                        continue block7;
                    }
                    if (i + 3 < len && s.charAt(i + 1) == 'g' && s.charAt(i + 2) == 't' && s.charAt(i + 3) == ';') {
                        str.append("&gt;");
                        i += 3;
                        continue block7;
                    }
                    if (i + 5 < len && s.charAt(i + 1) == 'q' && s.charAt(i + 2) == 'u' && s.charAt(i + 3) == 'o' && s.charAt(i + 4) == 't' && s.charAt(i + 5) == ';') {
                        str.append("&quot;");
                        i += 5;
                        continue block7;
                    }
                    if (i + 5 < len && s.charAt(i + 1) == 'a' && s.charAt(i + 2) == 'p' && s.charAt(i + 3) == 'o' && s.charAt(i + 4) == 's' && s.charAt(i + 5) == ';') {
                        str.append("&apos;");
                        i += 5;
                        continue block7;
                    }
                    str.append("&amp;");
                    continue block7;
                }
                case '\"': {
                    str.append("&quot;");
                    continue block7;
                }
                case '\'': {
                    str.append("&apos;");
                    continue block7;
                }
                default: {
                    if (ch < '\u0080' && ch > '\u001f') {
                        str.append(ch);
                        continue block7;
                    }
                    if (ch < ' ') {
                        if (ch == '\n') {
                            str.append(ch);
                        }
                        if (ch == '\r') {
                            str.append(ch);
                        }
                        if (ch != '\t') continue block7;
                        str.append(ch);
                        continue block7;
                    }
                    str.append(ch);
                }
            }
        }
        return str.toString();
    }

    public static String getLocalReplicationServerName() {
        String replicationServerName = null;
        try {
            replicationServerName = SystemUtil.getSecureServer() + "/" + PropertyService.getProperty("application.context") + "/servlet/replication";
        }
        catch (PropertyNotFoundException pnfe) {
            logMetacat.error((Object)("Could not get local replication server name because property could not be found: " + pnfe.getMessage()));
        }
        return replicationServerName;
    }

    public static String replaceWhiteSpaceForURL(String urlHasWhiteSpace) {
        StringBuffer newUrl = new StringBuffer();
        String whiteSpaceReplace = "%20";
        if (urlHasWhiteSpace == null || urlHasWhiteSpace.trim().equals("")) {
            return null;
        }
        for (int i = 0; i < urlHasWhiteSpace.length(); ++i) {
            char ch = urlHasWhiteSpace.charAt(i);
            if (!Character.isWhitespace(ch)) {
                newUrl.append(ch);
                continue;
            }
            newUrl = newUrl.append(whiteSpaceReplace);
        }
        logMetacat.info((Object)("The new string without space is:" + newUrl.toString()));
        return newUrl.toString();
    }

    public static void writeDebugToFile(String debugInfo) {
        String debug = "false";
        try {
            debug = PropertyService.getProperty("application.writeDebugToFile");
            if (debug != null && debug.equalsIgnoreCase("true")) {
                File outputFile = new File(PropertyService.getProperty("application.debugOutputFile"));
                FileOutputStream fos = new FileOutputStream(outputFile, true);
                PrintWriter pw = new PrintWriter(fos);
                pw.println(debugInfo);
                pw.flush();
                pw.close();
                fos.close();
            }
        }
        catch (PropertyNotFoundException pnfe) {
            if (!debugErrorDisplayed) {
                logMetacat.warn((Object)("Could not get debug property.  Write debug to file is set to false: " + pnfe.getMessage()));
                debugErrorDisplayed = true;
            }
        }
        catch (Exception io) {
            logMetacat.warn((Object)("Error in MetacatUtil.writeDebugToFile " + io.getMessage()));
        }
    }

    public static void writeDebugToDelimiteredFile(String debugInfo, boolean newLine) {
        String debug = "false";
        try {
            debug = PropertyService.getProperty("application.writeDebugToFile");
            if (debug != null && debug.equalsIgnoreCase("true")) {
                File outputFile = new File(PropertyService.getProperty("application.delimiteredOutputFile"));
                FileOutputStream fos = new FileOutputStream(outputFile, true);
                PrintWriter pw = new PrintWriter(fos);
                if (newLine) {
                    pw.println(debugInfo);
                } else {
                    pw.print(debugInfo);
                }
                pw.flush();
                pw.close();
                fos.close();
            }
        }
        catch (PropertyNotFoundException pnfe) {
            if (!debugErrorDisplayed) {
                logMetacat.warn((Object)("Could not get delimited debug property. Write debug to file is set to false: " + pnfe.getMessage()));
                debugErrorDisplayed = true;
            }
        }
        catch (Exception io) {
            logMetacat.warn((Object)("Eorr in writeDebugToDelimiteredFile " + io.getMessage()));
        }
    }

    public static File writeTempUploadFile(FileItem fi, String fileName) throws Exception {
        File tempFile = null;
        String tempDirPath = null;
        try {
            tempDirPath = PropertyService.getProperty("application.tempDir") + FileUtil.getFS() + "uploads";
        }
        catch (PropertyNotFoundException pnfe) {
            logMetacat.warn((Object)("Temp property not found.  An attempt will be made to use system temp directory: " + pnfe.getMessage()));
        }
        if (fileName == null || fileName.equals("")) {
            return tempFile;
        }
        if (tempDirPath == null) {
            String javaTempDir = System.getProperty("java.io.tempdir");
            tempDirPath = javaTempDir == null ? "/tmp" : javaTempDir;
        }
        File tempDir = new File(tempDirPath);
        try {
            if (!tempDir.exists()) {
                tempDir.mkdirs();
            }
        }
        catch (SecurityException e) {
            throw new IOException("Can't create directory: " + tempDir.getPath() + ". Error: " + e.getMessage());
        }
        tempFile = File.createTempFile("upload", ".tmp", tempDir);
        fi.write(tempFile);
        long fileSize = fi.getSize();
        if (fileSize == 0L) {
            logMetacat.warn((Object)("Uploaded file '" + fileName + "'is empty!"));
        }
        logMetacat.debug((Object)("Temporary file is: " + tempFile.getAbsolutePath()));
        return tempFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(String sourceName, String destName) throws IOException {
        File sourceFile = new File(sourceName);
        File destFile = new File(destName);
        FileInputStream source = null;
        FileOutputStream dest = null;
        try {
            int bytesRead;
            if (!sourceFile.exists() || !sourceFile.isFile()) {
                logMetacat.error((Object)("File copy: no such source file: " + sourceName));
            }
            if (!sourceFile.canRead()) {
                logMetacat.error((Object)("File copy: source file is unreadable: " + sourceName));
            }
            if (destFile.exists()) {
                if (destFile.isFile()) {
                    if (!destFile.canWrite()) {
                        logMetacat.error((Object)("File copy: destination file is unwriteable: " + destFile));
                    }
                } else {
                    logMetacat.error((Object)("File copy: destination file is not a file: " + destFile));
                }
            } else {
                File parentDir = MetacatUtil.parent(destFile);
                if (!parentDir.exists()) {
                    logMetacat.error((Object)("File copy: destination diretory  doesn't exist: " + destName));
                }
                if (!parentDir.canWrite()) {
                    logMetacat.error((Object)("File copy: destination directory  is unwritable: " + destName));
                }
            }
            source = new FileInputStream(sourceFile);
            dest = new FileOutputStream(destFile);
            byte[] buffer = new byte[1024];
            while ((bytesRead = source.read(buffer)) != -1) {
                dest.write(buffer, 0, bytesRead);
            }
        }
        finally {
            if (source != null) {
                try {
                    source.close();
                }
                catch (IOException iOException) {}
            }
            if (dest != null) {
                try {
                    dest.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static File parent(File f) {
        String dirname = f.getParent();
        if (dirname == null) {
            if (f.isAbsolute()) {
                return new File(File.separator);
            }
            return new File(System.getProperty("user.dir"));
        }
        return new File(dirname);
    }

    static {
        debugErrorDisplayed = false;
        logMetacat = LogFactory.getLog(MetacatUtil.class);
    }
}

