/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat.util;

import edu.ucsb.nceas.metacat.MetaCatServlet;
import edu.ucsb.nceas.metacat.MetacatVersion;
import edu.ucsb.nceas.metacat.properties.PropertyService;
import edu.ucsb.nceas.metacat.service.ServiceService;
import edu.ucsb.nceas.metacat.shared.MetacatUtilException;
import edu.ucsb.nceas.metacat.shared.ServiceException;
import edu.ucsb.nceas.utilities.FileUtil;
import edu.ucsb.nceas.utilities.PropertyNotFoundException;
import edu.ucsb.nceas.utilities.StringUtil;
import edu.ucsb.nceas.utilities.UtilException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Vector;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SystemUtil {
    private static Log logMetacat = LogFactory.getLog(SystemUtil.class);
    private static String METACAT_SERVLET = "metacat";
    private static int OS_CLASS = 0;
    private static boolean firstTimeTryInternalURL = true;
    private static boolean firstTryInternalURLAfterFullInit = true;
    private static String internalURL = null;
    private static boolean internalURLReplacedByExternal = false;
    public static int WIN_OS = 1;
    public static int LINUX_OS = 2;
    public static int MAC_OS = 3;
    public static int OTHER_OS = 4;

    private SystemUtil() {
    }

    public static int getOsClass() {
        if (OS_CLASS > 0) {
            return OS_CLASS;
        }
        String osName = System.getProperty("os.name");
        if (osName.startsWith("Windows")) {
            OS_CLASS = WIN_OS;
        } else if (osName.startsWith("Linux")) {
            OS_CLASS = LINUX_OS;
        } else if (osName.startsWith("Mac")) {
            OS_CLASS = MAC_OS;
        } else if (osName.startsWith("Mac")) {
            OS_CLASS = OTHER_OS;
        }
        return OS_CLASS;
    }

    public static String discoverServerName(HttpServletRequest request) {
        String serverName = request.getServerName();
        return serverName;
    }

    public static String discoverServerPort(HttpServletRequest request) {
        return Integer.toString(request.getServerPort());
    }

    public static String discoverServerSSLPort(HttpServletRequest request) {
        String serverPort = SystemUtil.discoverServerPort(request);
        if (serverPort.length() == 4 && serverPort.charAt(0) == '8') {
            return "8443";
        }
        return "443";
    }

    public static String getServerURL() throws PropertyNotFoundException {
        String httpPort = PropertyService.getProperty("server.httpPort");
        String serverURL = "http://";
        if (httpPort.equals("443") || httpPort.equals("8443")) {
            serverURL = "https://";
        }
        serverURL = serverURL + PropertyService.getProperty("server.name");
        if (!httpPort.equals("80") && !httpPort.equals("443")) {
            serverURL = serverURL + ":" + httpPort;
        }
        return serverURL;
    }

    public static String getSecureServerURL() throws PropertyNotFoundException {
        String ServerURL = "https://" + SystemUtil.getSecureServer();
        return ServerURL;
    }

    public static String getSecureServer() throws PropertyNotFoundException {
        String server = PropertyService.getProperty("server.name");
        String httpPort = PropertyService.getProperty("server.httpSSLPort");
        if (!httpPort.equals("443")) {
            server = server + ":" + httpPort;
        }
        return server;
    }

    public static String getCGI_URL() throws PropertyNotFoundException {
        return SystemUtil.getContextURL() + PropertyService.getProperty("application.cgiDir");
    }

    public static String getContextURL() throws PropertyNotFoundException {
        return SystemUtil.getServerURL() + "/" + PropertyService.getProperty("application.context");
    }

    public static String getSecureContextURL() throws PropertyNotFoundException {
        return SystemUtil.getSecureServerURL() + "/" + PropertyService.getProperty("application.context");
    }

    public static String getServletURL() throws PropertyNotFoundException {
        return SystemUtil.getContextURL() + "/" + METACAT_SERVLET;
    }

    public static String getInternalContextURL() throws PropertyNotFoundException {
        return SystemUtil.getInternalServerURL() + "/" + PropertyService.getProperty("application.context");
    }

    public static String getInternalServerURL() throws PropertyNotFoundException {
        if (firstTimeTryInternalURL) {
            firstTimeTryInternalURL = false;
            internalURL = SystemUtil.getInternalServerFromProp();
        } else if (firstTryInternalURLAfterFullInit && MetaCatServlet.isFullyInitialized()) {
            firstTryInternalURLAfterFullInit = false;
            internalURL = SystemUtil.getInternalServerFromProp();
            try {
                URL internal = new URL(internalURL + "/" + PropertyService.getProperty("application.context"));
                HttpURLConnection connection = (HttpURLConnection)internal.openConnection();
                if (connection.getResponseCode() != 200) {
                    throw new Exception("The local server " + internalURL + "/" + PropertyService.getProperty("application.context") + " is not accessible since the http reponse code is " + connection.getResponseCode());
                }
            }
            catch (Exception e) {
                logMetacat.warn((Object)("SystemUtil.getInternalServerURL - Metacat can't access the local url - " + internalURL + "/" + PropertyService.getProperty("application.context") + " and it will use the exteranl url since " + e.getMessage()), (Throwable)e);
                internalURLReplacedByExternal = true;
                internalURL = SystemUtil.getServerURL();
            }
        }
        logMetacat.debug((Object)("SystemUtil.getInternalServerURL - the final internal url is " + internalURL));
        return internalURL;
    }

    public static boolean isInternalURLReplacedByExternal() {
        return internalURLReplacedByExternal;
    }

    private static String getInternalServerFromProp() throws PropertyNotFoundException {
        String serverURL = "http://";
        serverURL = serverURL + PropertyService.getProperty("server.internalName");
        serverURL = serverURL + ":" + PropertyService.getProperty("server.internalPort");
        logMetacat.debug((Object)("SystemUtil.getInternalServerFromProp - the internal url from metacat.properties is " + serverURL));
        return serverURL;
    }

    public static String getStyleSkinsURL() throws PropertyNotFoundException {
        return SystemUtil.getContextURL() + "/style/skins";
    }

    public static String getStyleCommonURL() throws PropertyNotFoundException {
        return SystemUtil.getContextURL() + "/style/common";
    }

    public static MetacatVersion getMetacatVersion() throws PropertyNotFoundException {
        String metacatVersionString = PropertyService.getProperty("application.metacatVersion");
        return new MetacatVersion(metacatVersionString);
    }

    public static String getMetacatReleaseInfo() throws PropertyNotFoundException {
        return PropertyService.getProperty("application.metacatReleaseInfo");
    }

    public static String getContextDir() throws PropertyNotFoundException {
        return PropertyService.getProperty("application.deployDir") + FileUtil.getFS() + PropertyService.getProperty("application.context");
    }

    public static String discoverApplicationContext(ServletContext servletContext) {
        int lastSlashIndex;
        String applicationContext = "";
        String realPath = servletContext.getRealPath("/");
        if (realPath.charAt(realPath.length() - 1) == '/') {
            realPath = realPath.substring(0, realPath.length() - 1);
        }
        if ((lastSlashIndex = realPath.lastIndexOf(47)) != -1) {
            applicationContext = realPath.substring(lastSlashIndex + 1);
        }
        logMetacat.debug((Object)("application context: " + applicationContext));
        return applicationContext;
    }

    public static String getStoredBackupDir() throws MetacatUtilException {
        String applicationContext = null;
        try {
            String storedBackupDirLoc;
            applicationContext = ServiceService.getRealApplicationContext();
            String storedBackupFileLoc = SystemUtil.getUserHomeDir() + FileUtil.getFS() + "." + applicationContext + FileUtil.getFS() + "backup-location";
            if (FileUtil.getFileStatus((String)storedBackupFileLoc) >= FileUtil.EXISTS_READABLE && FileUtil.isDirectory((String)(storedBackupDirLoc = FileUtil.readFileToString((String)storedBackupFileLoc))) && FileUtil.getFileStatus((String)storedBackupDirLoc) > FileUtil.EXISTS_READABLE) {
                return storedBackupDirLoc;
            }
        }
        catch (UtilException ue) {
            logMetacat.warn((Object)("Utility problem finding backup location: " + ue.getMessage()));
        }
        catch (ServiceException se) {
            logMetacat.warn((Object)("Could not get real application context: " + se.getMessage()));
        }
        return null;
    }

    public static void writeStoredBackupFile(String backupPath) throws MetacatUtilException {
        String applicationContext = null;
        try {
            applicationContext = ServiceService.getRealApplicationContext();
            String storedBackupFileDir = SystemUtil.getUserHomeDir() + FileUtil.getFS() + "." + applicationContext;
            String storedBackupFileLoc = storedBackupFileDir + FileUtil.getFS() + "backup-location";
            if (!FileUtil.isDirectory((String)storedBackupFileDir)) {
                FileUtil.createDirectory((String)storedBackupFileDir);
            }
            if (FileUtil.getFileStatus((String)storedBackupFileLoc) == FileUtil.DOES_NOT_EXIST) {
                FileUtil.createFile((String)storedBackupFileLoc);
            }
            if (FileUtil.getFileStatus((String)storedBackupFileLoc) < FileUtil.EXISTS_READ_WRITABLE) {
                throw new UtilException("Stored backup location file is not writable: " + storedBackupFileLoc);
            }
            FileUtil.writeFile((String)storedBackupFileLoc, (String)backupPath);
        }
        catch (UtilException ue) {
            logMetacat.warn((Object)("Utility error writing backup file: " + ue.getMessage()));
        }
        catch (ServiceException se) {
            logMetacat.warn((Object)("Service error getting real application context: " + se.getMessage()));
        }
    }

    public static String discoverExternalDir() throws MetacatUtilException {
        String applicationContext = null;
        try {
            applicationContext = ServiceService.getRealApplicationContext();
            String systemDir = "";
            systemDir = SystemUtil.getOsClass() == WIN_OS ? "C:\\Program Files" : "/var";
            String systemMetacatDir = systemDir + FileUtil.getFS() + "metacat";
            String systemBackupDir = systemMetacatDir + FileUtil.getFS() + "." + applicationContext;
            String userHomeDir = SystemUtil.getUserHomeDir();
            String userHomeMetacatDir = userHomeDir + FileUtil.getFS() + "metacat";
            String userHomeBackupDir = userHomeMetacatDir + FileUtil.getFS() + "." + applicationContext;
            if (FileUtil.getFileStatus((String)systemBackupDir) >= FileUtil.EXISTS_READ_WRITABLE) {
                return systemMetacatDir;
            }
            if (FileUtil.getFileStatus((String)userHomeBackupDir) >= FileUtil.EXISTS_READ_WRITABLE) {
                return userHomeMetacatDir;
            }
            if (FileUtil.getFileStatus((String)systemMetacatDir) >= FileUtil.EXISTS_READ_WRITABLE) {
                FileUtil.createDirectory((String)systemBackupDir);
                return systemMetacatDir;
            }
            if (FileUtil.getFileStatus((String)userHomeMetacatDir) >= FileUtil.EXISTS_READ_WRITABLE) {
                FileUtil.createDirectory((String)userHomeBackupDir);
                return userHomeMetacatDir;
            }
            if (FileUtil.getFileStatus((String)systemDir) >= FileUtil.EXISTS_READ_WRITABLE) {
                FileUtil.createDirectory((String)systemBackupDir);
                return systemMetacatDir;
            }
            if (FileUtil.getFileStatus((String)userHomeDir) >= FileUtil.EXISTS_READ_WRITABLE) {
                FileUtil.createDirectory((String)userHomeBackupDir);
                return userHomeMetacatDir;
            }
        }
        catch (ServiceException se) {
            logMetacat.warn((Object)("Could not get real application context: " + se.getMessage()));
        }
        catch (UtilException ue) {
            logMetacat.warn((Object)("Could not create directory: " + ue.getMessage()));
        }
        return null;
    }

    public static void storeExternalDirLocation(String externalDir) {
        if (SystemUtil.getUserHomeDir() != null) {
            String applicationContext = null;
            String storedBackupLocDir = null;
            String storedBackupLocFile = null;
            try {
                applicationContext = ServiceService.getRealApplicationContext();
                storedBackupLocDir = SystemUtil.getUserHomeDir() + FileUtil.getFS() + "." + applicationContext;
                storedBackupLocFile = storedBackupLocDir + FileUtil.getFS() + "backup-location";
                FileUtil.createDirectory((String)storedBackupLocDir);
                FileUtil.writeFile((String)storedBackupLocFile, (String)externalDir);
            }
            catch (ServiceException se) {
                logMetacat.error((Object)("Could not get real application directory while trying to write stored backup directory: " + storedBackupLocFile + " : " + se.getMessage()));
            }
            catch (UtilException ue) {
                logMetacat.error((Object)("Could not write backup location file into stored backup directory: " + storedBackupLocFile + " : " + ue.getMessage()));
            }
        } else {
            logMetacat.warn((Object)"Could not write out stored backup directory. User directory does not exist");
        }
    }

    public static String getStyleSkinsDir() throws PropertyNotFoundException {
        return SystemUtil.getContextDir() + FileUtil.getFS() + "style" + FileUtil.getFS() + "skins";
    }

    public static String getSQLDir() throws PropertyNotFoundException {
        return SystemUtil.getContextDir() + FileUtil.getFS() + "WEB-INF" + FileUtil.getFS() + "sql";
    }

    public static String getDefaultStyleURL() throws PropertyNotFoundException {
        return SystemUtil.getStyleCommonURL() + "/" + PropertyService.getProperty("application.default-style");
    }

    public static String discoverDeployDir(HttpServletRequest request) {
        ServletContext servletContext = request.getSession().getServletContext();
        String realPath = servletContext.getRealPath(".");
        String contextPath = request.getContextPath();
        logMetacat.debug((Object)("realPath: " + realPath));
        logMetacat.debug((Object)("contextPath: " + contextPath));
        int index = realPath.lastIndexOf(contextPath);
        if (index != -1 && (realPath = realPath.substring(0, index)).equals("")) {
            realPath = "/";
        }
        logMetacat.info((Object)("SystemUtil.discoverDeployDir: the deploy dir is " + realPath));
        return realPath;
    }

    public static String getUserHomeDir() {
        return System.getProperty("user.home");
    }

    public static Vector<String> getPathsForIndexing() throws MetacatUtilException {
        Vector indexPaths = null;
        try {
            indexPaths = StringUtil.toVector((String)PropertyService.getProperty("xml.indexPaths"), (char)',');
        }
        catch (PropertyNotFoundException pnfe) {
            throw new MetacatUtilException("could not get index paths: " + pnfe.getMessage());
        }
        return indexPaths;
    }

    public static String getUserManagementUrl() throws PropertyNotFoundException {
        return PropertyService.getProperty("auth.userManagementUrl");
    }

    public static String getCommonSkinsDir() throws PropertyNotFoundException {
        return SystemUtil.getContextDir() + FileUtil.getFS() + "style" + FileUtil.getFS() + "common";
    }
}

