/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.dsml.jndi;

import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.exolab.castor.dsml.Consumer;
import org.exolab.castor.dsml.Exporter;
import org.exolab.castor.dsml.ImportExportException;
import org.exolab.castor.dsml.jndi.JNDIConsumer;
import org.exolab.castor.dsml.jndi.JNDIProducer;
import org.exolab.castor.util.Messages;
import org.xml.sax.DocumentHandler;
import org.xml.sax.SAXException;

public class JNDIExporter
extends Exporter {
    private DirContext _ctx;

    public JNDIExporter(DirContext ctx) {
        this._ctx = ctx;
    }

    protected Consumer createConsumer() {
        return new JNDIConsumer();
    }

    public void export(DocumentHandler docHandler, boolean serverSchema, boolean importPolicy) throws ImportExportException {
        NamingEnumeration<SearchResult> namingEnumeration;
        if (this.getSearchDescriptor() == null) {
            throw new IllegalStateException(Messages.message("dsml.searchDescriptorRequired"));
        }
        String filter = this.getSearchDescriptor().getFilter();
        if (filter == null) {
            filter = "()";
        }
        try {
            SearchControls searchCtrl = new SearchControls();
            searchCtrl.setReturningAttributes(this.getSearchDescriptor().getReturnAttrs());
            switch (this.getSearchDescriptor().getScope()) {
                case 1: {
                    searchCtrl.setSearchScope(0);
                    break;
                }
                case 0: {
                    searchCtrl.setSearchScope(1);
                    break;
                }
                case 3: {
                    searchCtrl.setSearchScope(2);
                }
            }
            namingEnumeration = this._ctx.search(this.getSearchDescriptor().getBaseDN(), filter, searchCtrl);
        }
        catch (NameNotFoundException except) {
            namingEnumeration = null;
        }
        catch (NamingException except) {
            throw new ImportExportException(except);
        }
        try {
            JNDIProducer producer = new JNDIProducer(docHandler, false);
            producer.startDocument();
            if (namingEnumeration != null) {
                producer.produce(namingEnumeration);
            }
            if (importPolicy && this.getImportDescriptor() != null) {
                producer.produce(this.getImportDescriptor());
            }
            producer.endDocument();
        }
        catch (SAXException except) {
            throw new ImportExportException(except);
        }
    }
}

