/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.shapefile.shp;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.MultiPoint;
import java.nio.ByteBuffer;
import org.geotools.data.shapefile.shp.JTSUtilities;
import org.geotools.data.shapefile.shp.ShapeHandler;
import org.geotools.data.shapefile.shp.ShapeType;
import org.geotools.data.shapefile.shp.ShapefileException;

public class MultiPointHandler
implements ShapeHandler {
    final ShapeType shapeType;
    GeometryFactory geometryFactory;

    public MultiPointHandler(GeometryFactory gf) {
        this.shapeType = ShapeType.POINT;
        this.geometryFactory = gf;
    }

    public MultiPointHandler(ShapeType type, GeometryFactory gf) throws ShapefileException {
        if (type != ShapeType.MULTIPOINT && type != ShapeType.MULTIPOINTM && type != ShapeType.MULTIPOINTZ) {
            throw new ShapefileException("Multipointhandler constructor - expected type to be 8, 18, or 28");
        }
        this.shapeType = type;
        this.geometryFactory = gf;
    }

    public ShapeType getShapeType() {
        return this.shapeType;
    }

    public int getLength(Object geometry) {
        int length;
        MultiPoint mp = (MultiPoint)geometry;
        if (this.shapeType == ShapeType.MULTIPOINT) {
            length = mp.getNumGeometries() * 16 + 40;
        } else if (this.shapeType == ShapeType.MULTIPOINTM) {
            length = mp.getNumGeometries() * 16 + 40 + 16 + 8 * mp.getNumGeometries();
        } else if (this.shapeType == ShapeType.MULTIPOINTZ) {
            length = mp.getNumGeometries() * 16 + 40 + 16 + 8 * mp.getNumGeometries() + 16 + 8 * mp.getNumGeometries();
        } else {
            throw new IllegalStateException("Expected ShapeType of Arc, got " + this.shapeType);
        }
        return length;
    }

    private Object createNull() {
        Coordinate[] c = null;
        return this.geometryFactory.createMultiPoint(c);
    }

    public Object read(ByteBuffer buffer, ShapeType type) {
        int t;
        if (type == ShapeType.NULL) {
            return this.createNull();
        }
        buffer.position(buffer.position() + 32);
        int numpoints = buffer.getInt();
        int dimensions = this.shapeType == ShapeType.MULTIPOINTZ ? 3 : 2;
        CoordinateSequence cs = this.geometryFactory.getCoordinateSequenceFactory().create(numpoints, dimensions);
        for (t = 0; t < numpoints; ++t) {
            cs.setOrdinate(t, 0, buffer.getDouble());
            cs.setOrdinate(t, 1, buffer.getDouble());
        }
        if (this.shapeType == ShapeType.MULTIPOINTZ) {
            buffer.position(buffer.position() + 16);
            for (t = 0; t < numpoints; ++t) {
                cs.setOrdinate(t, 2, buffer.getDouble());
            }
        }
        return this.geometryFactory.createMultiPoint(cs);
    }

    public void write(ByteBuffer buffer, Object geometry) {
        Coordinate c;
        int t;
        MultiPoint mp = (MultiPoint)geometry;
        Envelope box = mp.getEnvelopeInternal();
        buffer.putDouble(box.getMinX());
        buffer.putDouble(box.getMinY());
        buffer.putDouble(box.getMaxX());
        buffer.putDouble(box.getMaxY());
        buffer.putInt(mp.getNumGeometries());
        int tt = mp.getNumGeometries();
        for (t = 0; t < tt; ++t) {
            c = mp.getGeometryN(t).getCoordinate();
            buffer.putDouble(c.x);
            buffer.putDouble(c.y);
        }
        if (this.shapeType == ShapeType.MULTIPOINTZ) {
            double[] zExtreame = JTSUtilities.zMinMax(mp.getCoordinates());
            if (Double.isNaN(zExtreame[0])) {
                buffer.putDouble(0.0);
                buffer.putDouble(0.0);
            } else {
                buffer.putDouble(zExtreame[0]);
                buffer.putDouble(zExtreame[1]);
            }
            for (int t2 = 0; t2 < mp.getNumGeometries(); ++t2) {
                c = mp.getGeometryN(t2).getCoordinate();
                double z = c.z;
                if (Double.isNaN(z)) {
                    buffer.putDouble(0.0);
                    continue;
                }
                buffer.putDouble(z);
            }
        }
        if (this.shapeType == ShapeType.MULTIPOINTM || this.shapeType == ShapeType.MULTIPOINTZ) {
            buffer.putDouble(-1.0E41);
            buffer.putDouble(-1.0E41);
            for (t = 0; t < mp.getNumGeometries(); ++t) {
                buffer.putDouble(-1.0E41);
            }
        }
    }
}

