/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.form;

import org.apache.wicket.IResourceListener;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.form.Button;
import org.apache.wicket.markup.html.image.resource.LocalizedImageResource;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.request.resource.IResource;
import org.apache.wicket.request.resource.ResourceReference;

public class ImageButton
extends Button
implements IResourceListener {
    private static final long serialVersionUID = 1L;
    private final LocalizedImageResource localizedImageResource = new LocalizedImageResource(this);

    public ImageButton(String id, ResourceReference resourceReference) {
        this(id, resourceReference, null);
    }

    public ImageButton(String id, ResourceReference resourceReference, PageParameters resourceParameters) {
        super(id);
        this.setImageResourceReference(resourceReference, resourceParameters);
    }

    public ImageButton(String id, IResource imageResource) {
        super(id);
        this.setImageResource(imageResource);
    }

    public ImageButton(String id, IModel<String> model) {
        super(id, model);
    }

    public ImageButton(String id, String string) {
        this(id, (IModel<String>)new Model<String>(string));
    }

    @Override
    public void onResourceRequested() {
        this.localizedImageResource.onResourceRequested(null);
    }

    public void setImageResource(IResource imageResource) {
        this.localizedImageResource.setResource(imageResource);
    }

    public void setImageResourceReference(ResourceReference resourceReference) {
        this.localizedImageResource.setResourceReference(resourceReference);
    }

    public void setImageResourceReference(ResourceReference resourceReference, PageParameters parameters) {
        this.localizedImageResource.setResourceReference(resourceReference, parameters);
    }

    @Override
    public ImageButton setDefaultModel(IModel<?> model) {
        this.localizedImageResource.setResourceReference(null);
        this.localizedImageResource.setResource(null);
        return (ImageButton)super.setDefaultModel((IModel)model);
    }

    protected IResource getImageResource() {
        return this.localizedImageResource.getResource();
    }

    protected ResourceReference getImageResourceReference() {
        return this.localizedImageResource.getResourceReference();
    }

    @Override
    protected final void onComponentTag(ComponentTag tag) {
        ResourceReference resourceReference;
        this.checkComponentTag(tag, "input");
        this.checkComponentTagAttribute(tag, "type", "image");
        IResource resource = this.getImageResource();
        if (resource != null) {
            this.localizedImageResource.setResource(resource);
        }
        if ((resourceReference = this.getImageResourceReference()) != null) {
            this.localizedImageResource.setResourceReference(resourceReference);
        }
        this.localizedImageResource.setSrcAttribute(tag);
        super.onComponentTag(tag);
    }

    @Override
    protected boolean getStatelessHint() {
        return this.getImageResource() == null && this.localizedImageResource.isStateless();
    }
}

