/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.spatial;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import org.geotools.filter.GeometryFilterImpl;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.spatial.Crosses;

public class CrossesImpl
extends GeometryFilterImpl
implements Crosses {
    public CrossesImpl(FilterFactory factory, Expression e1, Expression e2) {
        super(factory, e1, e2);
        this.filterType = (short)9;
    }

    public boolean evaluate(Object feature) {
        if (feature instanceof SimpleFeature && !this.validate((SimpleFeature)feature)) {
            return false;
        }
        Geometry left = this.getLeftGeometry(feature);
        Geometry right = this.getRightGeometry(feature);
        Envelope envLeft = left.getEnvelopeInternal();
        Envelope envRight = right.getEnvelopeInternal();
        if (envRight.intersects(envLeft)) {
            return left.crosses(right);
        }
        return false;
    }

    public Object accept(FilterVisitor visitor, Object extraData) {
        return visitor.visit((Crosses)this, extraData);
    }
}

