/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling.visitor;

import org.geotools.factory.CommonFactoryFinder;
import org.geotools.styling.Displacement;
import org.geotools.styling.ExternalGraphic;
import org.geotools.styling.Font;
import org.geotools.styling.Graphic;
import org.geotools.styling.Mark;
import org.geotools.styling.Stroke;
import org.geotools.styling.Symbol;
import org.geotools.styling.visitor.DuplicatingStyleVisitor;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.Multiply;

public class RescaleStyleVisitor
extends DuplicatingStyleVisitor {
    private Expression scale;

    public RescaleStyleVisitor(double scale) {
        this(CommonFactoryFinder.getFilterFactory2(null), scale);
    }

    public RescaleStyleVisitor(Expression scale) {
        this(CommonFactoryFinder.getFilterFactory2(null), scale);
    }

    public RescaleStyleVisitor(FilterFactory2 filterFactory, double scale) {
        this(filterFactory, (Expression)filterFactory.literal(scale));
    }

    public RescaleStyleVisitor(FilterFactory2 filterFactory, Expression scale) {
        super(CommonFactoryFinder.getStyleFactory(null), filterFactory);
        this.scale = scale;
    }

    protected Expression rescale(Expression expr) {
        Multiply rescale = this.ff.multiply(this.scale, expr);
        if (expr instanceof Literal && this.scale instanceof Literal) {
            double constant = (Double)rescale.evaluate(null, Double.class);
            return this.ff.literal(constant);
        }
        return rescale;
    }

    public void visit(Stroke stroke) {
        Stroke copy = this.sf.getDefaultStroke();
        copy.setColor(this.copy(stroke.getColor()));
        copy.setDashArray(this.copy(stroke.getDashArray()));
        copy.setDashOffset(this.copy(stroke.getDashOffset()));
        copy.setGraphicFill(this.copy(stroke.getGraphicFill()));
        copy.setGraphicStroke(this.copy(stroke.getGraphicStroke()));
        copy.setLineCap(this.copy(stroke.getLineCap()));
        copy.setLineJoin(this.copy(stroke.getLineJoin()));
        copy.setOpacity(this.copy(stroke.getOpacity()));
        copy.setWidth(this.rescale(stroke.getWidth()));
        this.pages.push(copy);
    }

    protected Font copy(Font font) {
        if (font == null) {
            return font;
        }
        Expression fontFamily = this.copy(font.getFontFamily());
        Expression fontStyle = this.copy(font.getFontStyle());
        Expression fontWeight = this.copy(font.getFontWeight());
        Expression fontSize = this.rescale(font.getFontSize());
        Font copy = this.sf.createFont(fontFamily, fontStyle, fontWeight, fontSize);
        return copy;
    }

    public void visit(Graphic gr) {
        Graphic copy = null;
        Displacement displacementCopy = null;
        if (gr.getDisplacement() != null) {
            gr.getDisplacement().accept(this);
            displacementCopy = (Displacement)this.pages.pop();
        }
        ExternalGraphic[] externalGraphics = gr.getExternalGraphics();
        ExternalGraphic[] externalGraphicsCopy = new ExternalGraphic[externalGraphics.length];
        int length = externalGraphics.length;
        for (int i = 0; i < length; ++i) {
            externalGraphicsCopy[i] = this.copy(externalGraphics[i]);
        }
        Mark[] marks = gr.getMarks();
        Mark[] marksCopy = new Mark[marks.length];
        length = marks.length;
        for (int i = 0; i < length; ++i) {
            marksCopy[i] = this.copy(marks[i]);
        }
        Expression opacityCopy = this.copy(gr.getOpacity());
        Expression rotationCopy = this.copy(gr.getRotation());
        Expression sizeCopy = this.rescale(gr.getSize());
        Symbol[] symbols = gr.getSymbols();
        length = symbols.length;
        Symbol[] symbolCopys = new Symbol[length];
        for (int i = 0; i < length; ++i) {
            symbolCopys[i] = this.copy(symbols[i]);
        }
        copy = this.sf.createDefaultGraphic();
        copy.setGeometryPropertyName(gr.getGeometryPropertyName());
        copy.setDisplacement(displacementCopy);
        copy.setExternalGraphics(externalGraphicsCopy);
        copy.setMarks(marksCopy);
        copy.setOpacity(opacityCopy);
        copy.setRotation(rotationCopy);
        copy.setSize(sizeCopy);
        copy.setSymbols(symbolCopys);
        this.pages.push(copy);
    }
}

