/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.svnant;

import java.io.File;
import java.io.IOException;
import org.apache.tools.ant.BuildException;
import org.tigris.subversion.svnant.SvnCommand;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.SVNClientException;

public class Propset
extends SvnCommand {
    private File path = null;
    private File file;
    private String propName = null;
    private String propValue = null;
    private boolean recurse = false;
    private ISVNClientAdapter svnClient;

    public void execute(ISVNClientAdapter iSVNClientAdapter) throws BuildException {
        this.svnClient = iSVNClientAdapter;
        this.validateAttributes();
        this.log("Svn : Propset");
        try {
            if (this.propValue != null) {
                iSVNClientAdapter.propertySet(this.path, this.propName, this.propValue, this.recurse);
            } else {
                iSVNClientAdapter.propertySet(this.path, this.propName, this.file, this.recurse);
            }
        }
        catch (SVNClientException sVNClientException) {
            throw new BuildException("Can't set property " + this.propName, (Throwable)sVNClientException);
        }
        catch (IOException iOException) {
            throw new BuildException("Can't set property " + this.propName, (Throwable)iOException);
        }
    }

    protected void validateAttributes() throws BuildException {
        if (this.path == null) {
            throw new BuildException("path attribute must be set");
        }
        if (this.propName == null) {
            throw new BuildException("name attribute must be set");
        }
        if (this.propValue == null && this.file == null) {
            throw new BuildException("value or file attribute must be set");
        }
        if (this.propValue != null && this.file != null) {
            throw new BuildException("file attribute must not be set when value attribute is set");
        }
    }

    public void setPath(File file) {
        this.path = file;
    }

    public void setName(String string) {
        this.propName = string;
    }

    public void setValue(String string) {
        this.propValue = string;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void setRecurse(boolean bl) {
        this.recurse = bl;
    }
}

