/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.svnclientadapter.commandline;

import java.io.File;
import java.util.Date;
import org.tigris.subversion.svnclientadapter.ISVNStatus;
import org.tigris.subversion.svnclientadapter.SVNNodeKind;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNStatusKind;
import org.tigris.subversion.svnclientadapter.SVNUrl;
import org.tigris.subversion.svnclientadapter.commandline.CmdLineInfoPart;
import org.tigris.subversion.svnclientadapter.commandline.CmdLineStatusPart;

class CmdLineStatusComposite
implements ISVNStatus {
    private CmdLineStatusPart statusPart;
    private CmdLineInfoPart infoPart;

    CmdLineStatusComposite(CmdLineStatusPart cmdLineStatusPart, CmdLineInfoPart cmdLineInfoPart) {
        this.statusPart = cmdLineStatusPart;
        this.infoPart = cmdLineInfoPart;
    }

    public SVNStatusKind getTextStatus() {
        return this.statusPart.getTextStatus();
    }

    public SVNStatusKind getPropStatus() {
        return this.statusPart.getPropStatus();
    }

    public SVNUrl getUrlCopiedFrom() {
        return this.infoPart.getCopyUrl();
    }

    public Date getLastChangedDate() {
        return this.infoPart.getLastChangedDate();
    }

    public SVNRevision.Number getLastChangedRevision() {
        return this.infoPart.getLastChangedRevision();
    }

    public String getLastCommitAuthor() {
        return this.infoPart.getLastCommitAuthor();
    }

    public SVNNodeKind getNodeKind() {
        return this.infoPart.getNodeKind();
    }

    public String getPath() {
        return this.infoPart != null ? this.infoPart.getPath() : this.statusPart.getPath();
    }

    public File getFile() {
        return this.statusPart.getFile();
    }

    public SVNRevision.Number getRevision() {
        return this.infoPart.getRevision();
    }

    public SVNUrl getUrl() {
        return this.infoPart.getUrl();
    }

    public SVNStatusKind getRepositoryTextStatus() {
        return this.statusPart.getRepositoryTextStatus();
    }

    public SVNStatusKind getRepositoryPropStatus() {
        return this.statusPart.getRepositoryPropStatus();
    }

    public File getConflictNew() {
        return null;
    }

    public File getConflictOld() {
        return null;
    }

    public File getConflictWorking() {
        return null;
    }

    public boolean isCopied() {
        return this.statusPart.isCopied();
    }

    public Date getLockCreationDate() {
        return this.infoPart.getLockCreationDate();
    }

    public String getLockOwner() {
        return this.infoPart.getLockOwner();
    }

    public String getLockComment() {
        return this.infoPart.getLockComment();
    }
}

