/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.datatypes;

import com.hp.hpl.jena.datatypes.BaseDatatype;
import com.hp.hpl.jena.datatypes.DatatypeFormatException;
import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.datatypes.xsd.impl.RDFLangString;
import com.hp.hpl.jena.datatypes.xsd.impl.XMLLiteralType;
import com.hp.hpl.jena.shared.impl.JenaParameters;
import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;

public class TypeMapper {
    private static TypeMapper theTypeMap;
    private final HashMap<String, RDFDatatype> uriToDT = new HashMap();
    private final HashMap<Class<?>, RDFDatatype> classToDT = new HashMap();

    public static TypeMapper getInstance() {
        return theTypeMap;
    }

    public static void setInstance(TypeMapper typeMapper) {
        theTypeMap = typeMapper;
    }

    public static void reset() {
        theTypeMap = new TypeMapper();
        theTypeMap.registerDatatype(XMLLiteralType.theXMLLiteralType);
        theTypeMap.registerDatatype(RDFLangString.rdfLangString);
        XSDDatatype.loadXSDSimpleTypes(theTypeMap);
        TypeMapper.theTypeMap.classToDT.put(Float.TYPE, TypeMapper.theTypeMap.classToDT.get(Float.class));
        TypeMapper.theTypeMap.classToDT.put(Double.TYPE, TypeMapper.theTypeMap.classToDT.get(Double.class));
        TypeMapper.theTypeMap.classToDT.put(Integer.TYPE, TypeMapper.theTypeMap.classToDT.get(Integer.class));
        TypeMapper.theTypeMap.classToDT.put(Long.TYPE, TypeMapper.theTypeMap.classToDT.get(Long.class));
        TypeMapper.theTypeMap.classToDT.put(Short.TYPE, TypeMapper.theTypeMap.classToDT.get(Short.class));
        TypeMapper.theTypeMap.classToDT.put(Byte.TYPE, TypeMapper.theTypeMap.classToDT.get(Byte.class));
        TypeMapper.theTypeMap.classToDT.put(Boolean.TYPE, TypeMapper.theTypeMap.classToDT.get(Boolean.class));
        TypeMapper.theTypeMap.classToDT.put(Character.TYPE, TypeMapper.theTypeMap.classToDT.get(String.class));
        TypeMapper.theTypeMap.classToDT.put(Character.class, TypeMapper.theTypeMap.classToDT.get(String.class));
        TypeMapper.theTypeMap.classToDT.put(URL.class, TypeMapper.theTypeMap.classToDT.get(URI.class));
    }

    public RDFDatatype getSafeTypeByName(String uri) {
        RDFDatatype dtype = this.uriToDT.get(uri);
        if (dtype == null) {
            if (uri == null) {
                return null;
            }
            if (JenaParameters.enableSilentAcceptanceOfUnknownDatatypes) {
                dtype = new BaseDatatype(uri);
                this.registerDatatype(dtype);
            } else {
                throw new DatatypeFormatException("Attempted to created typed literal using an unknown datatype - " + uri);
            }
        }
        return dtype;
    }

    public RDFDatatype getTypeByName(String uri) {
        return this.uriToDT.get(uri);
    }

    public RDFDatatype getTypeByValue(Object value) {
        return this.classToDT.get(value.getClass());
    }

    public Iterator<RDFDatatype> listTypes() {
        return this.uriToDT.values().iterator();
    }

    public RDFDatatype getTypeByClass(Class<?> clazz) {
        return this.classToDT.get(clazz);
    }

    public void registerDatatype(RDFDatatype type) {
        this.uriToDT.put(type.getURI(), type);
        Class<?> jc = type.getJavaClass();
        if (jc != null) {
            this.classToDT.put(jc, type);
        }
    }

    public static void main(String[] args) {
        Iterator<RDFDatatype> iter = theTypeMap.listTypes();
        while (iter.hasNext()) {
            RDFDatatype dt = iter.next();
            System.out.println(" - " + dt);
        }
    }

    static {
        TypeMapper.reset();
    }
}

