/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.model.impl;

import com.hp.hpl.jena.graph.FrontsTriple;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.RSIterator;
import com.hp.hpl.jena.rdf.model.ReifiedStatement;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.impl.ModelCom;
import com.hp.hpl.jena.rdf.model.impl.RSIteratorImpl;
import com.hp.hpl.jena.rdf.model.impl.ReifiedStatementImpl;
import com.hp.hpl.jena.rdf.model.impl.ReifierStd;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.Map1;
import java.util.Iterator;

public class ModelReifier {
    private ModelCom model;
    private static boolean copyingReifications = false;
    protected final Map1<Node, ReifiedStatement> mapToRS = new Map1<Node, ReifiedStatement>(){

        @Override
        public ReifiedStatement map1(Node node) {
            return ModelReifier.this.getRS(node);
        }
    };

    public ModelReifier(ModelCom model) {
        this.model = model;
    }

    public ReifiedStatement createReifiedStatement(Statement s) {
        return this.createReifiedStatement(null, s);
    }

    public ReifiedStatement createReifiedStatement(String uri, Statement s) {
        return ReifiedStatementImpl.create(this.model, uri, s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resource getAnyReifiedStatement(Statement s) {
        RSIterator it = this.listReifiedStatements(s);
        if (it.hasNext()) {
            try {
                ReifiedStatement reifiedStatement = it.nextRS();
                return reifiedStatement;
            }
            finally {
                it.close();
            }
        }
        return this.createReifiedStatement(s);
    }

    public boolean isReified(FrontsTriple s) {
        return ReifierStd.hasTriple(this.model.getGraph(), s.asTriple());
    }

    public void removeAllReifications(FrontsTriple s) {
        ReifierStd.remove(this.model.getGraph(), s.asTriple());
    }

    public void removeReification(ReifiedStatement rs) {
        ReifierStd.remove(this.model.getGraph(), rs.asNode(), rs.getStatement().asTriple());
    }

    public RSIterator listReifiedStatements() {
        return new RSIteratorImpl((Iterator<ReifiedStatement>)this.findReifiedStatements());
    }

    public RSIterator listReifiedStatements(FrontsTriple s) {
        return new RSIteratorImpl((Iterator<ReifiedStatement>)this.findReifiedStatements(s.asTriple()));
    }

    public void noteIfReified(RDFNode s, RDFNode p, RDFNode o) {
        if (copyingReifications) {
            this.noteIfReified(s);
            this.noteIfReified(p);
            this.noteIfReified(o);
        }
    }

    private void noteIfReified(RDFNode n) {
        if (n.canAs(ReifiedStatement.class)) {
            ReifiedStatement rs = n.as(ReifiedStatement.class);
            this.createReifiedStatement(rs.getURI(), rs.getStatement());
        }
    }

    private ExtendedIterator<ReifiedStatement> findReifiedStatements() {
        return ReifierStd.allNodes(this.model.getGraph()).mapWith(this.mapToRS);
    }

    private ExtendedIterator<ReifiedStatement> findReifiedStatements(Triple t) {
        return ReifierStd.allNodes(this.model.getGraph(), t).mapWith(this.mapToRS);
    }

    private ReifiedStatement getRS(Node n) {
        return ReifiedStatementImpl.createExistingReifiedStatement(this.model, n);
    }
}

