/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.metadata.iso.spatial;

import java.util.List;
import org.geotools.metadata.iso.spatial.SpatialRepresentationImpl;
import org.opengis.metadata.spatial.CellGeometry;
import org.opengis.metadata.spatial.Dimension;
import org.opengis.metadata.spatial.GridSpatialRepresentation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GridSpatialRepresentationImpl
extends SpatialRepresentationImpl
implements GridSpatialRepresentation {
    private static final long serialVersionUID = -8400572307442433979L;
    private Integer numberOfDimensions;
    private List<Dimension> axisDimensionsProperties;
    private CellGeometry cellGeometry;
    private boolean transformationParameterAvailable;

    public GridSpatialRepresentationImpl() {
    }

    public GridSpatialRepresentationImpl(GridSpatialRepresentation source) {
        super(source);
    }

    public GridSpatialRepresentationImpl(int numberOfDimensions, List<? extends Dimension> axisDimensionsProperties, CellGeometry cellGeometry, boolean transformationParameterAvailable) {
        this.setNumberOfDimensions(numberOfDimensions);
        this.setAxisDimensionsProperties(axisDimensionsProperties);
        this.setCellGeometry(cellGeometry);
        this.setTransformationParameterAvailable(transformationParameterAvailable);
    }

    @Override
    public Integer getNumberOfDimensions() {
        return this.numberOfDimensions;
    }

    public synchronized void setNumberOfDimensions(Integer newValue) {
        this.checkWritePermission();
        this.numberOfDimensions = newValue;
    }

    public synchronized List<Dimension> getAxisDimensionsProperties() {
        this.axisDimensionsProperties = this.nonNullList(this.axisDimensionsProperties, Dimension.class);
        return this.axisDimensionsProperties;
    }

    public synchronized void setAxisDimensionsProperties(List<? extends Dimension> newValues) {
        this.checkWritePermission();
        this.axisDimensionsProperties = (List)this.copyCollection(newValues, this.axisDimensionsProperties, Dimension.class);
    }

    @Override
    public CellGeometry getCellGeometry() {
        return this.cellGeometry;
    }

    public synchronized void setCellGeometry(CellGeometry newValue) {
        this.checkWritePermission();
        this.cellGeometry = newValue;
    }

    @Override
    public boolean isTransformationParameterAvailable() {
        return this.transformationParameterAvailable;
    }

    public synchronized void setTransformationParameterAvailable(boolean newValue) {
        this.checkWritePermission();
        this.transformationParameterAvailable = newValue;
    }
}

