/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.utilities;

import HTTPClient.FilenameMangler;
import HTTPClient.NVPair;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLConnection;
import java.util.BitSet;

public class MultipartForm {
    private static BitSet BoundChar;
    private static final String ContDisp = "\r\nContent-Disposition: form-data; name=\"";
    private static final String FileName = "\"; filename=\"";
    private static final String ContType = "\r\nContent-Type: ";
    private static final String Boundary = "\r\n----------ieoau._._+2_8_8.3-dskdfJwSJKl234324jfLdsjfdAuaoei-----";
    private static NVPair[] dummy;
    private byte[] boundary = "\r\n----------ieoau._._+2_8_8.3-dskdfJwSJKl234324jfLdsjfdAuaoei-----".getBytes("8859_1");
    private byte[] cont_disp = "\r\nContent-Disposition: form-data; name=\"".getBytes("8859_1");
    private byte[] cont_type = "\r\nContent-Type: ".getBytes("8859_1");
    private byte[] filename = "\"; filename=\"".getBytes("8859_1");
    private long encodedLength;
    private NVPair[] opts;
    private NVPair[] files;
    private InputStream fileData;
    private int fileSize;
    private FilenameMangler mangler;
    private NVPair content_header = null;

    public MultipartForm(NVPair[] opts, NVPair[] files, FilenameMangler mangler, InputStream fileData, int fileSize) throws IOException {
        this.opts = opts;
        this.files = files;
        this.mangler = mangler;
        this.fileData = fileData;
        this.fileSize = fileSize;
        this.encodedLength = this.calculateLength();
    }

    public MultipartForm(NVPair[] opts, NVPair[] files, FilenameMangler mangler) throws IOException {
        this(opts, files, mangler, null, 0);
    }

    public MultipartForm(NVPair[] opts, NVPair[] files) throws IOException {
        this(opts, files, null, null, 0);
    }

    public MultipartForm(NVPair[] opts, NVPair[] files, InputStream fileData, int fileSize) throws IOException {
        this(opts, files, null, fileData, fileSize);
    }

    private long calculateLength() throws IOException {
        int idx;
        int len = 0;
        int hdr_len = this.boundary.length + this.cont_disp.length + 1 + 2 + 2;
        if (this.opts == null) {
            this.opts = dummy;
        }
        if (this.files == null) {
            this.files = dummy;
        }
        for (idx = 0; idx < this.opts.length; ++idx) {
            if (this.opts[idx] == null) continue;
            len += hdr_len + this.opts[idx].getName().length() + this.opts[idx].getValue().length();
        }
        for (idx = 0; idx < this.files.length; ++idx) {
            if (this.files[idx] == null) continue;
            if (this.fileData == null) {
                File file = new File(this.files[idx].getValue());
                String fname = file.getName();
                if (this.mangler != null) {
                    fname = this.mangler.mangleFilename(fname, this.files[idx].getName());
                }
                if (fname == null) continue;
                len += hdr_len + this.files[idx].getName().length() + this.filename.length;
                len = (int)((long)len + ((long)fname.length() + file.length()));
                String ct = CT.getContentType(file.getName());
                if (ct == null) continue;
                len += this.cont_type.length + ct.length();
                continue;
            }
            String fname = this.files[idx].getValue();
            if (this.mangler != null) {
                fname = this.mangler.mangleFilename(fname, this.files[idx].getName());
            }
            if (fname == null) continue;
            len += hdr_len + this.files[idx].getName().length() + this.filename.length;
            len += fname.length() + this.fileSize;
            String ct = CT.getContentType(this.files[idx].getValue());
            if (ct == null) continue;
            len += this.cont_type.length + ct.length();
        }
        if (len == 0) {
            this.content_header = new NVPair("Content-Type", "application/octet-stream");
            return len;
        }
        this.content_header = new NVPair("Content-Type", "multipart/form-data; boundary=" + new String(this.boundary, 4, this.boundary.length - 4, "8859_1"));
        len -= 2;
        return len += this.boundary.length + 2 + 2;
    }

    public void writeEncodedMultipartForm(OutputStream out) throws IOException {
        this.writeEncodedMultipartForm(out, 4096);
    }

    public void writeEncodedMultipartForm(OutputStream out, int bufferSize) throws IOException {
        int pos = 0;
        int dataSent = 0;
        int new_c = 0x30303030;
        if (new_c != 0x7A7A7A7A) {
            int idx;
            pos = 0;
            while (!BoundChar.get(new_c & 0xFF)) {
                ++new_c;
            }
            while (!BoundChar.get(new_c >> 8 & 0xFF)) {
                new_c += 256;
            }
            while (!BoundChar.get(new_c >> 16 & 0xFF)) {
                new_c += 65536;
            }
            while (!BoundChar.get(new_c >> 24 & 0xFF)) {
                new_c += 0x1000000;
            }
            int off = 2;
            for (idx = 0; idx < this.opts.length; ++idx) {
                if (this.opts[idx] == null) continue;
                out.write(this.boundary, off, this.boundary.length - off);
                off = 0;
                int start = pos += this.boundary.length - off;
                out.write(this.cont_disp, 0, this.cont_disp.length);
                pos += this.cont_disp.length;
                int nlen = this.opts[idx].getName().length();
                out.write(this.opts[idx].getName().getBytes("8859_1"), 0, nlen);
                pos += nlen;
                out.write(34);
                ++pos;
                out.write(13);
                ++pos;
                out.write(10);
                ++pos;
                out.write(13);
                ++pos;
                out.write(10);
                ++pos;
                out.flush();
                int vlen = this.opts[idx].getValue().length();
                out.write(this.opts[idx].getValue().getBytes("8859_1"), 0, vlen);
                out.flush();
                pos += vlen;
            }
            for (idx = 0; idx < this.files.length; ++idx) {
                if (this.files[idx] == null) continue;
                if (this.fileData == null) {
                    File file = new File(this.files[idx].getValue());
                    String fname = file.getName();
                    if (this.mangler != null) {
                        fname = this.mangler.mangleFilename(fname, this.files[idx].getName());
                    }
                    if (fname == null) continue;
                    out.write(this.boundary, off, this.boundary.length - off);
                    off = 0;
                    int start = pos += this.boundary.length - off;
                    out.write(this.cont_disp, 0, this.cont_disp.length);
                    pos += this.cont_disp.length;
                    int nlen = this.files[idx].getName().length();
                    out.write(this.files[idx].getName().getBytes("8859_1"), 0, nlen);
                    pos += nlen;
                    out.write(this.filename, 0, this.filename.length);
                    pos += this.filename.length;
                    nlen = fname.length();
                    out.write(fname.getBytes("8859_1"), 0, nlen);
                    pos += nlen;
                    out.write(34);
                    ++pos;
                    String ct = CT.getContentType(file.getName());
                    if (ct != null) {
                        out.write(this.cont_type, 0, this.cont_type.length);
                        pos += this.cont_type.length;
                        out.write(ct.getBytes("8859_1"), 0, ct.length());
                        pos += ct.length();
                    }
                    out.write(13);
                    ++pos;
                    out.write(10);
                    ++pos;
                    out.write(13);
                    ++pos;
                    out.write(10);
                    ++pos;
                    out.flush();
                    FileInputStream fs = new FileInputStream(file);
                    byte[] buf = new byte[bufferSize];
                    int cnt = 0;
                    while (cnt != -1) {
                        cnt = fs.read(buf);
                        if (cnt == -1) continue;
                        out.write(buf, 0, cnt);
                        out.flush();
                        pos += cnt;
                    }
                    fs.close();
                    continue;
                }
                String fname = this.files[idx].getValue();
                if (this.mangler != null) {
                    fname = this.mangler.mangleFilename(fname, this.files[idx].getName());
                }
                if (fname == null) continue;
                out.write(this.boundary, off, this.boundary.length - off);
                pos += this.boundary.length - off;
                off = 0;
                out.write(this.cont_disp, 0, this.cont_disp.length);
                pos += this.cont_disp.length;
                int nlen = this.files[idx].getName().length();
                out.write(this.files[idx].getName().getBytes("8859_1"), 0, nlen);
                pos += nlen;
                out.write(this.filename, 0, this.filename.length);
                pos += this.filename.length;
                nlen = fname.length();
                out.write(fname.getBytes("8859_1"), 0, nlen);
                pos += nlen;
                out.write(34);
                ++pos;
                String ct = CT.getContentType(this.files[idx].getValue());
                if (ct != null) {
                    out.write(this.cont_type, 0, this.cont_type.length);
                    pos += this.cont_type.length;
                    out.write(ct.getBytes("8859_1"), 0, ct.length());
                    pos += ct.length();
                }
                out.write(13);
                ++pos;
                out.write(10);
                ++pos;
                out.write(13);
                ++pos;
                out.write(10);
                ++pos;
                out.flush();
                byte[] buf = new byte[bufferSize];
                int cnt = 0;
                dataSent = 0;
                while (cnt != -1) {
                    cnt = this.fileData.read(buf);
                    if (cnt != -1) {
                        out.write(buf, 0, cnt);
                        out.flush();
                        pos += cnt;
                        dataSent += cnt;
                    }
                    if (dataSent <= this.fileSize) continue;
                }
                this.fileData.close();
            }
        }
        out.write(this.boundary, 0, this.boundary.length);
        pos += this.boundary.length;
        out.write(45);
        ++pos;
        out.write(45);
        ++pos;
        out.write(13);
        ++pos;
        out.write(10);
        ++pos;
        out.flush();
        out.close();
        if (dataSent != this.fileSize) {
            throw new Error("InputStream size not equal to fileSize specified");
        }
        if ((long)pos != this.getLength()) {
            throw new Error("Calculated " + this.getLength() + " bytes but wrote " + pos + " bytes!");
        }
        this.content_header = new NVPair("Content-Type", "multipart/form-data; boundary=" + new String(this.boundary, 4, this.boundary.length - 4, "8859_1"));
    }

    public long getLength() {
        return this.encodedLength;
    }

    public String getContentType() {
        return this.content_header.getValue();
    }

    static {
        int ch;
        dummy = new NVPair[0];
        BoundChar = new BitSet(256);
        for (ch = 48; ch <= 57; ++ch) {
            BoundChar.set(ch);
        }
        for (ch = 65; ch <= 90; ++ch) {
            BoundChar.set(ch);
        }
        for (ch = 97; ch <= 122; ++ch) {
            BoundChar.set(ch);
        }
        BoundChar.set(43);
        BoundChar.set(95);
        BoundChar.set(45);
        BoundChar.set(46);
    }

    private static class CT
    extends URLConnection {
        protected static final String getContentType(String fname) {
            return CT.guessContentTypeFromName(fname);
        }

        private CT() {
            super(null);
        }

        public void connect() {
        }
    }
}

