/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.utilities;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class OptionsMetadata {
    private HashMap optionsMetadata = new HashMap();

    public OptionsMetadata(Reader reader) {
        this.load(reader);
    }

    public synchronized void setMetadata(String key, String label, String group, int index, String description) {
        Metadata md = (Metadata)this.optionsMetadata.get(key);
        if (md == null) {
            md = new Metadata(key, label, group, index, description);
        } else {
            md.setLabel(key);
            md.setLabel(label);
            md.setGroup(group);
            md.setIndex(index);
            md.setDescription(description);
        }
        this.optionsMetadata.put(key, md);
    }

    public synchronized String getOptionLabel(String key) {
        Metadata md = (Metadata)this.optionsMetadata.get(key);
        return md.getLabel();
    }

    public synchronized String getOptionGroup(String key) {
        Metadata md = (Metadata)this.optionsMetadata.get(key);
        return md.getGroup();
    }

    public synchronized int getOptionIndex(String key) {
        Metadata md = (Metadata)this.optionsMetadata.get(key);
        return md.getIndex();
    }

    public synchronized String getOptionDescription(String key) {
        Metadata md = (Metadata)this.optionsMetadata.get(key);
        return md.getDescription();
    }

    public synchronized Set getGroups() {
        HashSet<String> groups = new HashSet<String>();
        for (String key : this.optionsMetadata.keySet()) {
            String group = this.getOptionGroup(key);
            groups.add(group);
        }
        return groups;
    }

    public synchronized SortedMap getKeysInGroup(String target) {
        TreeMap<Integer, String> options = new TreeMap<Integer, String>();
        for (String key : this.optionsMetadata.keySet()) {
            String group = this.getOptionGroup(key);
            int index = this.getOptionIndex(key);
            if (!group.equals(target)) continue;
            options.put(new Integer(index), key);
        }
        return options;
    }

    public synchronized void load(Reader reader) {
        BufferedReader isr = new BufferedReader(reader);
        try {
            String line = "";
            while (line != null) {
                line = isr.readLine();
                if (line == null) continue;
                this.parseLine(line);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public synchronized void store(Writer writer) {
        BufferedWriter osr = new BufferedWriter(writer);
        for (String key : this.optionsMetadata.keySet()) {
            Metadata md = (Metadata)this.optionsMetadata.get(key);
            StringBuffer line = new StringBuffer();
            line.append("# ");
            line.append(md.getKey() + ",");
            line.append(md.getLabel() + ",");
            line.append(md.getGroup() + ",");
            line.append(md.getIndex() + ",");
            line.append(md.getDescription());
            try {
                osr.write(line.toString());
                osr.newLine();
                osr.flush();
            }
            catch (IOException ioe) {
                System.out.println(ioe.getMessage());
            }
        }
    }

    private void parseLine(String line) {
        Pattern p = Pattern.compile("# (.*),(.*),(.*),(.*),(.*)");
        Matcher m = p.matcher(line);
        if (m.matches()) {
            String key = m.group(1);
            String label = m.group(2);
            String group = m.group(3);
            String index = m.group(4);
            int indexNum = new Integer(index);
            String description = m.group(5);
            this.setMetadata(key, label, group, indexNum, description);
        } else {
            System.out.println("No match. This is not a valid metadata line.");
        }
    }

    private class Metadata {
        private String key;
        private String label;
        private String group;
        private int index;
        private String description;

        public Metadata(String key, String label, String group, int index, String description) {
            this.key = key;
            this.label = label;
            this.group = group;
            this.index = index;
            this.description = description;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getGroup() {
            return this.group;
        }

        public void setGroup(String group) {
            this.group = group;
        }

        public int getIndex() {
            return this.index;
        }

        public void setIndex(int index) {
            this.index = index;
        }

        public String getLabel() {
            return this.label;
        }

        public void setLabel(String label) {
            this.label = label;
        }

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }
    }
}

