/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lsid.client.testing;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.ibm.lsid.LSID;
import com.ibm.lsid.MalformedLSIDException;
import com.ibm.lsid.client.LSIDResolver;
import com.ibm.lsid.client.async.utils.WorkPool;
import com.ibm.lsid.wsdl.LSIDMetadataPort;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;

class Launcher {
    private static Map hitlist;
    private static int hits;
    private static int missed;
    private static Map misslist;
    protected static WorkPool pool;
    private LSID lsid;
    private static PrintWriter fout;
    private static PrintWriter ferr;
    private static PrintWriter fmiss;

    public Launcher(LSID lsid) {
        hitlist = Collections.synchronizedMap(new TreeMap());
        misslist = Collections.synchronizedMap(new TreeMap());
        pool = new WorkPool(10);
        this.lsid = lsid;
        try {
            fout = new PrintWriter(new BufferedWriter(new FileWriter("c:\\lsid\\temp\\crawler.txt", true)));
            ferr = new PrintWriter(new BufferedWriter(new FileWriter("c:\\lsid\\temp\\crawler-err.txt", true)));
            fmiss = new PrintWriter(new BufferedWriter(new FileWriter("c:\\lsid\\temp\\crawler-missed.txt", true)));
        }
        catch (IOException e) {
            System.err.println("could not open output file");
            System.exit(0);
        }
    }

    public void beginTest() {
        Resolver resolver = new Resolver(this.lsid, null);
        hitlist.put(this.lsid.toString(), "stress");
        pool.addJob(resolver);
    }

    public synchronized void writeError(String m) {
        ferr.println(m);
        ferr.flush();
    }

    public synchronized void writeStatus(String m) {
        fout.println(m);
        fout.flush();
        System.err.println("[" + hits + "]completed [" + missed + "]missed : hit    :" + m);
    }

    public synchronized void writeMiss(String m) {
        fmiss.println(m);
        fmiss.flush();
        System.err.println("[" + hits + "]completed [" + missed + "]missed : missed :" + m);
    }

    private class Resolver
    implements Runnable {
        private LSID parentLSID;
        private LSID lsid;
        private Launcher parent;

        public Resolver(LSID lsid, LSID parentLSID) {
            this.lsid = lsid;
            this.parentLSID = parentLSID;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private Model getModel(LSID search) {
            LSIDMetadataPort port;
            LSIDResolver r;
            InputStream stream;
            Model m;
            block10: {
                m = null;
                stream = null;
                r = new LSIDResolver(this.lsid);
                port = r.getWSDLWrapper().getMetadataPortForProtocol("http");
                if (port != null) break block10;
                Model model = null;
                Object var8_8 = null;
                if (stream == null) return model;
                try {
                    stream.close();
                    return model;
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
                return model;
            }
            stream = r.getMetadata(port).getMetadata();
            m = ModelFactory.createDefaultModel();
            m.read(stream, "http://stress.org/");
            stream.close();
            Object var8_9 = null;
            if (stream == null) return m;
            try {
                stream.close();
                return m;
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
            return m;
            {
                catch (Exception e) {
                    e.printStackTrace();
                    Object var8_10 = null;
                    if (stream == null) return m;
                    try {
                        stream.close();
                        return m;
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                    return m;
                }
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                if (stream == null) throw throwable;
                try {
                    stream.close();
                    throw throwable;
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
                throw throwable;
            }
        }

        public void run() {
            Model m = this.getModel(this.lsid);
            if (m == null && !misslist.containsKey(this.lsid.toString()) && (m = this.getModel(this.lsid)) == null) {
                if (this.parentLSID != null) {
                    Launcher.this.writeMiss("could not download metadata from parent " + this.parentLSID.toString() + " for: " + this.lsid.toString());
                } else {
                    Launcher.this.writeMiss("could not download metadata from parent Unknown for: " + this.lsid.toString());
                }
                misslist.put(this.lsid.toString(), "stress");
                missed++;
                return;
            }
            Launcher.this.writeStatus("retrieved metadata for: " + this.lsid.toString());
            hits++;
            StmtIterator stms = m.listStatements(null, null, (RDFNode)null);
            while (stms.hasNext()) {
                String objStr;
                String predStr;
                Statement s = stms.nextStatement();
                String subjStr = s.getSubject().toString();
                if (subjStr.startsWith("urn") && !hitlist.containsKey(subjStr)) {
                    hitlist.put(subjStr, "stress");
                    if (s.getSubject() instanceof Resource) {
                        try {
                            LSID sublsid = new LSID(subjStr);
                            Resolver resolver = new Resolver(sublsid, this.lsid);
                            pool.addJob(resolver);
                        }
                        catch (MalformedLSIDException e) {
                            Launcher.this.writeError("invalid lsid : " + subjStr);
                        }
                    }
                }
                if ((predStr = s.getPredicate().toString()).startsWith("urn") && !hitlist.containsKey(predStr)) {
                    hitlist.put(predStr, "stress");
                    if (s.getPredicate() instanceof Resource) {
                        try {
                            LSID predlsid = new LSID(predStr);
                            Resolver resolver = new Resolver(predlsid, this.lsid);
                            pool.addJob(resolver);
                        }
                        catch (MalformedLSIDException e) {
                            Launcher.this.writeError("invalid lsid : " + predStr);
                        }
                    }
                }
                if (!(objStr = s.getObject().toString()).startsWith("urn") || hitlist.containsKey(objStr)) continue;
                hitlist.put(objStr, "stress");
                if (!(s.getObject() instanceof Resource)) continue;
                try {
                    LSID objlsid = new LSID(objStr);
                    Resolver resolver = new Resolver(objlsid, this.lsid);
                    pool.addJob(resolver);
                }
                catch (MalformedLSIDException e) {
                    Launcher.this.writeError("invalid lsid : " + objStr);
                }
            }
        }
    }
}

