/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.xbill.DNS.CNAMERecord;
import org.xbill.DNS.Cache;
import org.xbill.DNS.DNAMERecord;
import org.xbill.DNS.Header;
import org.xbill.DNS.Message;
import org.xbill.DNS.Name;
import org.xbill.DNS.NameTooLongException;
import org.xbill.DNS.OPTRecord;
import org.xbill.DNS.RRset;
import org.xbill.DNS.Record;
import org.xbill.DNS.SetResponse;
import org.xbill.DNS.TSIG;
import org.xbill.DNS.TSIGRecord;
import org.xbill.DNS.Type;
import org.xbill.DNS.Zone;
import org.xbill.DNS.utils.base64;

public class jnamed {
    static final int FLAG_DNSSECOK = 1;
    static final int FLAG_SIGONLY = 2;
    Map caches;
    Map znames;
    Map TSIGs;

    public jnamed(String conffile) throws IOException {
        FileInputStream fs;
        ArrayList<Short> ports = new ArrayList<Short>();
        ArrayList<InetAddress> addresses = new ArrayList<InetAddress>();
        try {
            fs = new FileInputStream(conffile);
        }
        catch (Exception e) {
            System.out.println("Cannot open " + conffile);
            return;
        }
        this.caches = new HashMap();
        this.znames = new HashMap();
        this.TSIGs = new HashMap();
        BufferedReader br = new BufferedReader(new InputStreamReader(fs));
        String line = null;
        while ((line = br.readLine()) != null) {
            StringTokenizer st = new StringTokenizer(line);
            if (!st.hasMoreTokens()) continue;
            String keyword = st.nextToken();
            if (!st.hasMoreTokens()) {
                System.out.println("Invalid line: " + line);
                continue;
            }
            if (keyword.charAt(0) == '#') continue;
            if (keyword.equals("primary")) {
                this.addPrimaryZone(st.nextToken(), st.nextToken());
                continue;
            }
            if (keyword.equals("secondary")) {
                this.addSecondaryZone(st.nextToken(), st.nextToken());
                continue;
            }
            if (keyword.equals("cache")) {
                Cache cache = new Cache(st.nextToken());
                this.caches.put(new Short(1), cache);
                continue;
            }
            if (keyword.equals("key")) {
                this.addTSIG(st.nextToken(), st.nextToken());
                continue;
            }
            if (keyword.equals("port")) {
                ports.add(Short.valueOf(st.nextToken()));
                continue;
            }
            if (keyword.equals("address")) {
                String addr = st.nextToken();
                addresses.add(InetAddress.getByName(addr));
                continue;
            }
            System.out.println("ignoring invalid keyword: " + keyword);
        }
        if (ports.size() == 0) {
            ports.add(new Short(53));
        }
        if (addresses.size() == 0) {
            addresses.add(null);
        }
        Iterator iaddr = addresses.iterator();
        while (iaddr.hasNext()) {
            InetAddress addr = (InetAddress)iaddr.next();
            Iterator iport = ports.iterator();
            while (iport.hasNext()) {
                short port = (Short)iport.next();
                this.addUDP(addr, port);
                this.addTCP(addr, port);
                String addrString = addr == null ? "0.0.0.0" : addr.getHostAddress();
                System.out.println("jnamed: listening on " + addrString + "#" + port);
            }
        }
        System.out.println("jnamed: running");
    }

    public void addPrimaryZone(String zname, String zonefile) throws IOException {
        Name origin = null;
        Cache cache = this.getCache((short)1);
        if (zname != null) {
            origin = Name.fromString(zname, Name.root);
        }
        Zone newzone = new Zone(zonefile, cache, origin);
        this.znames.put(newzone.getOrigin(), newzone);
    }

    public void addSecondaryZone(String zone, String remote) throws IOException {
        Cache cache = this.getCache((short)1);
        Name zname = Name.fromString(zone, Name.root);
        Zone newzone = new Zone(zname, 1, remote, cache);
        this.znames.put(zname, newzone);
    }

    public void addTSIG(String namestr, String key) throws IOException {
        Name name = Name.fromString(namestr, Name.root);
        this.TSIGs.put(name, base64.fromString(key));
    }

    public Cache getCache(short dclass) {
        Cache c = (Cache)this.caches.get(new Short(dclass));
        if (c == null) {
            c = new Cache(dclass);
            this.caches.put(new Short(dclass), c);
        }
        return c;
    }

    public Zone findBestZone(Name name) {
        Zone foundzone = null;
        foundzone = (Zone)this.znames.get(name);
        if (foundzone != null) {
            return foundzone;
        }
        int labels = name.labels();
        int i = 1;
        while (i < labels) {
            Name tname = new Name(name, i);
            foundzone = (Zone)this.znames.get(tname);
            if (foundzone != null) {
                return foundzone;
            }
            ++i;
        }
        return null;
    }

    public RRset findExactMatch(Name name, short type, short dclass, boolean glue) {
        Zone zone = this.findBestZone(name);
        if (zone != null) {
            return zone.findExactMatch(name, type);
        }
        Cache cache = this.getCache(dclass);
        RRset[] rrsets = glue ? cache.findAnyRecords(name, type) : cache.findRecords(name, type);
        if (rrsets == null) {
            return null;
        }
        return rrsets[0];
    }

    void addRRset(Name name, Message response, RRset rrset, byte section, int flags) {
        Record r;
        Iterator it;
        byte s = 1;
        while (s <= section) {
            if (response.findRRset(name, rrset.getType(), s)) {
                return;
            }
            s = (byte)(s + 1);
        }
        if ((flags & 2) == 0) {
            it = rrset.rrs();
            while (it.hasNext()) {
                r = (Record)it.next();
                if (r.getName().isWild() && !name.isWild()) {
                    r = r.withName(name);
                }
                response.addRecord(r, section);
            }
        }
        if ((flags & 3) != 0) {
            it = rrset.sigs();
            while (it.hasNext()) {
                r = (Record)it.next();
                if (r.getName().isWild() && !name.isWild()) {
                    r = r.withName(name);
                }
                response.addRecord(r, section);
            }
        }
    }

    private final void addSOA(Message response, Zone zone) {
        response.addRecord(zone.getSOA(), 2);
    }

    private final void addNS(Message response, Zone zone, int flags) {
        RRset nsRecords = zone.getNS();
        this.addRRset(nsRecords.getName(), response, nsRecords, (byte)2, flags);
    }

    private final void addCacheNS(Message response, Cache cache, Name name) {
        SetResponse sr = cache.lookupRecords(name, (short)2, (byte)0);
        if (!sr.isDelegation()) {
            return;
        }
        RRset nsRecords = sr.getNS();
        Iterator it = nsRecords.rrs();
        while (it.hasNext()) {
            Record r = (Record)it.next();
            response.addRecord(r, 2);
        }
    }

    private void addGlue(Message response, Name name, int flags) {
        RRset a = this.findExactMatch(name, (short)1, (short)1, true);
        if (a == null) {
            return;
        }
        this.addRRset(name, response, a, (byte)3, flags);
    }

    private void addAdditional2(Message response, int section, int flags) {
        Record[] records = response.getSectionArray(section);
        int i = 0;
        while (i < records.length) {
            Record r = records[i];
            Name glueName = r.getAdditionalName();
            if (glueName != null) {
                this.addGlue(response, glueName, flags);
            }
            ++i;
        }
    }

    private final void addAdditional(Message response, int flags) {
        this.addAdditional2(response, 1, flags);
        this.addAdditional2(response, 2, flags);
    }

    byte addAnswer(Message response, Name name, short type, short dclass, int iterations, int flags) {
        RRset rrset;
        SetResponse sr;
        Zone zone;
        int rcode = 0;
        if (iterations > 6) {
            return 0;
        }
        if (type == 24) {
            type = (short)255;
            flags |= 2;
        }
        if ((zone = this.findBestZone(name)) != null) {
            sr = zone.findRecords(name, type);
        } else {
            Cache cache = this.getCache(dclass);
            sr = cache.lookupRecords(name, type, (byte)3);
        }
        if (sr.isUnknown()) {
            this.addCacheNS(response, this.getCache(dclass), name);
        }
        if (sr.isNXDOMAIN()) {
            response.getHeader().setRcode((short)3);
            if (zone != null) {
                this.addSOA(response, zone);
                if (iterations == 0) {
                    response.getHeader().setFlag(5);
                }
            }
            rcode = 3;
        } else if (sr.isNXRRSET()) {
            if (zone != null) {
                this.addSOA(response, zone);
                if (iterations == 0) {
                    response.getHeader().setFlag(5);
                }
            }
        } else if (sr.isDelegation()) {
            RRset nsRecords = sr.getNS();
            this.addRRset(nsRecords.getName(), response, nsRecords, (byte)2, flags);
        } else if (sr.isCNAME()) {
            rrset = new RRset();
            CNAMERecord cname = sr.getCNAME();
            rrset.addRR(cname);
            this.addRRset(name, response, rrset, (byte)1, flags);
            if (zone != null && iterations == 0) {
                response.getHeader().setFlag(5);
            }
            rcode = this.addAnswer(response, cname.getTarget(), type, dclass, iterations + 1, flags);
        } else if (sr.isDNAME()) {
            Name newname;
            rrset = new RRset();
            DNAMERecord dname = sr.getDNAME();
            rrset.addRR(dname);
            this.addRRset(name, response, rrset, (byte)1, flags);
            try {
                newname = name.fromDNAME(dname);
            }
            catch (NameTooLongException e) {
                return 6;
            }
            rrset = new RRset();
            rrset.addRR(new CNAMERecord(name, dclass, 0, newname));
            this.addRRset(name, response, rrset, (byte)1, flags);
            if (zone != null && iterations == 0) {
                response.getHeader().setFlag(5);
            }
            rcode = this.addAnswer(response, newname, type, dclass, iterations + 1, flags);
        } else if (sr.isSuccessful()) {
            RRset[] rrsets = sr.answers();
            int i = 0;
            while (i < rrsets.length) {
                this.addRRset(name, response, rrsets[i], (byte)1, flags);
                ++i;
            }
            if (zone != null) {
                this.addNS(response, zone, flags);
                if (iterations == 0) {
                    response.getHeader().setFlag(5);
                }
            } else {
                this.addCacheNS(response, this.getCache(dclass), name);
            }
        }
        return (byte)rcode;
    }

    TSIG findTSIG(Name name) {
        byte[] key = (byte[])this.TSIGs.get(name);
        if (key != null) {
            return new TSIG(name, key);
        }
        return null;
    }

    byte[] doAXFR(Name name, Message query, TSIG tsig, TSIGRecord qtsig, Socket s) {
        Zone zone = (Zone)this.znames.get(name);
        boolean first = true;
        if (zone == null) {
            return this.errorMessage(query, (short)5);
        }
        Iterator it = zone.AXFR();
        try {
            DataOutputStream dataOut = new DataOutputStream(s.getOutputStream());
            int id = query.getHeader().getID();
            while (it.hasNext()) {
                RRset rrset = (RRset)it.next();
                Message response = new Message(id);
                Header header = response.getHeader();
                header.setFlag(0);
                header.setFlag(5);
                this.addRRset(rrset.getName(), response, rrset, (byte)1, 1);
                if (tsig != null) {
                    tsig.applyAXFR(response, qtsig, first);
                    qtsig = response.getTSIG();
                }
                first = false;
                byte[] out = response.toWire();
                dataOut.writeShort(out.length);
                dataOut.write(out);
            }
        }
        catch (IOException ex) {
            System.out.println("AXFR failed");
        }
        try {
            s.close();
        }
        catch (IOException ex) {}
        return null;
    }

    byte[] generateReply(Message query, byte[] in, int length, Socket s) throws IOException {
        int flags = 0;
        Header header = query.getHeader();
        if (header.getFlag(0)) {
            return null;
        }
        if (header.getRcode() != 0) {
            return this.errorMessage(query, (short)1);
        }
        if (header.getOpcode() != 0) {
            return this.errorMessage(query, (short)4);
        }
        Record queryRecord = query.getQuestion();
        TSIGRecord queryTSIG = query.getTSIG();
        TSIG tsig = null;
        if (queryTSIG != null && ((tsig = this.findTSIG(queryTSIG.getName())) == null || tsig.verify(query, in, length, null) != 0)) {
            return this.formerrMessage(in);
        }
        OPTRecord queryOPT = query.getOPT();
        if (queryOPT != null && queryOPT.getVersion() > 0) {
            boolean badversion = true;
        }
        int maxLength = s != null ? 65535 : (queryOPT != null ? Math.max(queryOPT.getPayloadSize(), 512) : 512);
        if (queryOPT != null && (queryOPT.getFlags() & 0x8000) != 0) {
            flags = 1;
        }
        Message response = new Message(query.getHeader().getID());
        response.getHeader().setFlag(0);
        if (query.getHeader().getFlag(7)) {
            // empty if block
        }
        response.getHeader().setFlag(7);
        response.addRecord(queryRecord, 0);
        Name name = queryRecord.getName();
        short type = queryRecord.getType();
        short dclass = queryRecord.getDClass();
        if (type == 252 && s != null) {
            return this.doAXFR(name, query, tsig, queryTSIG, s);
        }
        if (!Type.isRR(type) && type != 255) {
            return this.errorMessage(query, (short)4);
        }
        byte rcode = this.addAnswer(response, name, type, dclass, 0, flags);
        if (rcode != 0 && rcode != 3) {
            return this.errorMessage(query, rcode);
        }
        this.addAdditional(response, flags);
        if (queryOPT != null) {
            int optflags = flags == 1 ? 32768 : 0;
            OPTRecord opt = new OPTRecord(4096, rcode, 0, optflags);
            response.addRecord(opt, 3);
        }
        response.setTSIG(tsig, (byte)0, queryTSIG);
        return response.toWire(maxLength);
    }

    byte[] buildErrorMessage(Header header, short rcode, Record question) {
        Message response = new Message();
        response.setHeader(header);
        int i = 0;
        while (i < 4) {
            response.removeAllRecords(i);
            ++i;
        }
        if (rcode == 2) {
            response.addRecord(question, 0);
        }
        header.setRcode(rcode);
        return response.toWire();
    }

    public byte[] formerrMessage(byte[] in) {
        Header header;
        try {
            header = new Header(in);
        }
        catch (IOException e) {
            return null;
        }
        return this.buildErrorMessage(header, (short)1, null);
    }

    public byte[] errorMessage(Message query, short rcode) {
        return this.buildErrorMessage(query.getHeader(), rcode, query.getQuestion());
    }

    public void serveTCP(InetAddress addr, short port) {
        try {
            ServerSocket sock = new ServerSocket(port, 128, addr);
            while (true) {
                byte[] in;
                Socket s = sock.accept();
                try {
                    InputStream is = s.getInputStream();
                    DataInputStream dataIn = new DataInputStream(is);
                    int inLength = dataIn.readUnsignedShort();
                    in = new byte[inLength];
                    dataIn.readFully(in);
                }
                catch (InterruptedIOException e) {
                    s.close();
                    continue;
                }
                byte[] response = null;
                try {
                    Message query = new Message(in);
                    response = this.generateReply(query, in, in.length, s);
                    if (response == null) {
                        continue;
                    }
                }
                catch (IOException e) {
                    response = this.formerrMessage(in);
                }
                DataOutputStream dataOut = new DataOutputStream(s.getOutputStream());
                dataOut.writeShort(response.length);
                dataOut.write(response);
                s.close();
            }
        }
        catch (IOException e) {
            String addrString = addr == null ? "0.0.0.0" : addr.getHostAddress();
            System.out.println("serveTCP(" + addrString + "#" + port + "): " + e);
            return;
        }
    }

    public void serveUDP(InetAddress addr, short port) {
        try {
            DatagramSocket sock = new DatagramSocket(port, addr);
            int udpLength = 512;
            byte[] in = new byte[512];
            DatagramPacket indp = new DatagramPacket(in, in.length);
            DatagramPacket outdp = null;
            while (true) {
                indp.setLength(in.length);
                try {
                    sock.receive(indp);
                }
                catch (InterruptedIOException e) {
                    continue;
                }
                byte[] response = null;
                try {
                    Message query = new Message(in);
                    response = this.generateReply(query, in, indp.getLength(), null);
                    if (response == null) {
                        continue;
                    }
                }
                catch (IOException e) {
                    response = this.formerrMessage(in);
                }
                if (outdp == null) {
                    outdp = new DatagramPacket(response, response.length, indp.getAddress(), indp.getPort());
                } else {
                    outdp.setData(response);
                    outdp.setLength(response.length);
                    outdp.setAddress(indp.getAddress());
                    outdp.setPort(indp.getPort());
                }
                sock.send(outdp);
            }
        }
        catch (IOException e) {
            String addrString = addr == null ? "0.0.0.0" : addr.getHostAddress();
            System.out.println("serveUDP(" + addrString + "#" + port + "): " + e);
            return;
        }
    }

    public void addTCP(final InetAddress addr, final short port) {
        Thread t = new Thread(new Runnable(){

            public void run() {
                jnamed.this.serveTCP(addr, port);
            }
        });
        t.start();
    }

    public void addUDP(final InetAddress addr, final short port) {
        Thread t = new Thread(new Runnable(){

            public void run() {
                jnamed.this.serveUDP(addr, port);
            }
        });
        t.start();
    }

    public static void main(String[] args) {
        if (args.length > 1) {
            System.out.println("usage: jnamed [conf]");
            System.exit(0);
        }
        try {
            String conf = args.length == 1 ? args[0] : "jnamed.conf";
            jnamed s = new jnamed(conf);
        }
        catch (IOException e) {
            System.out.println(e);
        }
    }
}

