/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import org.xbill.DNS.Compression;
import org.xbill.DNS.Inet6Address;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;
import org.xbill.DNS.TextParseException;
import org.xbill.DNS.utils.DataByteInputStream;
import org.xbill.DNS.utils.DataByteOutputStream;
import org.xbill.DNS.utils.MyStringTokenizer;

public class A6Record
extends Record {
    private static A6Record member = new A6Record();
    private short prefixBits;
    private Inet6Address suffix;
    private Name prefix;

    private A6Record() {
    }

    private A6Record(Name name, short dclass, int ttl) {
        super(name, (short)38, dclass, ttl);
    }

    static A6Record getMember() {
        return member;
    }

    public A6Record(Name name, short dclass, int ttl, int prefixBits, Inet6Address suffix, Name prefix) {
        this(name, dclass, ttl);
        this.prefixBits = (short)prefixBits;
        this.suffix = suffix;
        this.prefix = prefix;
    }

    Record rrFromWire(Name name, short type, short dclass, int ttl, int length, DataByteInputStream in) throws IOException {
        A6Record rec = new A6Record(name, dclass, ttl);
        if (in == null) {
            return rec;
        }
        rec.prefixBits = in.readByte();
        int suffixbits = 128 - rec.prefixBits;
        int suffixbytes = (suffixbits + 7) / 8;
        byte[] data = new byte[suffixbytes];
        in.read(data);
        rec.suffix = new Inet6Address(128 - rec.prefixBits, data);
        if (rec.prefixBits > 0) {
            rec.prefix = new Name(in);
        }
        return rec;
    }

    Record rdataFromString(Name name, short dclass, int ttl, MyStringTokenizer st, Name origin) throws TextParseException {
        A6Record rec = new A6Record(name, dclass, ttl);
        rec.prefixBits = Short.parseShort(st.nextToken());
        rec.suffix = new Inet6Address(st.nextToken());
        if (rec.prefixBits > 0) {
            rec.prefix = Name.fromString(st.nextToken(), origin);
        }
        return rec;
    }

    public String rdataToString() {
        StringBuffer sb = new StringBuffer();
        if (this.suffix != null) {
            sb.append(this.prefixBits);
            sb.append(" ");
            sb.append(this.suffix);
            if (this.prefix != null) {
                sb.append(" ");
                sb.append(this.prefix);
            }
        }
        return sb.toString();
    }

    public short getPrefixBits() {
        return this.prefixBits;
    }

    public Inet6Address getSuffix() {
        return this.suffix;
    }

    public Name getPrefix() {
        return this.prefix;
    }

    void rrToWire(DataByteOutputStream out, Compression c, boolean canonical) {
        if (this.suffix == null) {
            return;
        }
        out.write(this.prefixBits);
        int suffixbits = 128 - this.prefixBits;
        int suffixbytes = (suffixbits + 7) / 8;
        byte[] data = this.suffix.toBytes();
        out.write(data, 16 - suffixbytes, suffixbytes);
        if (this.prefix != null) {
            this.prefix.toWire(out, null, canonical);
        }
    }
}

