/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.xbill.DNS.CNAMERecord;
import org.xbill.DNS.DNAMERecord;
import org.xbill.DNS.Master;
import org.xbill.DNS.Message;
import org.xbill.DNS.Name;
import org.xbill.DNS.NameSet;
import org.xbill.DNS.NameTooLongException;
import org.xbill.DNS.Options;
import org.xbill.DNS.RRset;
import org.xbill.DNS.Record;
import org.xbill.DNS.SOARecord;
import org.xbill.DNS.SetResponse;
import org.xbill.DNS.Type;
import org.xbill.DNS.TypedObject;
import org.xbill.DNS.Verifier;

public class Cache
extends NameSet {
    private Verifier verifier;
    private boolean secure;
    private int maxncache = -1;
    private long cleanInterval = 30L;
    private CacheCleaner cleaner = new CacheCleaner();
    private short dclass;

    public Cache(short dclass) {
        super(true);
        this.dclass = dclass;
    }

    public Cache() {
        this(1);
    }

    public void clearCache() {
        this.clear();
    }

    /*
     * WARNING - void declaration
     */
    public Cache(String file) throws IOException {
        super(true);
        Record record;
        Master m = new Master(file);
        while ((record = m.nextRecord()) != null) {
            void var3_3;
            this.addRecord((Record)var3_3, (byte)0, m);
        }
    }

    public void addRecord(Record r, byte cred, Object o) {
        Name name = r.getName();
        short type = r.getRRsetType();
        if (!Type.isRR(type)) {
            return;
        }
        boolean addrrset = false;
        Element element = (Element)this.findExactSet(name, type);
        if (element == null || cred > element.credibility) {
            RRset rrset = new RRset();
            rrset.addRR(r);
            this.addRRset(rrset, cred);
        } else if (cred == element.credibility && element instanceof PositiveElement) {
            PositiveElement pe = (PositiveElement)element;
            pe.rrset.addRR(r);
        }
    }

    public void addRRset(RRset rrset, byte cred) {
        if (rrset.getTTL() == 0) {
            return;
        }
        Name name = rrset.getName();
        short type = rrset.getType();
        if (this.verifier != null) {
            rrset.setSecurity(this.verifier.verify(rrset, this));
        }
        if (this.secure && rrset.getSecurity() < 1) {
            return;
        }
        Element element = (Element)this.findExactSet(name, type);
        if (rrset.getTTL() == 0) {
            if (element != null && cred >= element.credibility) {
                this.removeSet(name, type, element);
            }
        } else if (element == null || cred >= element.credibility) {
            this.addSet(name, type, new PositiveElement(rrset, cred));
        }
    }

    public void addNegative(Name name, short type, SOARecord soa, byte cred) {
        if (this.verifier != null && this.secure) {
            return;
        }
        Element element = (Element)this.findExactSet(name, type);
        if ((soa == null || soa.getTTL() == 0) && element != null && cred >= element.credibility) {
            this.removeSet(name, type, element);
        }
        if (element == null || cred >= element.credibility) {
            this.addSet(name, type, new NegativeElement(name, type, soa, cred));
        }
    }

    private void logLookup(Name name, short type, String msg) {
        System.err.println("lookupRecords(" + name + " " + Type.string(type) + "): " + msg);
    }

    public SetResponse lookupRecords(Name name, short type, byte minCred) {
        SetResponse cr = null;
        boolean verbose = Options.check("verbosecache");
        Object o = this.lookup(name, type);
        if (verbose) {
            this.logLookup(name, type, "Starting");
        }
        if (o == null || o == NameSet.NXRRSET) {
            if (verbose) {
                this.logLookup(name, type, "no information found");
            }
            return SetResponse.ofType((byte)0);
        }
        Object[] objects = o instanceof Element ? new Object[]{o} : (Object[])o;
        int nelements = 0;
        int i = 0;
        while (i < objects.length) {
            Element element = (Element)objects[i];
            if (element.expired()) {
                if (verbose) {
                    this.logLookup(name, type, element.toString());
                    this.logLookup(name, type, "expired: ignoring");
                }
                this.removeSet(name, type, element);
                objects[i] = null;
            } else if (element.credibility < minCred) {
                if (verbose) {
                    this.logLookup(name, type, element.toString());
                    this.logLookup(name, type, "not credible: ignoring");
                }
                objects[i] = null;
            } else {
                ++nelements;
            }
            ++i;
        }
        if (nelements == 0) {
            if (verbose) {
                this.logLookup(name, type, "no useful data found");
            }
            return SetResponse.ofType((byte)0);
        }
        int i2 = 0;
        while (i2 < objects.length) {
            if (objects[i2] != null) {
                Element element = (Element)objects[i2];
                if (verbose) {
                    this.logLookup(name, type, element.toString());
                }
                RRset rrset = null;
                if (element instanceof PositiveElement) {
                    rrset = ((PositiveElement)element).rrset;
                }
                if (rrset == null) {
                    if (element.getType() == 0) {
                        if (verbose) {
                            this.logLookup(name, type, "NXDOMAIN");
                        }
                        return SetResponse.ofType((byte)1);
                    }
                    if (type != 255) {
                        if (verbose) {
                            this.logLookup(name, type, "NXRRSET");
                        }
                        return SetResponse.ofType((byte)2);
                    }
                    if (verbose) {
                        this.logLookup(name, type, "ANY query; ignoring NXRRSET");
                    }
                } else {
                    short rtype = rrset.getType();
                    Name rname = rrset.getName();
                    if (name.equals(rname)) {
                        if (type != 5 && type != 255 && rtype == 5) {
                            if (verbose) {
                                this.logLookup(name, type, "cname");
                            }
                            return new SetResponse(4, rrset);
                        }
                        if (type != 2 && type != 255 && rtype == 2) {
                            if (verbose) {
                                this.logLookup(name, type, "exact delegation");
                            }
                            return new SetResponse(3, rrset);
                        }
                        if (verbose) {
                            this.logLookup(name, type, "exact match");
                        }
                        if (cr == null) {
                            cr = new SetResponse(6);
                        }
                        cr.addRRset(rrset);
                    } else if (name.subdomain(rname)) {
                        if (rtype == 39) {
                            if (verbose) {
                                this.logLookup(name, type, "dname");
                            }
                            return new SetResponse(5, rrset);
                        }
                        if (rtype == 2) {
                            if (verbose) {
                                this.logLookup(name, type, "parent delegation");
                            }
                            return new SetResponse(3, rrset);
                        }
                        if (verbose) {
                            this.logLookup(name, type, "ignoring rrset (" + rname + " " + Type.string(rtype) + ")");
                        }
                    } else if (verbose) {
                        this.logLookup(name, type, "ignoring rrset (" + rname + " " + Type.string(rtype) + ")");
                    }
                }
            }
            ++i2;
        }
        if (cr == null && type == 255) {
            return SetResponse.ofType((byte)0);
        }
        if (cr == null) {
            throw new IllegalStateException("looking up (" + name + " " + Type.string(type) + "): " + "cr == null.");
        }
        return cr;
    }

    private RRset[] findRecords(Name name, short type, byte minCred) {
        SetResponse cr = this.lookupRecords(name, type, minCred);
        if (cr.isSuccessful()) {
            return cr.answers();
        }
        return null;
    }

    public RRset[] findRecords(Name name, short type) {
        return this.findRecords(name, type, (byte)3);
    }

    public RRset[] findAnyRecords(Name name, short type) {
        return this.findRecords(name, type, (byte)2);
    }

    private void verifyRecords(Cache tcache) {
        Iterator it = tcache.names();
        while (it.hasNext()) {
            Name name = (Name)it.next();
            Object[] elements = this.findExactSets(name);
            int i = 0;
            while (i < elements.length) {
                RRset rrset;
                Element element = (Element)elements[i];
                if (!(element instanceof PositiveElement) && (rrset = ((PositiveElement)element).rrset) != null) {
                    if (this.verifier != null) {
                        rrset.setSecurity(this.verifier.verify(rrset, this));
                    }
                    if (rrset.getSecurity() >= 1) {
                        this.addSet(name, rrset.getType(), element);
                    }
                }
                ++i;
            }
        }
    }

    private final byte getCred(short section, boolean isAuth) {
        if (section == 1) {
            if (isAuth) {
                return 4;
            }
            return 3;
        }
        if (section == 2) {
            if (isAuth) {
                return 4;
            }
            return 3;
        }
        if (section == 3) {
            return 1;
        }
        throw new IllegalArgumentException("getCred: invalid section");
    }

    private static void markAdditional(RRset rrset, Set names) {
        Record first = rrset.first();
        if (first.getAdditionalName() == null) {
            return;
        }
        Iterator it = rrset.rrs();
        while (it.hasNext()) {
            Record r = (Record)it.next();
            Name name = r.getAdditionalName();
            if (name == null) continue;
            names.add(name);
        }
    }

    public SetResponse addMessage(Message in) {
        byte cred;
        boolean isAuth = in.getHeader().getFlag(5);
        Record question = in.getQuestion();
        short rcode = in.getHeader().getRcode();
        boolean haveAnswer = false;
        boolean completed = false;
        boolean restart = false;
        SetResponse response = null;
        boolean verbose = Options.check("verbosecache");
        if (rcode != 0 && rcode != 3 || question == null) {
            return null;
        }
        Name qname = question.getName();
        short qtype = question.getType();
        short qclass = question.getDClass();
        Name curname = qname;
        HashSet additionalNames = new HashSet();
        RRset[] answers = in.getSectionRRsets(1);
        int i = 0;
        while (i < answers.length) {
            if (answers[i].getDClass() == qclass) {
                short type = answers[i].getType();
                Name name = answers[i].getName();
                cred = this.getCred((short)1, isAuth);
                if (type == 5 && name.equals(curname)) {
                    this.addRRset(answers[i], cred);
                    if (curname == qname) {
                        response = new SetResponse(4, answers[i]);
                    }
                    CNAMERecord cname = (CNAMERecord)answers[i].first();
                    curname = cname.getTarget();
                    restart = true;
                    haveAnswer = true;
                } else if (type == 39 && curname.subdomain(name)) {
                    this.addRRset(answers[i], cred);
                    if (curname == qname) {
                        response = new SetResponse(5, answers[i]);
                    }
                    DNAMERecord dname = (DNAMERecord)answers[i].first();
                    try {
                        curname = curname.fromDNAME(dname);
                    }
                    catch (NameTooLongException e) {
                        break;
                    }
                    restart = true;
                    haveAnswer = true;
                } else if ((type == qtype || qtype == 255) && name.equals(curname)) {
                    this.addRRset(answers[i], cred);
                    completed = true;
                    haveAnswer = true;
                    if (curname == qname) {
                        if (response == null) {
                            response = new SetResponse(6);
                        }
                        response.addRRset(answers[i]);
                    }
                    Cache.markAdditional(answers[i], additionalNames);
                }
                if (restart) {
                    restart = false;
                    i = -1;
                }
            }
            ++i;
        }
        RRset[] auth = in.getSectionRRsets(2);
        RRset soa = null;
        RRset ns = null;
        int i2 = 0;
        while (i2 < auth.length) {
            if (auth[i2].getType() == 6 && curname.subdomain(auth[i2].getName())) {
                soa = auth[i2];
            } else if (auth[i2].getType() == 2 && curname.subdomain(auth[i2].getName())) {
                ns = auth[i2];
            }
            ++i2;
        }
        if (!completed) {
            short cachetype;
            short s = cachetype = rcode == 3 ? (short)0 : qtype;
            if (soa != null || ns == null) {
                cred = this.getCred((short)2, isAuth);
                SOARecord soarec = null;
                if (soa != null) {
                    soarec = (SOARecord)soa.first();
                }
                this.addNegative(curname, cachetype, soarec, cred);
                if (response == null) {
                    byte responseType = rcode == 3 ? (byte)1 : 2;
                    response = SetResponse.ofType(responseType);
                }
            } else if (ns != null) {
                cred = this.getCred((short)2, isAuth);
                this.addRRset(ns, cred);
                Cache.markAdditional(ns, additionalNames);
                if (response == null) {
                    response = new SetResponse(3, ns);
                }
            }
        } else if (rcode == 0 && ns != null) {
            cred = this.getCred((short)2, isAuth);
            this.addRRset(ns, cred);
            Cache.markAdditional(ns, additionalNames);
        }
        RRset[] addl = in.getSectionRRsets(3);
        int i3 = 0;
        while (i3 < addl.length) {
            Name name;
            short type = addl[i3].getType();
            if ((type == 1 || type == 28 || type == 38) && additionalNames.contains(name = addl[i3].getName())) {
                cred = this.getCred((short)3, isAuth);
                this.addRRset(addl[i3], cred);
            }
            ++i3;
        }
        if (verbose) {
            System.out.println("addMessage: " + response);
        }
        return response;
    }

    public void flushSet(Name name, short type) {
        Element element = (Element)this.findExactSet(name, type);
        if (element == null) {
            return;
        }
        this.removeSet(name, type, element);
    }

    public void flushName(Name name) {
        this.removeName(name);
    }

    public void setVerifier(Verifier v) {
        this.verifier = v;
    }

    public void setSecurePolicy() {
        this.secure = true;
    }

    public void setMaxNCache(int seconds) {
        this.maxncache = seconds;
    }

    public void setCleanInterval(int minutes) {
        this.cleanInterval = minutes;
        if (this.cleaner != null) {
            this.cleaner.done = true;
            this.cleaner.interrupt();
        }
        if (this.cleanInterval > 0L) {
            this.cleaner = new CacheCleaner();
        }
    }

    static /* synthetic */ long access$200(Cache x0) {
        return x0.cleanInterval;
    }

    private class CacheCleaner
    extends Thread {
        public boolean done;

        public CacheCleaner() {
            this.setDaemon(true);
            this.setName("CacheCleaner");
            this.start();
        }

        public boolean clean() {
            Iterator it = Cache.this.names();
            while (it.hasNext()) {
                Name name;
                try {
                    name = (Name)it.next();
                }
                catch (ConcurrentModificationException e) {
                    return false;
                }
                Object[] elements = Cache.this.findExactSets(name);
                int i = 0;
                while (i < elements.length) {
                    Element element = (Element)elements[i];
                    if (element.expired()) {
                        Cache.this.removeSet(name, element.getType(), element);
                    }
                    ++i;
                }
            }
            return true;
        }

        /*
         * Unable to fully structure code
         */
        public void run() {
            block2: while (true) {
                now = System.currentTimeMillis();
                next = now + Cache.access$200(Cache.this) * 60L * 1000L;
                while (now < next) {
                    block5: {
                        try {
                            Thread.sleep(next - now);
                        }
                        catch (InterruptedException e) {
                            if (!this.done) break block5;
                            return;
                        }
                    }
                    now = System.currentTimeMillis();
                }
                i = 0;
                while (true) {
                    if (i >= 4) continue block2;
                    if (!this.clean()) ** break;
                    continue block2;
                    ++i;
                }
                break;
            }
        }
    }

    private class NegativeElement
    extends Element {
        short type;
        Name name;
        SOARecord soa;

        public NegativeElement(Name name, short type, SOARecord soa, byte cred) {
            this.name = name;
            this.type = type;
            this.soa = soa;
            long cttl = 0L;
            if (soa != null) {
                cttl = (long)soa.getMinimum() & 0xFFFFFFFFL;
                if (Cache.this.maxncache >= 0) {
                    cttl = Math.min(cttl, (long)Cache.this.maxncache);
                }
            }
            this.setValues(cred, cttl);
        }

        public short getType() {
            return this.type;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            if (this.type == 0) {
                sb.append("NXDOMAIN " + this.name);
            } else {
                sb.append("NXRRSET " + this.name + " " + Type.string(this.type));
            }
            sb.append(" cl = ");
            sb.append(this.credibility);
            return sb.toString();
        }
    }

    private static class PositiveElement
    extends Element {
        RRset rrset;

        public PositiveElement(RRset r, byte cred) {
            this.rrset = r;
            this.setValues(cred, r.getTTL());
        }

        public short getType() {
            return this.rrset.getType();
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append(this.rrset);
            sb.append(" cl = ");
            sb.append(this.credibility);
            return sb.toString();
        }
    }

    private static abstract class Element
    implements TypedObject {
        byte credibility;
        int expire;

        private Element() {
        }

        protected void setValues(byte credibility, long ttl) {
            this.credibility = credibility;
            this.expire = (int)(System.currentTimeMillis() / 1000L + ttl);
            if (this.expire < 0) {
                this.expire = Integer.MAX_VALUE;
            }
        }

        public final boolean expired() {
            int now = (int)(System.currentTimeMillis() / 1000L);
            return now >= this.expire;
        }

        public abstract short getType();
    }
}

