/*
 * Decompiled with CFR 0.152.
 */
package ORG.oclc.oai.server.verb;

import ORG.oclc.oai.server.catalog.AbstractCatalog;
import ORG.oclc.oai.server.crosswalk.Crosswalk;
import ORG.oclc.oai.server.crosswalk.CrosswalkItem;
import ORG.oclc.oai.server.crosswalk.Crosswalks;
import ORG.oclc.oai.server.verb.BadArgumentException;
import ORG.oclc.oai.server.verb.IdDoesNotExistException;
import ORG.oclc.oai.server.verb.NoMetadataFormatsException;
import ORG.oclc.oai.server.verb.OAIInternalServerError;
import ORG.oclc.oai.server.verb.ServerVerb;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpUtils;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;

public class ListMetadataFormats
extends ServerVerb {
    private static ArrayList validParamNames = new ArrayList();
    private static ArrayList requiredParamNames;

    public static String construct(HashMap context, HttpServletRequest request, HttpServletResponse response, Transformer serverTransformer) throws OAIInternalServerError, TransformerException {
        Properties properties = (Properties)context.get("OAIHandler.properties");
        AbstractCatalog abstractCatalog = (AbstractCatalog)context.get("OAIHandler.catalog");
        String baseURL = properties.getProperty("OAIHandler.baseURL");
        if (baseURL == null) {
            try {
                baseURL = request.getRequestURL().toString();
            }
            catch (NoSuchMethodError f) {
                baseURL = HttpUtils.getRequestURL((HttpServletRequest)request).toString();
            }
        }
        StringBuffer sb = new StringBuffer();
        String identifier = request.getParameter("identifier");
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>");
        String styleSheet = properties.getProperty("OAIHandler.styleSheet");
        if (styleSheet != null) {
            sb.append("<?xml-stylesheet type=\"text/xsl\" href=\"");
            sb.append(styleSheet);
            sb.append("\"?>");
        }
        sb.append("<OAI-PMH xmlns=\"http://www.openarchives.org/OAI/2.0/\"");
        sb.append(" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"");
        sb.append(" xsi:schemaLocation=\"http://www.openarchives.org/OAI/2.0/");
        sb.append(" http://www.openarchives.org/OAI/2.0/OAI-PMH.xsd\">");
        sb.append("<responseDate>");
        sb.append(ServerVerb.createResponseDate(new Date()));
        sb.append("</responseDate>");
        sb.append(ServerVerb.getRequestElement(request, validParamNames, baseURL));
        if (ServerVerb.hasBadArguments(request, requiredParamNames.iterator(), validParamNames)) {
            sb.append(new BadArgumentException().getMessage());
        } else {
            Crosswalks crosswalks = abstractCatalog.getCrosswalks();
            if (identifier == null || identifier.length() == 0) {
                Iterator iterator = crosswalks.iterator();
                sb.append("<ListMetadataFormats>");
                while (iterator.hasNext()) {
                    Map.Entry entry = (Map.Entry)iterator.next();
                    String oaiSchemaLabel = (String)entry.getKey();
                    CrosswalkItem crosswalkItem = (CrosswalkItem)entry.getValue();
                    Crosswalk crosswalk = crosswalkItem.getCrosswalk();
                    String[] tokenizer = ListMetadataFormats.split(crosswalk.getSchemaLocation());
                    String namespaceURI = null;
                    String schemaURL = null;
                    if (tokenizer.length == 1) {
                        schemaURL = tokenizer[0];
                    } else if (tokenizer.length > 1) {
                        namespaceURI = tokenizer[0];
                        schemaURL = tokenizer[1];
                    }
                    sb.append("<metadataFormat>");
                    sb.append("<metadataPrefix>");
                    sb.append(oaiSchemaLabel);
                    sb.append("</metadataPrefix>");
                    sb.append("<schema>");
                    sb.append(schemaURL);
                    sb.append("</schema>");
                    sb.append("<metadataNamespace>");
                    sb.append(namespaceURI);
                    sb.append("</metadataNamespace>");
                    sb.append("</metadataFormat>");
                }
                sb.append("</ListMetadataFormats>");
            } else {
                try {
                    Vector schemaLocations = abstractCatalog.getSchemaLocations(identifier);
                    sb.append("<ListMetadataFormats>");
                    int i = 0;
                    while (i < schemaLocations.size()) {
                        String schemaLocation = (String)schemaLocations.elementAt(i);
                        String[] tokenizer = ListMetadataFormats.split(schemaLocation);
                        String namespaceURI = null;
                        String schemaURL = null;
                        if (tokenizer.length == 1) {
                            schemaURL = tokenizer[0];
                        } else if (tokenizer.length > 1) {
                            namespaceURI = tokenizer[0];
                            schemaURL = tokenizer[1];
                        }
                        sb.append("<metadataFormat>");
                        sb.append("<metadataPrefix>");
                        sb.append(crosswalks.getMetadataPrefix(namespaceURI, schemaURL));
                        sb.append("</metadataPrefix>");
                        sb.append("<schema>");
                        sb.append(schemaURL);
                        sb.append("</schema>");
                        sb.append("<metadataNamespace>");
                        sb.append(namespaceURI);
                        sb.append("</metadataNamespace>");
                        sb.append("</metadataFormat>");
                        ++i;
                    }
                    sb.append("</ListMetadataFormats>");
                }
                catch (IdDoesNotExistException e) {
                    sb.append(e.getMessage());
                }
                catch (NoMetadataFormatsException e) {
                    sb.append(e.getMessage());
                }
            }
        }
        sb.append("</OAI-PMH>");
        return ServerVerb.render(response, "text/xml; charset=UTF-8", sb.toString(), serverTransformer);
    }

    private static String[] split(String s) {
        StringTokenizer tokenizer = new StringTokenizer(s);
        String[] tokens = new String[tokenizer.countTokens()];
        int i = 0;
        while (i < tokens.length) {
            tokens[i] = tokenizer.nextToken();
            ++i;
        }
        return tokens;
    }

    static {
        validParamNames.add("verb");
        validParamNames.add("identifier");
        requiredParamNames = new ArrayList();
        requiredParamNames.add("verb");
    }
}

