/*
 * Decompiled with CFR 0.152.
 */
package com.acme.oai;

import ORG.oclc.oai.server.catalog.AbstractCatalog;
import ORG.oclc.oai.server.verb.BadResumptionTokenException;
import ORG.oclc.oai.server.verb.CannotDisseminateFormatException;
import ORG.oclc.oai.server.verb.IdDoesNotExistException;
import ORG.oclc.oai.server.verb.NoMetadataFormatsException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class DummyOAICatalog
extends AbstractCatalog {
    private static int maxListSize;
    private HashMap resumptionResults = new HashMap();
    private String[] dummyDb = new String[]{"<record><header><identifier>oai:oaicat.oclc.org:OCLCNo/ocm00000012</identifier><datestamp>2001-02-02</datestamp><setSpec>music</setSpec><setSpec>music:(muzak)</setSpec></header><metadata><oai_dc:dc xmlns:oai_dc=\"http://www.openarchives.org/OAI/2.0/oai_dc/\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.openarchives.org/OAI/2.0/oai_dc/ http://www.openarchives.org/OAI/2.0/oai_dc.xsd\"><dc:language>eng</dc:language><dc:date>1964</dc:date><dc:type>Text data</dc:type><dc:identifier>ocm00000012</dc:identifier><dc:identifier>64063999 //r83</dc:identifier><dc:coverage>n-us---</dc:coverage><dc:subject>KF6369.3--.G3</dc:subject><dc:subject>340</dc:subject><dc:creator>Galles, George Raymond,--1918-</dc:creator><dc:title>Involuntary conversions under the Federal income tax laws.</dc:title><dc:publisher>[University of Idaho, Bureau of Business and Economic Research]</dc:publisher><dc:publisher>Moscow</dc:publisher><dc:format>v, 46 l.</dc:format><dc:format>28 cm.</dc:format><dc:relation>Idaho BBER--monograph no. 2</dc:relation><dc:subject>Income tax--Law and legislation--United States.</dc:subject><dc:relation>University of Idaho.--Bureau of Business and Economic Research.--Idaho BBER monograph ;--no. 2.</dc:relation></oai_dc:dc><oai_etdms:thesis xmlns:oai_etdms=\"http://www.ndltd.org/standards/metadata/etdms/1.0/\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.ndltd.org/standards/metadata/etdms/1.0/ http://www.ndltd.org/standards/metadata/etdms/1.0/etdms.xsd\"><oai_etdms:title>Involuntary conversions under the Federal income tax laws.</oai_etdms:title><oai_etdms:creator>Galles, George Raymond,--1918-</oai_etdms:creator><oai_etdms:subject>KF6369.3--.G3</oai_etdms:subject><oai_etdms:subject>340</oai_etdms:subject><oai_etdms:subject>Income tax--Law and legislation--United States.</oai_etdms:subject><oai_etdms:publisher>[University of Idaho, Bureau of Business and Economic Research]</oai_etdms:publisher><oai_etdms:publisher>Moscow</oai_etdms:publisher><oai_etdms:date>1964</oai_etdms:date><oai_etdms:type>Text data</oai_etdms:type><oai_etdms:format>v, 46 l.--28 cm.</oai_etdms:format><oai_etdms:identifier>ocm00000012</oai_etdms:identifier><oai_etdms:identifier>64063999 //r83</oai_etdms:identifier><oai_etdms:language>eng</oai_etdms:language><oai_etdms:coverage>n-us---</oai_etdms:coverage></oai_etdms:thesis></metadata></record>", "<rec><header><identifier>oai:oaicat.oclc.org:OCLCNo/ocm00003601</identifier><datestamp>2001-02-02</datestamp><setSpec>music</setSpec></header><metadata><oai_dc:dc xmlns:oai_dc=\"http://www.openarchives.org/OAI/2.0/oai_dc/\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.openarchives.org/OAI/2.0/oai_dc/ http://www.openarchives.org/OAI/2.0/oai_dc.xsd\"><dc:language>eng</dc:language><dc:date>1967</dc:date><dc:type>Text data</dc:type><dc:identifier>ocm00003600</dc:identifier><dc:identifier>68066972 //r915</dc:identifier><dc:subject>E78.W3--W3 no. 25</dc:subject><dc:subject>970.4/96/37</dc:subject><dc:creator>Barnes, Paul L.</dc:creator><dc:title>Archaeology of the Dean Site, Twin Falls County, Idaho,</dc:title><dc:publisher>[Pullman,</dc:publisher><dc:format>vii, 89 p.--illus., maps.</dc:format><dc:format>28 cm.</dc:format><dc:relation>Laboratory of Anthropology, Washington State University. Report of investigations,--no. 25</dc:relation><dc:subject>Dean site.</dc:subject><dc:subject>Idaho--Antiquities.</dc:subject><dc:relation>Reports of investigations (Washington State University. Laboratory of Anthropology) ;--no. 25.</dc:relation></oai_dc:dc><oai_etdms:thesis xmlns:oai_etdms=\"http://www.ndltd.org/standards/metadata/etdms/1.0/\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.ndltd.org/standards/metadata/etdms/1.0/ http://www.ndltd.org/standards/metadata/etdms/1.0/etdms.xsd\"><oai_etdms:title>Archaeology of the Dean Site, Twin Falls County, Idaho,</oai_etdms:title><oai_etdms:creator>Barnes, Paul L.</oai_etdms:creator><oai_etdms:subject>E78.W3--W3 no. 25</oai_etdms:subject><oai_etdms:subject>970.4/96/37</oai_etdms:subject><oai_etdms:subject>Dean site.</oai_etdms:subject><oai_etdms:subject>Idaho--Antiquities.</oai_etdms:subject><oai_etdms:publisher>[Pullman,</oai_etdms:publisher><oai_etdms:date>1967</oai_etdms:date><oai_etdms:type>Text data</oai_etdms:type><oai_etdms:format>vii, 89 p.--illus., maps.--28 cm.</oai_etdms:format><oai_etdms:identifier>ocm00003600</oai_etdms:identifier><oai_etdms:identifier>68066972 //r915</oai_etdms:identifier><oai_etdms:language>eng</oai_etdms:language></oai_etdms:thesis></metadata></rec>"};
    private String[] dummySets = new String[]{"<set><setSpec>music</setSpec><setName>Music collection</setName></set>", "<set><setSpec>music:(muzak)</setSpec><setName>Muzak collection</setName></set>", "<set><setSpec>music:(elec)</setSpec><setName>Electronic Music Collection</setName><setDescription><oai_dc:dc xmlns:oai_dc=\"http://www.openarchives.org/OAI/2.0/oai_dc/\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.openarchives.org/OAI/2.0/oai_dc/ http://www.epenarchives.org/OAI/2.0/oai_dc.xsd\"><dc:description>This set contains metadata describing electronic music recordings made during the 1950ies</dc:description></oai_dc:dc></setDescription></set>"};

    public DummyOAICatalog(Properties properties) {
        String maxListSize = properties.getProperty("DummyOAICatalog.maxListSize");
        if (maxListSize == null) {
            throw new IllegalArgumentException("DummyOAICatalog.maxListSize is missing from the properties file");
        }
        DummyOAICatalog.maxListSize = Integer.parseInt(maxListSize);
    }

    public Vector getSchemaLocations(String identifier) throws IdDoesNotExistException, NoMetadataFormatsException {
        String nativeItem = this.dummyDb[0];
        if (nativeItem == null) {
            throw new IdDoesNotExistException(identifier);
        }
        return this.getRecordFactory().getSchemaLocations(nativeItem);
    }

    public Map listIdentifiers(String from, String until, String set, String metadataPrefix) {
        this.purge();
        HashMap<String, Object> listIdentifiersMap = new HashMap<String, Object>();
        ArrayList<String> headers = new ArrayList<String>();
        ArrayList<String> identifiers = new ArrayList<String>();
        String[] nativeItems = this.dummyDb;
        int count = 0;
        while (count < maxListSize && count < nativeItems.length) {
            String[] header = this.getRecordFactory().createHeader(nativeItems[count]);
            headers.add(header[0]);
            identifiers.add(header[1]);
            ++count;
        }
        if (count < nativeItems.length) {
            String resumptionId = DummyOAICatalog.getResumptionId();
            this.resumptionResults.put(resumptionId, nativeItems);
            StringBuffer resumptionTokenSb = new StringBuffer();
            resumptionTokenSb.append(resumptionId);
            resumptionTokenSb.append(":");
            resumptionTokenSb.append(Integer.toString(count));
            resumptionTokenSb.append(":");
            resumptionTokenSb.append(metadataPrefix);
            listIdentifiersMap.put("resumptionMap", this.getResumptionMap(resumptionTokenSb.toString(), nativeItems.length, 0));
        }
        listIdentifiersMap.put("headers", headers.iterator());
        listIdentifiersMap.put("identifiers", identifiers.iterator());
        return listIdentifiersMap;
    }

    public Map listIdentifiers(String resumptionToken) throws BadResumptionTokenException {
        String metadataPrefix;
        int oldCount;
        String resumptionId;
        this.purge();
        HashMap<String, Object> listIdentifiersMap = new HashMap<String, Object>();
        ArrayList<String> headers = new ArrayList<String>();
        ArrayList<String> identifiers = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(resumptionToken, ":");
        try {
            resumptionId = tokenizer.nextToken();
            oldCount = Integer.parseInt(tokenizer.nextToken());
            metadataPrefix = tokenizer.nextToken();
        }
        catch (NoSuchElementException e) {
            throw new BadResumptionTokenException();
        }
        Object[] nativeItems = (Object[])this.resumptionResults.remove(resumptionId);
        if (nativeItems == null) {
            throw new BadResumptionTokenException();
        }
        int count = 0;
        while (count < maxListSize && count + oldCount < nativeItems.length) {
            String[] header = this.getRecordFactory().createHeader(nativeItems[count + oldCount]);
            headers.add(header[0]);
            identifiers.add(header[1]);
            ++count;
        }
        if (count + oldCount < nativeItems.length) {
            resumptionId = DummyOAICatalog.getResumptionId();
            this.resumptionResults.put(resumptionId, nativeItems);
            StringBuffer resumptionTokenSb = new StringBuffer();
            resumptionTokenSb.append(resumptionId);
            resumptionTokenSb.append(":");
            resumptionTokenSb.append(Integer.toString(oldCount + count));
            resumptionTokenSb.append(":");
            resumptionTokenSb.append(metadataPrefix);
            listIdentifiersMap.put("resumptionMap", this.getResumptionMap(resumptionTokenSb.toString(), nativeItems.length, oldCount));
        }
        listIdentifiersMap.put("headers", headers.iterator());
        listIdentifiersMap.put("identifiers", identifiers.iterator());
        return listIdentifiersMap;
    }

    public String getRecord(String identifier, String metadataPrefix) throws CannotDisseminateFormatException, IdDoesNotExistException {
        String nativeItem = this.dummyDb[0];
        if (nativeItem == null) {
            throw new IdDoesNotExistException(identifier);
        }
        return this.constructRecord(nativeItem, metadataPrefix);
    }

    public Map listRecords(String from, String until, String set, String metadataPrefix) throws CannotDisseminateFormatException {
        this.purge();
        HashMap<String, Object> listRecordsMap = new HashMap<String, Object>();
        ArrayList<String> records = new ArrayList<String>();
        String[] nativeItem = this.dummyDb;
        int count = 0;
        while (count < maxListSize && count < nativeItem.length) {
            String record = this.constructRecord(nativeItem[count], metadataPrefix);
            records.add(record);
            ++count;
        }
        if (count < nativeItem.length) {
            String resumptionId = DummyOAICatalog.getResumptionId();
            this.resumptionResults.put(resumptionId, nativeItem);
            StringBuffer resumptionTokenSb = new StringBuffer();
            resumptionTokenSb.append(resumptionId);
            resumptionTokenSb.append(":");
            resumptionTokenSb.append(Integer.toString(count));
            resumptionTokenSb.append(":");
            resumptionTokenSb.append(metadataPrefix);
            listRecordsMap.put("resumptionMap", this.getResumptionMap(resumptionTokenSb.toString(), nativeItem.length, 0));
        }
        listRecordsMap.put("records", records.iterator());
        return listRecordsMap;
    }

    public Map listRecords(String resumptionToken) throws BadResumptionTokenException {
        String metadataPrefix;
        int oldCount;
        String resumptionId;
        HashMap<String, Object> listRecordsMap = new HashMap<String, Object>();
        ArrayList<String> records = new ArrayList<String>();
        this.purge();
        StringTokenizer tokenizer = new StringTokenizer(resumptionToken, ":");
        try {
            resumptionId = tokenizer.nextToken();
            oldCount = Integer.parseInt(tokenizer.nextToken());
            metadataPrefix = tokenizer.nextToken();
        }
        catch (NoSuchElementException e) {
            throw new BadResumptionTokenException();
        }
        Object[] nativeItem = (Object[])this.resumptionResults.remove(resumptionId);
        if (nativeItem == null) {
            throw new BadResumptionTokenException();
        }
        int count = 0;
        while (count < maxListSize && count + oldCount < nativeItem.length) {
            try {
                String record = this.constructRecord(nativeItem[count + oldCount], metadataPrefix);
                records.add(record);
            }
            catch (CannotDisseminateFormatException e) {
                throw new BadResumptionTokenException();
            }
            ++count;
        }
        if (count + oldCount < nativeItem.length) {
            resumptionId = DummyOAICatalog.getResumptionId();
            this.resumptionResults.put(resumptionId, nativeItem);
            StringBuffer resumptionTokenSb = new StringBuffer();
            resumptionTokenSb.append(resumptionId);
            resumptionTokenSb.append(":");
            resumptionTokenSb.append(Integer.toString(oldCount + count));
            resumptionTokenSb.append(":");
            resumptionTokenSb.append(metadataPrefix);
            listRecordsMap.put("resumptionMap", this.getResumptionMap(resumptionTokenSb.toString(), nativeItem.length, oldCount));
        }
        listRecordsMap.put("records", records.iterator());
        return listRecordsMap;
    }

    private String constructRecord(Object nativeItem, String metadataPrefix) throws CannotDisseminateFormatException {
        String schemaURL = null;
        if (metadataPrefix != null && (schemaURL = this.getCrosswalks().getSchemaURL(metadataPrefix)) == null) {
            throw new CannotDisseminateFormatException(metadataPrefix);
        }
        return this.getRecordFactory().create(nativeItem, schemaURL, metadataPrefix);
    }

    public Map listSets() {
        this.purge();
        HashMap<String, Object> listSetsMap = new HashMap<String, Object>();
        ArrayList<String> sets = new ArrayList<String>();
        String[] dbSets = this.dummySets;
        int count = 0;
        while (count < maxListSize && count < dbSets.length) {
            sets.add(dbSets[count]);
            ++count;
        }
        if (count < dbSets.length) {
            String resumptionId = DummyOAICatalog.getResumptionId();
            this.resumptionResults.put(resumptionId, dbSets);
            StringBuffer resumptionTokenSb = new StringBuffer();
            resumptionTokenSb.append(resumptionId);
            resumptionTokenSb.append(":");
            resumptionTokenSb.append(Integer.toString(count));
            listSetsMap.put("resumptionMap", this.getResumptionMap(resumptionTokenSb.toString(), dbSets.length, 0));
        }
        listSetsMap.put("sets", sets.iterator());
        return listSetsMap;
    }

    public Map listSets(String resumptionToken) throws BadResumptionTokenException {
        int oldCount;
        String resumptionId;
        HashMap<String, Object> listSetsMap = new HashMap<String, Object>();
        ArrayList<String> sets = new ArrayList<String>();
        this.purge();
        StringTokenizer tokenizer = new StringTokenizer(resumptionToken, ":");
        try {
            resumptionId = tokenizer.nextToken();
            oldCount = Integer.parseInt(tokenizer.nextToken());
        }
        catch (NoSuchElementException e) {
            throw new BadResumptionTokenException();
        }
        String[] dbSets = (String[])this.resumptionResults.remove(resumptionId);
        if (dbSets == null) {
            throw new BadResumptionTokenException();
        }
        int count = 0;
        while (count < maxListSize && count + oldCount < dbSets.length) {
            sets.add(dbSets[count + oldCount]);
            ++count;
        }
        if (count + oldCount < dbSets.length) {
            resumptionId = DummyOAICatalog.getResumptionId();
            this.resumptionResults.put(resumptionId, dbSets);
            StringBuffer resumptionTokenSb = new StringBuffer();
            resumptionTokenSb.append(resumptionId);
            resumptionTokenSb.append(":");
            resumptionTokenSb.append(Integer.toString(oldCount + count));
            listSetsMap.put("resumptionMap", this.getResumptionMap(resumptionTokenSb.toString(), dbSets.length, oldCount));
        }
        listSetsMap.put("sets", sets.iterator());
        return listSetsMap;
    }

    public void close() {
    }

    private void purge() {
        ArrayList<String> old = new ArrayList<String>();
        Date now = new Date();
        Iterator keySet = this.resumptionResults.keySet().iterator();
        while (keySet.hasNext()) {
            String key = (String)keySet.next();
            Date then = new Date(Long.parseLong(key) + (long)this.getMillisecondsToLive());
            if (!now.after(then)) continue;
            old.add(key);
        }
        Iterator iterator = old.iterator();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            this.resumptionResults.remove(key);
        }
    }

    private static synchronized String getResumptionId() {
        Date now = new Date();
        return Long.toString(now.getTime());
    }
}

