/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.record;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.poi.common.usermodel.GenericRecord;
import org.apache.poi.hslf.record.RecordAtom;
import org.apache.poi.hslf.record.RecordTypes;
import org.apache.poi.util.GenericRecordJsonWriter;
import org.apache.poi.util.GenericRecordUtil;
import org.apache.poi.util.IOUtils;
import org.apache.poi.util.LittleEndian;
import org.apache.poi.util.StringUtil;

public final class TextBytesAtom
extends RecordAtom {
    public static final long _type = RecordTypes.TextBytesAtom.typeID;
    private static final int MAX_RECORD_LENGTH = 1000000;
    private byte[] _header;
    private byte[] _text;

    public String getText() {
        return StringUtil.getFromCompressedUnicode((byte[])this._text, (int)0, (int)this._text.length);
    }

    public void setText(byte[] b) {
        this._text = (byte[])b.clone();
        LittleEndian.putInt((byte[])this._header, (int)4, (int)this._text.length);
    }

    protected TextBytesAtom(byte[] source, int start, int len) {
        if (len < 8) {
            len = 8;
        }
        this._header = new byte[8];
        System.arraycopy(source, start, this._header, 0, 8);
        this._text = IOUtils.safelyAllocate((long)(len - 8), (int)1000000);
        System.arraycopy(source, start + 8, this._text, 0, len - 8);
    }

    public TextBytesAtom() {
        this._header = new byte[8];
        LittleEndian.putUShort((byte[])this._header, (int)0, (int)0);
        LittleEndian.putUShort((byte[])this._header, (int)2, (int)((int)_type));
        LittleEndian.putInt((byte[])this._header, (int)4, (int)0);
        this._text = new byte[0];
    }

    @Override
    public long getRecordType() {
        return _type;
    }

    @Override
    public void writeOut(OutputStream out) throws IOException {
        out.write(this._header);
        out.write(this._text);
    }

    public String toString() {
        return GenericRecordJsonWriter.marshal((GenericRecord)this);
    }

    public Map<String, Supplier<?>> getGenericProperties() {
        return GenericRecordUtil.getGenericProperties((String)"text", this::getText);
    }
}

