/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client.ui;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.EventPreview;
import com.google.gwt.user.client.ui.KeyboardListenerCollection;
import com.google.gwt.user.client.ui.PopupListener;
import com.google.gwt.user.client.ui.PopupListenerCollection;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.SourcesPopupEvents;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.user.client.ui.impl.PopupImpl;

public class PopupPanel
extends SimplePanel
implements SourcesPopupEvents,
EventPreview {
    private static PopupImpl impl = (PopupImpl)GWT.create(PopupImpl.class);
    private PopupListenerCollection popupListeners;
    private boolean showing;
    private boolean autoHide;

    public PopupPanel() {
        super(impl.createElement());
        DOM.setStyleAttribute(this.getElement(), "position", "absolute");
    }

    public PopupPanel(boolean autoHide) {
        this();
        this.autoHide = autoHide;
    }

    public void addPopupListener(PopupListener listener) {
        if (this.popupListeners == null) {
            this.popupListeners = new PopupListenerCollection();
        }
        this.popupListeners.add(listener);
    }

    public int getPopupLeft() {
        return DOM.getIntAttribute(this.getElement(), "offsetLeft");
    }

    public int getPopupTop() {
        return DOM.getIntAttribute(this.getElement(), "offsetTop");
    }

    public void hide() {
        this.hide(false);
    }

    public boolean onEventPreview(Event event) {
        int type = DOM.eventGetType(event);
        switch (type) {
            case 128: {
                return this.onKeyDownPreview((char)DOM.eventGetKeyCode(event), KeyboardListenerCollection.getKeyboardModifiers(event));
            }
            case 512: {
                return this.onKeyUpPreview((char)DOM.eventGetKeyCode(event), KeyboardListenerCollection.getKeyboardModifiers(event));
            }
            case 256: {
                return this.onKeyPressPreview((char)DOM.eventGetKeyCode(event), KeyboardListenerCollection.getKeyboardModifiers(event));
            }
            case 1: 
            case 2: 
            case 4: 
            case 8: 
            case 64: {
                if (DOM.getCaptureElement() != null) break;
                Element target = DOM.eventGetTarget(event);
                if (DOM.isOrHasChild(this.getElement(), target)) break;
                if (this.autoHide && type == 1) {
                    this.hide(true);
                    return true;
                }
                return false;
            }
        }
        return true;
    }

    public boolean onKeyDownPreview(char key, int modifiers) {
        return true;
    }

    public boolean onKeyPressPreview(char key, int modifiers) {
        return true;
    }

    public boolean onKeyUpPreview(char key, int modifiers) {
        return true;
    }

    public boolean remove(Widget w) {
        return super.remove(w);
    }

    public void removePopupListener(PopupListener listener) {
        if (this.popupListeners != null) {
            this.popupListeners.remove(listener);
        }
    }

    public void setPopupPosition(int left, int top) {
        if (left < 0) {
            left = 0;
        }
        if (top < 0) {
            top = 0;
        }
        Element elem = this.getElement();
        DOM.setStyleAttribute(elem, "left", left + "px");
        DOM.setStyleAttribute(elem, "top", top + "px");
    }

    public void show() {
        if (this.showing) {
            return;
        }
        this.showing = true;
        DOM.addEventPreview(this);
        RootPanel.get().add(this);
        impl.onShow(this.getElement());
    }

    private void hide(boolean autoClosed) {
        if (!this.showing) {
            return;
        }
        this.showing = false;
        DOM.removeEventPreview(this);
        RootPanel.get().remove(this);
        impl.onHide(this.getElement());
        if (this.popupListeners != null) {
            this.popupListeners.firePopupClosed(this, autoClosed);
        }
    }
}

