/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client.ui;

import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.ui.ComplexPanel;
import com.google.gwt.user.client.ui.IndexedPanel;
import com.google.gwt.user.client.ui.UIObject;
import com.google.gwt.user.client.ui.Widget;

public class StackPanel
extends ComplexPanel
implements IndexedPanel {
    private Element body;
    private int visibleStack = -1;
    static final /* synthetic */ boolean $assertionsDisabled;

    public StackPanel() {
        Element table = DOM.createTable();
        this.setElement(table);
        this.body = DOM.createTBody();
        DOM.appendChild(table, this.body);
        DOM.setIntAttribute(table, "cellSpacing", 0);
        DOM.setIntAttribute(table, "cellPadding", 0);
        DOM.sinkEvents(table, 1);
        this.setStyleName("gwt-StackPanel");
    }

    public void add(Widget w) {
        w.removeFromParent();
        int index = this.getWidgetCount();
        Element tr = DOM.createTR();
        Element td = DOM.createTD();
        DOM.appendChild(this.body, tr);
        DOM.appendChild(tr, td);
        StackPanel.setStyleName(td, "gwt-StackPanelItem", true);
        DOM.setIntAttribute(td, "__index", index);
        DOM.setAttribute(td, "height", "1px");
        tr = DOM.createTR();
        td = DOM.createTD();
        DOM.appendChild(this.body, tr);
        DOM.appendChild(tr, td);
        DOM.setAttribute(td, "height", "100%");
        DOM.setAttribute(td, "vAlign", "top");
        super.add(w, td);
        this.setStackVisible(index, false);
        if (this.visibleStack == -1) {
            this.showStack(0);
        }
    }

    public void add(Widget w, String stackText) {
        this.add(w, stackText, false);
    }

    public void add(Widget w, String stackText, boolean asHTML) {
        this.add(w);
        this.setStackText(this.getWidgetCount() - 1, stackText, asHTML);
    }

    public int getSelectedIndex() {
        return this.visibleStack;
    }

    public Widget getWidget(int index) {
        return this.getChildren().get(index);
    }

    public int getWidgetCount() {
        return this.getChildren().size();
    }

    public int getWidgetIndex(Widget child) {
        return this.getChildren().indexOf(child);
    }

    public void onBrowserEvent(Event event) {
        int index;
        if (DOM.eventGetType(event) == 1 && (index = this.getDividerIndex(DOM.eventGetTarget(event))) != -1) {
            this.showStack(index);
        }
    }

    public boolean remove(int index) {
        return this.remove(this.getWidget(index), index);
    }

    public boolean remove(Widget child) {
        return this.remove(child, this.getWidgetIndex(child));
    }

    public void setStackText(int index, String text) {
        this.setStackText(index, text, false);
    }

    public void setStackText(int index, String text, boolean asHTML) {
        if (index >= this.getWidgetCount()) {
            return;
        }
        Element td = DOM.getChild(DOM.getChild(this.body, index * 2), 0);
        if (asHTML) {
            DOM.setInnerHTML(td, text);
        } else {
            DOM.setInnerText(td, text);
        }
    }

    public void showStack(int index) {
        if (index >= this.getWidgetCount() || index == this.visibleStack) {
            return;
        }
        if (this.visibleStack >= 0) {
            this.setStackVisible(this.visibleStack, false);
        }
        this.visibleStack = index;
        this.setStackVisible(this.visibleStack, true);
    }

    private int getDividerIndex(Element elem) {
        while (elem != null && !DOM.compare(elem, this.getElement())) {
            String expando = DOM.getAttribute(elem, "__index");
            if (expando != null) {
                return Integer.parseInt(expando);
            }
            elem = DOM.getParent(elem);
        }
        return -1;
    }

    private boolean remove(Widget child, int index) {
        if (child.getParent() != this) {
            return false;
        }
        if (this.visibleStack == index) {
            this.visibleStack = -1;
        } else if (this.visibleStack > index) {
            --this.visibleStack;
        }
        int rowIndex = 2 * index;
        Element tr = DOM.getChild(this.body, rowIndex);
        DOM.removeChild(this.body, tr);
        tr = DOM.getChild(this.body, rowIndex);
        DOM.removeChild(this.body, tr);
        super.remove(child);
        int rows = this.getWidgetCount() * 2;
        for (int i = rowIndex; i < rows; i += 2) {
            Element childTR = DOM.getChild(this.body, i);
            Element td = DOM.getFirstChild(childTR);
            int curIndex = DOM.getIntAttribute(td, "__index");
            if (!$assertionsDisabled && curIndex != i / 2 - 1) {
                throw new AssertionError();
            }
            DOM.setIntAttribute(td, "__index", index);
            ++index;
        }
        return true;
    }

    private void setStackVisible(int index, boolean visible) {
        Element tr = DOM.getChild(this.body, index * 2);
        if (tr == null) {
            return;
        }
        Element td = DOM.getFirstChild(tr);
        StackPanel.setStyleName(td, "gwt-StackPanelItem-selected", visible);
        tr = DOM.getChild(this.body, index * 2 + 1);
        UIObject.setVisible(tr, visible);
        this.getWidget(index).setVisible(visible);
    }

    static {
        $assertionsDisabled = !StackPanel.class.desiredAssertionStatus();
    }
}

