/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lsid.server.impl;

import com.ibm.lsid.LSID;
import com.ibm.lsid.LSIDException;
import com.ibm.lsid.server.LSIDAssigningService;
import com.ibm.lsid.server.LSIDServerException;
import com.ibm.lsid.server.LSIDServiceConfig;
import java.util.Enumeration;
import java.util.Properties;

public class ReallySimpleAssigningService
implements LSIDAssigningService {
    public LSID assignLSID(String authority, String namespace, Properties properties) throws LSIDException {
        String lsid = "urn:lsid:" + authority + ":" + namespace + ":" + Math.random();
        Enumeration<Object> e = properties.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            lsid = lsid + "-" + key + "_" + properties.get(key);
        }
        return new LSID(lsid);
    }

    public LSID assignLSIDFromList(Properties properties, LSID[] suggested) throws LSIDException {
        if (suggested.length > 0) {
            return suggested[0];
        }
        return new LSID("urn:lsid:unknown:unknown:" + Math.random());
    }

    public String getLSIDPattern(String authority, String namespace, Properties properties) throws LSIDException {
        return "prefix";
    }

    public String getLSIDPatternFromList(Properties properties, String[] suggested) throws LSIDException {
        String pref = "prefix";
        Enumeration<Object> e = properties.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            pref = pref + "-" + key + "_" + properties.get(key);
        }
        if (suggested.length > 0) {
            return suggested[0] + pref;
        }
        return pref;
    }

    public LSID assignLSIDForNewRevision(LSID previousIdentifier) throws LSIDException {
        return new LSID("urn:lsid:" + previousIdentifier.getAuthority() + ":" + previousIdentifier.getNamespace() + ":" + previousIdentifier.getObject() + Math.random());
    }

    public String[] getAllowedPropertyNames() {
        String[] s = new String[]{"really", "simple", "properties"};
        return s;
    }

    public String[][] getAuthoritiesAndNamespaces() {
        String[][] s = new String[][]{{"authority", "ns"}, {"authority2", "ns1"}};
        return s;
    }

    public void initService(LSIDServiceConfig config) throws LSIDServerException {
    }
}

