/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lsid.server.servlet;

import com.ibm.lsid.LSID;
import com.ibm.lsid.LSIDCredentials;
import com.ibm.lsid.LSIDException;
import com.ibm.lsid.MalformedLSIDException;
import com.ibm.lsid.server.AuthenticationResponse;
import com.ibm.lsid.server.LSIDAuthenticationException;
import com.ibm.lsid.server.LSIDRequestContext;
import com.ibm.lsid.server.LSIDSecurityService;
import com.ibm.lsid.server.LSIDServerException;
import com.ibm.lsid.server.conf.ServiceConfigurationConstants;
import com.ibm.lsid.server.conf.ServiceRegistry;
import com.ibm.lsid.server.soap.AxisFaultBuilder;
import com.ibm.lsid.server.soap.LSIDAxisFault;
import com.ibm.lsid.server.soap.WebserviceConstants;
import com.ibm.lsid.soap.SOAPConstants;
import com.ibm.lsid.wsdl.WSDLConstants;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Enumeration;
import java.util.HashMap;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.axis.AxisEngine;
import org.apache.axis.AxisFault;
import org.apache.axis.ConfigurationException;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.configuration.FileProvider;
import org.apache.axis.server.AxisServer;
import org.apache.axis.session.Session;
import org.apache.axis.transport.http.AxisHttpSession;
import org.apache.axis.transport.http.HTTPConstants;
import sun.misc.BASE64Decoder;

public abstract class BaseServlet
extends HttpServlet
implements WebserviceConstants,
SOAPConstants,
com.ibm.lsid.http.HTTPConstants,
WSDLConstants,
ServiceConfigurationConstants {
    public static final String AXIS_ENGINE_ATTR = "axisengine";
    private ServiceRegistry authenticationRegistry;
    protected ServiceRegistry serviceRegistry;
    private AxisEngine engine;
    protected File serviceConfigLocation;

    public void init() throws ServletException {
        try {
            AxisEngine engine;
            String clientHome = System.getProperty("LSID_CLIENT_HOME");
            if ((clientHome == null || clientHome.equals("")) && (clientHome = this.getInitParameter("LSID_CLIENT_HOME")) != null) {
                System.setProperty("LSID_CLIENT_HOME", clientHome);
            }
            String configLocation = this.getServletContext().getInitParameter("rsdl-location");
            File location = null;
            location = configLocation == null ? new File(this.getServletContext().getRealPath("/"), "services") : new File(configLocation);
            ServletContext ctx = this.getServletContext();
            this.serviceConfigLocation = location;
            this.authenticationRegistry = ServiceRegistry.getAuthenticationServiceRegistry(location);
            ctx.setAttribute("authenticationServiceRegistry", (Object)this.authenticationRegistry);
            this.engine = engine = this.initAxisEngine();
            ctx.setAttribute(AXIS_ENGINE_ATTR, (Object)engine);
        }
        catch (LSIDServerException e) {
            throw new ServletException((Throwable)((Object)e));
        }
    }

    protected abstract void processGet(HttpServletRequest var1, HttpServletResponse var2, LSIDRequestContext var3) throws Exception;

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String lsid_str = req.getParameter("lsid");
        String hint = req.getParameter("hint");
        LSID lsid = null;
        if (lsid_str != null) {
            try {
                lsid = new LSID(lsid_str);
            }
            catch (MalformedLSIDException e) {
                throw new ServletException("malformed lsid", (Throwable)e);
            }
        }
        LSIDRequestContext rc = new LSIDRequestContext();
        rc.setReqUrl(req.getRequestURL().toString());
        Enumeration headerNames = req.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String name = (String)headerNames.nextElement();
            rc.addProtocolHeader(name, req.getHeader(name));
        }
        LSIDSecurityService security = null;
        if (lsid != null) {
            security = (LSIDSecurityService)this.getAuthenticationRegistry().lookupService(lsid);
        }
        AuthenticationResponse authResponse = null;
        LSIDAuthenticationException authex = null;
        rc.setLsid(lsid);
        rc.setHint(hint);
        if (security != null) {
            String base64;
            BASE64Decoder dec;
            String pair;
            int index;
            LSIDCredentials creds = new LSIDCredentials();
            String basic = req.getHeader("Authorization");
            if (basic != null && (index = (pair = new String((dec = new BASE64Decoder()).decodeBuffer(base64 = basic.substring(6)), "UTF-8")).indexOf(":")) > 0 && pair.length() >= index + 1) {
                creds.setProperty("basicUsername", (Object)pair.substring(0, index));
                creds.setProperty("basicPassword", (Object)pair.substring(index + 1));
            }
            rc.setCredentials(creds);
            try {
                authResponse = security.authenticate(rc);
            }
            catch (LSIDAuthenticationException e) {
                e.printStackTrace();
                authex = e;
            }
            rc.setAuthResponse(authResponse);
        }
        if (authResponse == null && authex == null || authResponse.isSuccess()) {
            try {
                this.processGet(req, resp, rc);
                return;
            }
            catch (Exception e) {
                e.printStackTrace();
                String desc = e.getMessage();
                int errorCode = 500;
                if (e instanceof LSIDException) {
                    LSIDException le = (LSIDException)((Object)e);
                    errorCode = le.getErrorCode();
                    desc = le.getDescription();
                }
                OutputStream out = null;
                if (errorCode == 700) {
                    resp.setHeader("WWW-Authenticate", "BASIC realm=\"" + lsid.toString() + "\"");
                    resp.setStatus(401);
                } else {
                    resp.setStatus(500);
                }
                resp.setHeader("LSID-Error-Code", String.valueOf(errorCode));
                StringWriter sw = new StringWriter();
                PrintWriter writer = new PrintWriter(sw);
                writer.println(desc);
                e.printStackTrace(writer);
                out = resp.getOutputStream();
                out.write(sw.getBuffer().toString().getBytes());
                out.flush();
                Object var18_24 = null;
                try {
                    if (out == null) return;
                    out.close();
                    return;
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
                return;
                {
                    catch (IOException ex2) {
                        ex2.printStackTrace();
                        throw new ServletException("Error occurred serializing exception in HTTP: " + ex2.getMessage(), (Throwable)ex2);
                    }
                }
                catch (Throwable throwable) {
                    Object var18_25 = null;
                    try {
                        if (out == null) throw throwable;
                        out.close();
                        throw throwable;
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                    throw throwable;
                }
            }
        }
        OutputStream out = null;
        String errorMsg = "LSID Authentication failed: ";
        String realm = null;
        if (authResponse != null) {
            Object respData = authResponse.getResponseData();
            errorMsg = respData != null ? errorMsg + respData.toString() : errorMsg + "No reason given";
            realm = authResponse.getRealm();
            if (realm == null) {
                realm = lsid.getAuthority().getAuthority() + ":" + lsid.getNamespace();
            }
        } else if (authex != null) {
            realm = lsid.getAuthority().getAuthority() + ":" + lsid.getNamespace();
            StringWriter sw = new StringWriter();
            PrintWriter writer = new PrintWriter(sw);
            authex.printStackTrace(writer);
            errorMsg = errorMsg + writer.toString();
        }
        resp.setHeader("WWW-Authenticate", "BASIC realm=\"" + realm + "\"");
        resp.setHeader("LSID-Error-Code", String.valueOf(700));
        resp.setStatus(401);
        resp.setContentType("text/html");
        out = resp.getOutputStream();
        out.write(errorMsg.getBytes());
        out.flush();
        Object var21_29 = null;
        try {
            if (out == null) return;
            out.close();
            return;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return;
        {
            catch (IOException e) {
                e.printStackTrace();
                throw new ServletException("Could not get response outputstream");
            }
        }
        catch (Throwable throwable) {
            Object var21_30 = null;
            try {
                if (out == null) throw throwable;
                out.close();
                throw throwable;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        PrintWriter out;
        Message responseMessage = null;
        MessageContext msgContext = null;
        AuthenticationResponse authresp = null;
        try {
            AxisEngine engine = this.getEngine();
            resp.setBufferSize(8192);
            msgContext = this.createMessageContext(engine, req, resp);
            Message requestMsg = new Message((Object)req.getInputStream(), false, req.getHeader("Content-Type"), req.getHeader("Content-Location"));
            msgContext.setRequestMessage(requestMsg);
            String url = req.getRequestURL().toString();
            msgContext.setProperty("transport.url", (Object)url);
            String soapAction = this.getSoapAction(req);
            if (soapAction != null) {
                msgContext.setUseSOAPAction(true);
                msgContext.setSOAPActionURI(soapAction);
            }
            msgContext.setSession((Session)new AxisHttpSession(req));
            engine.invoke(msgContext);
            responseMessage = msgContext.getResponseMessage();
        }
        catch (LSIDAxisFault e) {
            e.printStackTrace();
            authresp = this.configureResponseFromFault(e, resp, msgContext);
            if (authresp == null) {
                responseMessage = new Message((Object)e);
            }
        }
        catch (AxisFault e) {
            e.printStackTrace();
            AxisFault l = AxisFaultBuilder.createFault(e);
            this.configureResponseFromFault(l, resp, msgContext);
            responseMessage = new Message((Object)l);
        }
        catch (Exception e) {
            e.printStackTrace();
            LSIDAxisFault l = AxisFaultBuilder.createFault(e, "Unknown Error");
            this.configureResponseFromFault(l, resp, msgContext);
            responseMessage = new Message((Object)l);
        }
        if (authresp == null && responseMessage == null) {
            resp.setStatus(204);
        }
        if (authresp != null) {
            out = null;
            try {
                try {
                    String errorMsg = "LSID Authentication failed: ";
                    Object respData = authresp.getResponseData();
                    errorMsg = respData != null ? errorMsg + respData.toString() : errorMsg + "No reason given";
                    out = resp.getWriter();
                    out.println(errorMsg);
                    out.flush();
                }
                catch (Exception e) {
                    System.err.println("Error writing auth error to stream");
                    e.printStackTrace();
                    Object var11_17 = null;
                    if (out == null) return;
                    out.close();
                    return;
                }
                Object var11_16 = null;
                if (out == null) return;
                out.close();
                return;
            }
            catch (Throwable throwable) {
                Object var11_18 = null;
                if (out == null) throw throwable;
                out.close();
                throw throwable;
            }
        } else {
            out = null;
            resp.setContentType(responseMessage.getContentType(msgContext.getSOAPConstants()));
            out = resp.getOutputStream();
            responseMessage.writeTo((OutputStream)((Object)out));
            Object var13_20 = null;
            try {
                if (out == null) return;
                ((OutputStream)((Object)out)).close();
                return;
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
        }
        return;
        {
            catch (Exception e) {
                System.err.println("Error writing response to stream");
                e.printStackTrace();
                Object var13_21 = null;
                try {
                    if (out == null) return;
                    ((OutputStream)((Object)out)).close();
                    return;
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
                return;
            }
        }
        catch (Throwable throwable) {
            Object var13_22 = null;
            try {
                if (out == null) throw throwable;
                ((OutputStream)((Object)out)).close();
                throw throwable;
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
            throw throwable;
        }
    }

    private AuthenticationResponse configureResponseFromFault(AxisFault e, HttpServletResponse resp, MessageContext msgctx) {
        if (e instanceof LSIDAxisFault) {
            LSIDAxisFault fault = (LSIDAxisFault)e;
            if (fault.getErrorCode() == 700) {
                resp.setStatus(401);
                LSIDRequestContext ctx = (LSIDRequestContext)msgctx.getProperty("lsidrequestctx");
                AuthenticationResponse authresp = null;
                String realm = "LSID";
                if (ctx != null) {
                    realm = null;
                    authresp = ctx.getAuthResponse();
                    if (authresp != null) {
                        realm = authresp.getRealm();
                    }
                    if (realm == null) {
                        LSID lsid = ctx.getLsid();
                        realm = lsid.getAuthority().getAuthority() + ":" + lsid.getNamespace();
                    }
                }
                resp.setHeader("WWW-Authenticate", "BASIC realm=\"" + realm + "\"");
                return authresp;
            }
            if (fault.getErrorCode() == 710) {
                resp.setStatus(400);
            } else {
                resp.setStatus(500);
            }
        } else {
            resp.setStatus(500);
        }
        return null;
    }

    private MessageContext createMessageContext(AxisEngine engine, HttpServletRequest req, HttpServletResponse resp) {
        MessageContext msgContext = new MessageContext(engine);
        msgContext.setProperty(HTTPConstants.MC_HTTP_SERVLET, (Object)this);
        msgContext.setProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST, (Object)req);
        msgContext.setProperty(HTTPConstants.MC_HTTP_SERVLETRESPONSE, (Object)resp);
        msgContext.setProperty("Authorization", (Object)req.getHeader("Authorization"));
        return msgContext;
    }

    private AxisEngine getEngine() {
        if (this.engine != null) {
            return this.engine;
        }
        this.engine = (AxisEngine)this.getServletContext().getAttribute(AXIS_ENGINE_ATTR);
        return this.engine;
    }

    private ServiceRegistry getAuthenticationRegistry() {
        if (this.authenticationRegistry != null) {
            return this.authenticationRegistry;
        }
        this.authenticationRegistry = (ServiceRegistry)this.getServletContext().getAttribute("authenticationServiceRegistry");
        return this.authenticationRegistry;
    }

    protected ServiceRegistry getServiceRegistry(String type) {
        if (this.serviceRegistry != null) {
            return this.serviceRegistry;
        }
        this.serviceRegistry = (ServiceRegistry)this.getServletContext().getAttribute(type);
        return this.serviceRegistry;
    }

    private String getSoapAction(HttpServletRequest req) throws AxisFault {
        String soapAction = req.getHeader("SOAPAction");
        if (soapAction == null) {
            throw AxisFaultBuilder.createFault(710, "No SOAP Action Specified");
        }
        if (soapAction.startsWith("\"") && soapAction.endsWith("\"") && soapAction.length() >= 2) {
            int end = soapAction.length() - 1;
            soapAction = soapAction.substring(1, end);
        }
        if (soapAction.length() == 0) {
            soapAction = req.getContextPath();
        }
        return soapAction;
    }

    private AxisEngine initAxisEngine() throws ServletException {
        try {
            FileProvider config;
            HashMap<String, Object> environment = new HashMap<String, Object>();
            ServletContext context = this.getServletContext();
            environment.put("servletContext", context);
            String webInfPath = context.getRealPath("/WEB-INF/");
            if (webInfPath != null) {
                environment.put("servlet.realpath", webInfPath);
                environment.put("axis.attachments.Directory", webInfPath + File.separator + "attachments");
            }
            if ((config = new FileProvider(webInfPath, "server-config.wsdd")) != null) {
                environment.put("engineConfig", config);
            }
            return AxisServer.getServer(environment);
        }
        catch (AxisFault e) {
            e.printStackTrace();
            throw new ServletException("Error setting up axis engine", (Throwable)e);
        }
        catch (ConfigurationException e) {
            e.printStackTrace();
            throw new ServletException("Error setting up axis engine configuration");
        }
    }
}

