/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lsid.server.servlet;

import com.ibm.lsid.LSID;
import com.ibm.lsid.http.HTTPConstants;
import com.ibm.lsid.server.LSIDDataService;
import com.ibm.lsid.server.LSIDRequestContext;
import com.ibm.lsid.server.LSIDServerException;
import com.ibm.lsid.server.conf.ServiceConfigurationConstants;
import com.ibm.lsid.server.conf.ServiceRegistry;
import com.ibm.lsid.server.servlet.BaseServlet;
import com.ibm.lsid.soap.SOAPConstants;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class DataServlet
extends BaseServlet
implements SOAPConstants,
HTTPConstants,
ServiceConfigurationConstants {
    public void init() throws ServletException {
        super.init();
        try {
            ServletContext ctx = this.getServletContext();
            this.serviceRegistry = ServiceRegistry.getDataServiceRegistry(this.serviceConfigLocation);
            ctx.setAttribute("dataserviceImplRegistry", (Object)this.serviceRegistry);
        }
        catch (LSIDServerException e) {
            throw new ServletException((Throwable)((Object)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processGet(HttpServletRequest req, HttpServletResponse resp, LSIDRequestContext rc) throws Exception {
        InputStream data = null;
        OutputStream out = null;
        try {
            LSID lsid = rc.getLsid();
            if (lsid == null) {
                throw new LSIDServerException(712, "Must specify HTTP Parameter 'lsid'");
            }
            LSIDDataService service = (LSIDDataService)this.getServiceRegistry("dataserviceImplRegistry").lookupService(lsid);
            if (service == null) {
                throw new LSIDServerException(201, "LSID Unknown: " + lsid);
            }
            String startStr = req.getParameter("start");
            String lengthStr = req.getParameter("length");
            if (startStr != null && lengthStr != null) {
                int start = Integer.parseInt(startStr);
                int length = Integer.parseInt(lengthStr);
                data = service.getDataByRange(rc, start, length);
            } else {
                data = service.getData(rc);
            }
            resp.setContentType("application/octet-stream");
            out = resp.getOutputStream();
            byte[] bytes = new byte[1024];
            int numbytes = data.read(bytes);
            while (numbytes != -1) {
                out.write(bytes, 0, numbytes);
                numbytes = data.read(bytes);
            }
            out.flush();
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                if (data != null) {
                    data.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

