/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lsid.server.servlet;

import com.ibm.lsid.LSID;
import com.ibm.lsid.MetadataResponse;
import com.ibm.lsid.http.HTTPConstants;
import com.ibm.lsid.server.LSIDMetadataService;
import com.ibm.lsid.server.LSIDRequestContext;
import com.ibm.lsid.server.LSIDServerException;
import com.ibm.lsid.server.conf.ServiceConfigurationConstants;
import com.ibm.lsid.server.conf.ServiceRegistry;
import com.ibm.lsid.server.servlet.BaseServlet;
import com.ibm.lsid.soap.SOAPConstants;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class MetadataServlet
extends BaseServlet
implements SOAPConstants,
HTTPConstants,
ServiceConfigurationConstants {
    public void init() throws ServletException {
        super.init();
        try {
            ServletContext ctx = this.getServletContext();
            this.serviceRegistry = ServiceRegistry.getMetaDataServiceRegistry(this.serviceConfigLocation);
            ctx.setAttribute("metaserviceImplRegistry", (Object)this.serviceRegistry);
        }
        catch (LSIDServerException e) {
            throw new ServletException((Throwable)((Object)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processGet(HttpServletRequest req, HttpServletResponse resp, LSIDRequestContext rc) throws Exception {
        OutputStream out = null;
        try {
            LSID lsid = rc.getLsid();
            if (lsid == null) {
                throw new LSIDServerException(712, "Must specify HTTP Parameter 'lsid'");
            }
            String[] formatsArray = null;
            String format = req.getParameter("acceptedFormats");
            if (format != null) {
                StringTokenizer st = new StringTokenizer(format, ",", false);
                Vector<String> v = new Vector<String>();
                while (st.hasMoreTokens()) {
                    v.add(st.nextToken());
                }
                formatsArray = new String[v.size()];
                v.toArray(formatsArray);
            }
            InputStream result = null;
            MetadataResponse mr = null;
            try {
                LSIDMetadataService service = (LSIDMetadataService)this.getServiceRegistry("metaserviceImplRegistry").lookupService(lsid);
                if (service == null) {
                    throw new LSIDServerException(201, "LSID Unknown: " + lsid);
                }
                mr = service.getMetadata(rc, formatsArray);
                if (mr != null) {
                    Date expires = mr.getExpires();
                    if (expires != null) {
                        resp.setHeader("Expires", HTTPConstants.HTTP_DATE_FORMAT.format(expires));
                    }
                    resp.setContentType(mr.getFormat());
                    result = (InputStream)mr.getValue();
                    if (result != null) {
                        byte[] bytes = new byte[1024];
                        int numbytes = result.read(bytes);
                        out = resp.getOutputStream();
                        while (numbytes != -1) {
                            out.write(bytes, 0, numbytes);
                            numbytes = result.read(bytes);
                        }
                        out.flush();
                    }
                }
                Object var15_14 = null;
            }
            catch (Throwable throwable) {
                Object var15_15 = null;
                try {
                    if (result != null) {
                        result.close();
                    }
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
                throw throwable;
            }
            try {
                if (result != null) {
                    result.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            Object var18_19 = null;
        }
        catch (Throwable throwable) {
            Object var18_20 = null;
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            throw throwable;
        }
        try {
            if (out != null) {
                out.close();
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }
}

