/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lsid.server.soap;

import com.ibm.lsid.ExpiringResponse;
import com.ibm.lsid.LSID;
import com.ibm.lsid.LSIDException;
import com.ibm.lsid.MalformedLSIDException;
import com.ibm.lsid.client.LSIDAuthority;
import com.ibm.lsid.server.LSIDAuthorityService;
import com.ibm.lsid.server.LSIDRequestContext;
import com.ibm.lsid.server.LSIDServerException;
import com.ibm.lsid.server.conf.ServiceRegistry;
import com.ibm.lsid.server.soap.AxisFaultBuilder;
import com.ibm.lsid.server.soap.LSIDWebService;
import java.io.ByteArrayInputStream;
import java.util.Iterator;
import javax.xml.soap.Name;
import org.apache.axis.AxisFault;
import org.apache.axis.message.MessageElement;
import org.apache.axis.message.PrefixedQName;
import org.apache.axis.message.SOAPBodyElement;

public class AuthorityWebService
extends LSIDWebService {
    public SOAPBodyElement[] getAvailableServices(SOAPBodyElement[] bodyElements) throws AxisFault {
        try {
            LSID theLsid = this.getLSID(bodyElements[0]);
            LSIDRequestContext ctx = this.getRequestContext(theLsid);
            ServiceRegistry reg = this.getServiceRegistry("authserviceImplRegistry");
            LSIDAuthorityService service = (LSIDAuthorityService)reg.lookupService(theLsid);
            if (service == null) {
                throw new LSIDServerException(201, "Unknown lsid: " + theLsid);
            }
            ExpiringResponse resp = service.getAvailableServices(ctx);
            if (resp.getExpires() != null) {
                this.addExpirationHeader(resp.getExpires());
            }
            ByteArrayInputStream stream = new ByteArrayInputStream(((String)resp.getValue()).getBytes());
            this.addAttachment(stream);
            SOAPBodyElement responseElt = new SOAPBodyElement();
            responseElt.setName("getAvailableServicesResponse");
            responseElt.setNamespaceURI("http://www.omg.org/LSID/2003/AuthorityServiceSOAPBindings");
            return new SOAPBodyElement[]{responseElt};
        }
        catch (LSIDException e) {
            throw AxisFaultBuilder.createFault(e);
        }
    }

    public SOAPBodyElement[] notifyForeignAuthority(SOAPBodyElement[] bodyElements) throws AxisFault {
        try {
            LSID theLsid = this.getLSID(bodyElements[0]);
            LSIDAuthority auth = this.getAuthority(bodyElements[0]);
            LSIDRequestContext ctx = this.getRequestContext(theLsid);
            ServiceRegistry reg = this.getServiceRegistry("authserviceImplRegistry");
            LSIDAuthorityService service = (LSIDAuthorityService)reg.lookupService(theLsid);
            if (service == null) {
                throw new LSIDServerException(201, "Unknown lsid: " + theLsid);
            }
            service.notifyForeignAuthority(ctx, auth);
            SOAPBodyElement responseElt = new SOAPBodyElement();
            responseElt.setName("notifyForeignAuthorityResponse");
            responseElt.setNamespaceURI("http://www.omg.org/LSID/2003/AuthorityServiceSOAPBindings");
            return new SOAPBodyElement[]{responseElt};
        }
        catch (LSIDException e) {
            throw AxisFaultBuilder.createFault(e);
        }
    }

    public SOAPBodyElement[] revokeNotificationForeignAuthority(SOAPBodyElement[] bodyElements) throws AxisFault {
        try {
            LSID theLsid = this.getLSID(bodyElements[0]);
            LSIDAuthority auth = this.getAuthority(bodyElements[0]);
            LSIDRequestContext ctx = this.getRequestContext(theLsid);
            ServiceRegistry reg = this.getServiceRegistry("authserviceImplRegistry");
            LSIDAuthorityService service = (LSIDAuthorityService)reg.lookupService(theLsid);
            if (service == null) {
                throw new LSIDServerException(201, "Unknown lsid: " + theLsid);
            }
            service.revokeNotificationForeignAuthority(ctx, auth);
            SOAPBodyElement responseElt = new SOAPBodyElement();
            responseElt.setName("revokeNotificationForeignAuthorityResponse");
            responseElt.setNamespaceURI("http://www.omg.org/LSID/2003/AuthorityServiceSOAPBindings");
            return new SOAPBodyElement[]{responseElt};
        }
        catch (LSIDException e) {
            throw AxisFaultBuilder.createFault(e);
        }
    }

    protected LSIDAuthority getAuthority(SOAPBodyElement bodyElt) throws AxisFault {
        try {
            Iterator it = bodyElt.getChildElements((Name)new PrefixedQName(null, "authorityName", null));
            if (!it.hasNext()) {
                throw AxisFaultBuilder.createFault(712, "Must specify LSID parameter");
            }
            MessageElement elt = (MessageElement)it.next();
            return new LSIDAuthority(elt.getValue());
        }
        catch (MalformedLSIDException e) {
            throw AxisFaultBuilder.createFault((LSIDException)((Object)e));
        }
    }
}

