/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.client.v1.itk;

import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.dataone.client.exception.ClientSideException;
import org.dataone.client.v1.itk.D1Client;
import org.dataone.client.v1.itk.D1Object;
import org.dataone.configuration.Settings;
import org.dataone.ore.ProvResourceMapBuilder;
import org.dataone.ore.ResourceMapFactory;
import org.dataone.service.exceptions.InsufficientResources;
import org.dataone.service.exceptions.InvalidRequest;
import org.dataone.service.exceptions.InvalidToken;
import org.dataone.service.exceptions.NotAuthorized;
import org.dataone.service.exceptions.NotFound;
import org.dataone.service.exceptions.NotImplemented;
import org.dataone.service.exceptions.ServiceFailure;
import org.dataone.service.types.v1.Identifier;
import org.dataone.service.types.v1.SystemMetadata;
import org.dataone.service.util.EncodingUtilities;
import org.dataone.vocabulary.CITO;
import org.dataone.vocabulary.DC_TERMS;
import org.dspace.foresite.AggregatedResource;
import org.dspace.foresite.Aggregation;
import org.dspace.foresite.OREException;
import org.dspace.foresite.OREFactory;
import org.dspace.foresite.OREParserException;
import org.dspace.foresite.ORESerialiserException;
import org.dspace.foresite.Predicate;
import org.dspace.foresite.ResourceMap;
import org.dspace.foresite.Triple;
import org.dspace.foresite.TripleSelector;

public class DataPackage {
    private Identifier packageId;
    private ResourceMap resourceMap = null;
    private HashMap<Identifier, D1Object> objectStore;
    private SystemMetadata systemMetadata = null;
    private String D1_URI_PREFIX = Settings.getConfiguration().getString("D1Client.CN_URL") + "/v1/resolve/";

    public DataPackage() {
        this(null);
    }

    public DataPackage(Identifier id) {
        this.objectStore = new HashMap();
        String title = null;
        try {
            this.resourceMap = ResourceMapFactory.getInstance().createResourceMap(id, title);
        }
        catch (OREException oREException) {
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        this.setPackageId(id);
    }

    public void addAndDownloadData(Identifier id) throws InvalidToken, ServiceFailure, NotAuthorized, NotFound, NotImplemented, InsufficientResources, InvalidRequest, ClientSideException {
        if (!this.contains(id)) {
            D1Object o = D1Object.download(id);
            this.objectStore.put(id, o);
        }
    }

    public void addData(D1Object obj) {
        Identifier id = obj.getIdentifier();
        if (!this.contains(id) && obj != null) {
            this.objectStore.put(id, obj);
        }
    }

    public void insertRelationship(Identifier metadataID, List<Identifier> dataIDList) throws OREException, URISyntaxException {
        URI metadataURI = this.getResolveURI(metadataID);
        this.aggregate(metadataURI);
        this.insertRelationship(metadataURI, DC_TERMS.predicate("identifier"), metadataID.getValue());
        ArrayList<URI> dataURIs = new ArrayList<URI>();
        for (Identifier dataID : dataIDList) {
            URI dataURI = this.getResolveURI(dataID);
            dataURIs.add(dataURI);
            this.aggregate(dataURI);
            this.insertRelationship(dataURI, DC_TERMS.predicate("identifier"), dataID.getValue());
            this.insertRelationship(dataURI, CITO.predicate("isDocumentedBy"), metadataURI);
        }
        this.insertRelationship(metadataURI, CITO.predicate("documents"), dataURIs);
    }

    public void insertRelationship(URI subject, Predicate predicate, URI object) throws URISyntaxException, OREException {
        ArrayList<URI> objects = new ArrayList<URI>();
        objects.add(object);
        this.insertRelationship(subject, predicate, objects);
    }

    public void insertRelationship(String blankSubjectId, Predicate predicate, URI object) throws OREException {
        Property property = ResourceFactory.createProperty((String)predicate.getURI().toString());
        ArrayList<RDFNode> objectResources = new ArrayList<RDFNode>();
        objectResources.add((RDFNode)ResourceFactory.createResource((String)object.toString()));
        ProvResourceMapBuilder provBuilder = new ProvResourceMapBuilder();
        this.resourceMap = provBuilder.insertRelationship(this.resourceMap, blankSubjectId, property, objectResources);
    }

    public void insertRelationship(URI subject, Predicate predicate, List<URI> objects) throws URISyntaxException, OREException {
        Resource subjectResource = ResourceFactory.createResource((String)subject.toString());
        Property property = ResourceFactory.createProperty((String)predicate.getURI().toString());
        ArrayList<RDFNode> objectResources = new ArrayList<RDFNode>();
        for (URI objectURI : objects) {
            objectResources.add((RDFNode)ResourceFactory.createResource((String)objectURI.toString()));
        }
        ProvResourceMapBuilder provBuilder = new ProvResourceMapBuilder();
        this.resourceMap = provBuilder.insertRelationship(this.resourceMap, subjectResource, property, objectResources);
    }

    public void insertRelationship(URI subject, Predicate predicate, Object literal) throws OREException {
        Resource subjectResource = ResourceFactory.createResource((String)subject.toString());
        Property property = ResourceFactory.createProperty((String)predicate.getURI().toString());
        Literal literalValue = ResourceFactory.createTypedLiteral((Object)literal);
        ArrayList<RDFNode> objects = new ArrayList<RDFNode>();
        objects.add((RDFNode)literalValue);
        ProvResourceMapBuilder provBuilder = new ProvResourceMapBuilder();
        this.resourceMap = provBuilder.insertRelationship(this.resourceMap, subjectResource, property, objects);
    }

    public int size() {
        return this.objectStore.size();
    }

    public boolean contains(Identifier id) {
        return this.objectStore.containsKey(id);
    }

    public D1Object get(Identifier id) {
        return this.objectStore.get(id);
    }

    public void remove(Identifier id) {
        this.removeData(id);
    }

    public void removeData(Identifier id) {
        this.objectStore.remove(id);
    }

    public Set<Identifier> identifiers() {
        return this.objectStore.keySet();
    }

    public Identifier getPackageId() {
        return this.packageId;
    }

    public void setPackageId(Identifier packageId) {
        if (null != packageId) {
            this.packageId = packageId;
        }
    }

    public ResourceMap getResourceMap() {
        return this.resourceMap;
    }

    public void setResourceMap(ResourceMap resourceMap) {
        this.resourceMap = resourceMap;
    }

    private URI getResolveURI(Identifier identifier) throws URISyntaxException {
        URI uri = new URI(this.D1_URI_PREFIX + EncodingUtilities.encodeUrlPathSegment((String)identifier.getValue()));
        return uri;
    }

    private void aggregate(URI resourceURI) throws OREException {
        AggregatedResource resource = OREFactory.createAggregatedResource((URI)resourceURI);
        Aggregation aggregation = this.resourceMap.getAggregation();
        aggregation.addAggregatedResource(resource);
    }

    public String serializePackage() throws OREException, URISyntaxException, ORESerialiserException {
        ResourceMap rm = this.getResourceMap();
        String rdfXml = ResourceMapFactory.getInstance().serializeResourceMap(rm);
        return rdfXml;
    }

    public static DataPackage download(Identifier pid) throws InvalidToken, ServiceFailure, NotAuthorized, NotFound, NotImplemented, InsufficientResources, InvalidRequest, OREException, URISyntaxException, OREParserException, IOException, ClientSideException {
        D1Object packageObject = D1Object.download(pid);
        if (packageObject.getFormatId().getValue().equals("http://www.openarchives.org/ore/terms")) {
            String resourceMap = IOUtils.toString((InputStream)packageObject.getDataSource().getInputStream());
            return DataPackage.deserializePackage(resourceMap);
        }
        throw new InvalidRequest("0000", "The identifier does not represent a DataPackage (is not an ORE resource map)");
    }

    public static DataPackage deserializePackage(String resourceMap) throws UnsupportedEncodingException, OREException, URISyntaxException, OREParserException, InvalidToken, ServiceFailure, NotAuthorized, NotFound, NotImplemented, InsufficientResources, InvalidRequest, ClientSideException {
        Map<Identifier, Map<Identifier, List<Identifier>>> packageMap = ResourceMapFactory.getInstance().parseResourceMap(resourceMap);
        DataPackage dp = null;
        if (packageMap != null && !packageMap.isEmpty()) {
            Identifier pid = packageMap.keySet().iterator().next();
            dp = new DataPackage(pid);
            ByteArrayInputStream inputStream = new ByteArrayInputStream(resourceMap.getBytes());
            ResourceMap resource = ResourceMapFactory.getInstance().deserializeResourceMap(inputStream);
            dp.setResourceMap(resource);
            Map<Identifier, List<Identifier>> mdMap = packageMap.get(pid);
            for (Identifier scienceMetadataId : mdMap.keySet()) {
                dp.addAndDownloadData(scienceMetadataId);
                List<Identifier> dataIdentifiers = mdMap.get(scienceMetadataId);
                for (Identifier dataId : dataIdentifiers) {
                    dp.addAndDownloadData(dataId);
                }
            }
        }
        return dp;
    }

    public Identifier getDocumentedBy(Identifier dataObject) {
        Identifier documenter = null;
        URI metadataURI = null;
        URI predicateURI = null;
        URI dataURI = null;
        try {
            metadataURI = null;
            predicateURI = CITO.predicate("documents").getURI();
            dataURI = this.getResolveURI(dataObject);
            TripleSelector documentsSelector = new TripleSelector(metadataURI, predicateURI, dataURI);
            List documentsTriples = this.resourceMap.listAllTriples(documentsSelector);
            if (!documentsTriples.isEmpty()) {
                Triple triple = (Triple)documentsTriples.get(0);
                URI returnedMetadataURI = triple.getSubjectURI();
                Object metadataIdentifier = null;
                TripleSelector idSelector = new TripleSelector(returnedMetadataURI, DC_TERMS.predicate("identifier").getURI(), metadataIdentifier);
                List idTriples = this.resourceMap.listAllTriples(idSelector);
                if (!idTriples.isEmpty()) {
                    Triple metadataIdTriple = (Triple)idTriples.get(0);
                    String metadataId = metadataIdTriple.getObjectLiteral();
                    documenter = new Identifier();
                    documenter.setValue(metadataId);
                }
            }
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        catch (OREException e) {
            e.printStackTrace();
        }
        return documenter;
    }

    public void setSystemMetadata(SystemMetadata systemMetadata) {
        this.systemMetadata = systemMetadata;
    }

    public SystemMetadata getSystemMetadata() {
        return this.systemMetadata;
    }

    public Set<Identifier> getUncharacterizedMembers() {
        HashSet<Identifier> unmappedMembers = new HashSet<Identifier>();
        for (Identifier pid : this.objectStore.keySet()) {
            if (this.getMetadataMap().containsKey(pid) || this.getDocumentedBy(pid) != null) continue;
            unmappedMembers.add(pid);
        }
        return unmappedMembers;
    }

    public Set<Identifier> getUnresolvableMembers() throws InvalidToken, ServiceFailure, NotImplemented {
        Set<Identifier> unresolvedItems = this.getPackageResources();
        unresolvedItems.removeAll(this.objectStore.keySet());
        for (Identifier item : unresolvedItems) {
            try {
                D1Client.getCN().resolve(item);
                unresolvedItems.remove(item);
            }
            catch (NotAuthorized e) {
                unresolvedItems.remove(item);
            }
            catch (NotFound notFound) {}
        }
        return unresolvedItems;
    }

    public Map<Identifier, List<Identifier>> getMetadataMap() {
        Map<Identifier, List<Identifier>> metadataMap = null;
        try {
            String resourceMapStr = ResourceMapFactory.getInstance().serializeResourceMap(this.resourceMap);
            Map<Identifier, Map<Identifier, List<Identifier>>> packageMap = ResourceMapFactory.getInstance().parseResourceMap(resourceMapStr);
            Identifier pid = packageMap.keySet().iterator().next();
            metadataMap = packageMap.get(pid);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (ORESerialiserException e) {
            e.printStackTrace();
        }
        catch (OREException e) {
            e.printStackTrace();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        catch (OREParserException e) {
            e.printStackTrace();
        }
        return metadataMap;
    }

    private Set<Identifier> getPackageResources() {
        HashSet<Identifier> packageResources = new HashSet<Identifier>();
        for (Identifier pid : this.getMetadataMap().keySet()) {
            packageResources.add(pid);
            packageResources.addAll((Collection<Identifier>)this.getMetadataMap().get(pid));
        }
        return packageResources;
    }
}

