/*
 * Decompiled with CFR 0.152.
 */
package ORG.oclc.oai.server.verb;

import ORG.oclc.oai.server.catalog.AbstractCatalog;
import ORG.oclc.oai.server.crosswalk.Crosswalks;
import ORG.oclc.oai.server.verb.BadArgumentException;
import ORG.oclc.oai.server.verb.BadResumptionTokenException;
import ORG.oclc.oai.server.verb.CannotDisseminateFormatException;
import ORG.oclc.oai.server.verb.NoItemsMatchException;
import ORG.oclc.oai.server.verb.NoSetHierarchyException;
import ORG.oclc.oai.server.verb.OAIInternalServerError;
import ORG.oclc.oai.server.verb.ServerVerb;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpUtils;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;

public class ListIdentifiers
extends ServerVerb {
    private static final boolean debug = false;
    private static ArrayList validParamNames1 = new ArrayList();
    private static ArrayList validParamNames2;
    private static ArrayList requiredParamNames1;
    private static ArrayList requiredParamNames2;

    public static String construct(HashMap context, HttpServletRequest request, HttpServletResponse response, Transformer serverTransformer) throws OAIInternalServerError, TransformerException {
        Properties properties = (Properties)context.get("OAIHandler.properties");
        AbstractCatalog abstractCatalog = (AbstractCatalog)context.get("OAIHandler.catalog");
        boolean xmlEncodeSetSpec = "true".equalsIgnoreCase(properties.getProperty("OAIHandler.xmlEncodeSetSpec"));
        boolean urlEncodeSetSpec = !"false".equalsIgnoreCase(properties.getProperty("OAIHandler.urlEncodeSetSpec"));
        String baseURL = properties.getProperty("OAIHandler.baseURL");
        if (baseURL == null) {
            try {
                baseURL = request.getRequestURL().toString();
            }
            catch (NoSuchMethodError f) {
                baseURL = HttpUtils.getRequestURL((HttpServletRequest)request).toString();
            }
        }
        StringBuffer sb = new StringBuffer();
        String oldResumptionToken = request.getParameter("resumptionToken");
        String metadataPrefix = request.getParameter("metadataPrefix");
        if (metadataPrefix != null && metadataPrefix.length() == 0) {
            metadataPrefix = null;
        }
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>");
        String styleSheet = properties.getProperty("OAIHandler.styleSheet");
        if (styleSheet != null) {
            sb.append("<?xml-stylesheet type=\"text/xsl\" href=\"");
            sb.append(styleSheet);
            sb.append("\"?>");
        }
        sb.append("<OAI-PMH xmlns=\"http://www.openarchives.org/OAI/2.0/\"");
        sb.append(" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"");
        sb.append(" xsi:schemaLocation=\"http://www.openarchives.org/OAI/2.0/");
        sb.append(" http://www.openarchives.org/OAI/2.0/OAI-PMH.xsd\">");
        sb.append("<responseDate>");
        sb.append(ServerVerb.createResponseDate(new Date()));
        sb.append("</responseDate>");
        if (!abstractCatalog.isHarvestable()) {
            sb.append("<request verb=\"ListIdentifiers\">");
            sb.append(baseURL);
            sb.append("</request>");
            sb.append("<error code=\"badArgument\">Database is unavailable for harvesting</error>");
        } else {
            ArrayList validParamNames = null;
            ArrayList requiredParamNames = null;
            Map listIdentifiersMap = null;
            if (oldResumptionToken == null) {
                validParamNames = validParamNames1;
                requiredParamNames = requiredParamNames1;
                String from = request.getParameter("from");
                String until = request.getParameter("until");
                try {
                    if (from != null && from.length() > 0 && from.length() < 10) {
                        throw new BadArgumentException();
                    }
                    if (until != null && until.length() > 0 && until.length() < 10) {
                        throw new BadArgumentException();
                    }
                    if (from != null && until != null && from.length() != until.length()) {
                        throw new BadArgumentException();
                    }
                    if (from == null || from.length() == 0) {
                        from = "0001-01-01";
                    }
                    if (until == null || until.length() == 0) {
                        until = "9999-12-31";
                    }
                    if ((from = abstractCatalog.toFinestFrom(from)).compareTo(until = abstractCatalog.toFinestUntil(until)) > 0) {
                        throw new BadArgumentException();
                    }
                    String set = request.getParameter("set");
                    if (set != null) {
                        if (set.length() == 0) {
                            set = null;
                        } else if (urlEncodeSetSpec) {
                            set = set.replace(' ', '+');
                        }
                    }
                    Crosswalks crosswalks = abstractCatalog.getCrosswalks();
                    if (metadataPrefix == null) {
                        throw new BadArgumentException();
                    }
                    if (!crosswalks.containsValue(metadataPrefix)) {
                        throw new CannotDisseminateFormatException(metadataPrefix);
                    }
                    listIdentifiersMap = abstractCatalog.listIdentifiers(from, until, set, metadataPrefix);
                }
                catch (NoItemsMatchException e) {
                    sb.append(ServerVerb.getRequestElement(request, validParamNames, baseURL, xmlEncodeSetSpec));
                    sb.append(e.getMessage());
                }
                catch (BadArgumentException e) {
                    sb.append("<request verb=\"ListIdentifiers\">");
                    sb.append(baseURL);
                    sb.append("</request>");
                    sb.append(e.getMessage());
                }
                catch (CannotDisseminateFormatException e) {
                    sb.append(ServerVerb.getRequestElement(request, validParamNames, baseURL, xmlEncodeSetSpec));
                    sb.append(e.getMessage());
                }
                catch (NoSetHierarchyException e) {
                    sb.append(ServerVerb.getRequestElement(request, validParamNames, baseURL, xmlEncodeSetSpec));
                    sb.append(e.getMessage());
                }
            } else {
                validParamNames = validParamNames2;
                requiredParamNames = requiredParamNames2;
                if (ServerVerb.hasBadArguments(request, requiredParamNames.iterator(), validParamNames)) {
                    sb.append(ServerVerb.getRequestElement(request, validParamNames, baseURL, xmlEncodeSetSpec));
                    sb.append(new BadArgumentException().getMessage());
                } else {
                    try {
                        listIdentifiersMap = abstractCatalog.listIdentifiers(oldResumptionToken);
                    }
                    catch (BadResumptionTokenException e) {
                        sb.append(ServerVerb.getRequestElement(request, validParamNames, baseURL, xmlEncodeSetSpec));
                        sb.append(e.getMessage());
                    }
                }
            }
            if (listIdentifiersMap != null) {
                sb.append(ServerVerb.getRequestElement(request, validParamNames, baseURL, xmlEncodeSetSpec));
                if (ServerVerb.hasBadArguments(request, requiredParamNames.iterator(), validParamNames)) {
                    sb.append(new BadArgumentException().getMessage());
                } else {
                    sb.append("<ListIdentifiers>");
                    Iterator identifiers = (Iterator)listIdentifiersMap.get("headers");
                    while (identifiers.hasNext()) {
                        sb.append((String)identifiers.next());
                    }
                    Map newResumptionMap = (Map)listIdentifiersMap.get("resumptionMap");
                    if (newResumptionMap != null) {
                        String newResumptionToken = (String)newResumptionMap.get("resumptionToken");
                        String expirationDate = (String)newResumptionMap.get("expirationDate");
                        String completeListSize = (String)newResumptionMap.get("completeListSize");
                        String cursor = (String)newResumptionMap.get("cursor");
                        sb.append("<resumptionToken");
                        if (expirationDate != null) {
                            sb.append(" expirationDate=\"");
                            sb.append(expirationDate);
                            sb.append("\"");
                        }
                        if (completeListSize != null) {
                            sb.append(" completeListSize=\"");
                            sb.append(completeListSize);
                            sb.append("\"");
                        }
                        if (cursor != null) {
                            sb.append(" cursor=\"");
                            sb.append(cursor);
                            sb.append("\"");
                        }
                        sb.append(">");
                        sb.append(newResumptionToken);
                        sb.append("</resumptionToken>");
                    } else if (oldResumptionToken != null) {
                        sb.append("<resumptionToken />");
                    }
                    sb.append("</ListIdentifiers>");
                }
            }
        }
        sb.append("</OAI-PMH>");
        return ServerVerb.render(response, "text/xml; charset=UTF-8", sb.toString(), serverTransformer);
    }

    static {
        validParamNames1.add("verb");
        validParamNames1.add("from");
        validParamNames1.add("until");
        validParamNames1.add("set");
        validParamNames1.add("metadataPrefix");
        validParamNames2 = new ArrayList();
        validParamNames2.add("verb");
        validParamNames2.add("resumptionToken");
        requiredParamNames1 = new ArrayList();
        requiredParamNames1.add("verb");
        requiredParamNames1.add("metadataPrefix");
        requiredParamNames2 = new ArrayList();
        requiredParamNames2.add("verb");
        requiredParamNames2.add("resumptionToken");
    }
}

