/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.ajax.json;

import java.util.List;
import java.util.Map;
import org.apache.wicket.ajax.json.JSONArray;
import org.apache.wicket.ajax.json.JSONException;
import org.apache.wicket.ajax.json.JSONObject;

public final class JsonUtils {
    private JsonUtils() {
    }

    public static JSONArray asArray(Map<String, Object> map) throws JSONException {
        JSONArray jsonArray = new JSONArray();
        if (map != null) {
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                String name = entry.getKey();
                Object value = entry.getValue();
                if (value instanceof List) {
                    List values = (List)value;
                    for (Object v : values) {
                        if (v == null) continue;
                        JSONObject object = new JSONObject();
                        object.put("name", name);
                        object.put("value", v);
                        jsonArray.put(object);
                    }
                    continue;
                }
                if (value == null) continue;
                if (value.getClass().isArray()) {
                    Object[] array;
                    for (Object v : array = (Object[])value) {
                        if (v == null) continue;
                        JSONObject object = new JSONObject();
                        object.put("name", name);
                        object.put("value", v);
                        jsonArray.put(object);
                    }
                    continue;
                }
                JSONObject object = new JSONObject();
                object.put("name", name);
                object.put("value", value);
                jsonArray.put(object);
            }
        }
        return jsonArray;
    }
}

