/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.itis;

import edu.ucsb.nceas.itis.ItisException;
import edu.ucsb.nceas.itis.Taxon;
import edu.ucsb.nceas.itis.Utility;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Stack;
import java.util.Vector;
import org.apache.xerces.dom.DOMImplementationImpl;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class ItisXmlHandler
extends DefaultHandler {
    private Document xmlDocument;
    private Stack elementStack;
    private Vector taxaList;
    private Stack taxaStack;
    private String currentValue;
    private String currentPathexpr;
    private String parserName = null;

    public ItisXmlHandler() {
        this.loadConfigurationParameters();
    }

    public Vector parseTaxa(Reader reader) throws ItisException {
        Object object;
        try {
            object = DOMImplementationImpl.getDOMImplementation();
            this.xmlDocument = object.createDocument("taxondoc", "taxondoc", null);
        }
        catch (DOMException dOMException) {
            Utility.debug(1, "Couldn't build taxon document.");
        }
        this.elementStack = new Stack();
        this.taxaList = new Vector();
        this.taxaStack = new Stack();
        object = this.initializeParser();
        if (object == null) {
            Utility.debug(1, "SAX parser not instantiated properly.");
        }
        try {
            object.parse(new InputSource(reader));
        }
        catch (IOException iOException) {
            Utility.debug(4, "Error reading the xml during parsing.");
            throw new ItisException(iOException.getMessage());
        }
        catch (SAXException sAXException) {
            Utility.debug(4, "Error parsing taxon xml (" + sAXException.getClass().getName() + ").");
            throw new ItisException(sAXException.getMessage());
        }
        Utility.debug(20, "Found " + this.taxaList.size() + " taxa.");
        return this.taxaList;
    }

    public Vector parseTaxa(String string) throws ItisException {
        return this.parseTaxa(new StringReader(string));
    }

    private XMLReader initializeParser() {
        XMLReader xMLReader = null;
        try {
            xMLReader = XMLReaderFactory.createXMLReader(this.parserName);
            xMLReader.setContentHandler(this);
            xMLReader.setErrorHandler(this);
        }
        catch (Exception exception) {
            Utility.debug(1, "Error in initializeParser " + exception.toString());
        }
        return xMLReader;
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        Utility.debug(20, "Processing start element: " + string2);
        Element element = null;
        try {
            element = this.xmlDocument.createElement(string2);
        }
        catch (DOMException dOMException) {
            Utility.debug(1, "Error creating element while processing taxon.");
        }
        if (attributes != null) {
            int n = attributes.getLength();
            int n2 = 0;
            while (n2 < n) {
                element.setAttribute(attributes.getLocalName(n2), attributes.getValue(n2));
                ++n2;
            }
        }
        this.elementStack.push(element);
        if (element.getTagName().equals("taxon") || element.getTagName().equals("synonym") || element.getTagName().equals("parent") || element.getTagName().equals("child")) {
            Taxon taxon = new Taxon();
            if (element.getTagName().equals("taxon")) {
                taxon.setDataComplete(true);
            } else if (element.getTagName().equals("child")) {
                Taxon taxon2 = (Taxon)this.taxaStack.peek();
                taxon2.setHasChildList(true);
            }
            Utility.debug(20, "Adding taxon to stack. ");
            this.taxaStack.push(taxon);
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        Utility.debug(20, "Processing end element: " + string2);
        Element element = (Element)this.elementStack.pop();
        if (element.getTagName().equals("taxon") || element.getTagName().equals("synonym") || element.getTagName().equals("parent") || element.getTagName().equals("child")) {
            Utility.debug(20, "Adding taxon to list. ");
            Taxon taxon = (Taxon)this.taxaStack.pop();
            this.taxaList.add(taxon);
        }
    }

    public void characters(char[] cArray, int n, int n2) {
        Utility.debug(20, "Processing characters.");
        String string = new String(cArray, n, n2);
        Element element = (Element)this.elementStack.peek();
        String string2 = element.getTagName();
        Taxon taxon = null;
        if (!this.taxaStack.empty()) {
            taxon = (Taxon)this.taxaStack.pop();
        }
        if (string2.equals("tsn")) {
            long l = new Long(string);
            taxon.setTsn(l);
            Utility.debug(15, "Setting tsn to: " + l);
            Element element2 = (Element)this.elementStack.get(this.elementStack.size() - 2);
            if (element2.getTagName().equals("parent")) {
                Taxon taxon2 = (Taxon)this.taxaStack.peek();
                taxon2.setParentTsn(l);
                Utility.debug(15, "Setting parent tsn to: " + l);
            } else if (element2.getTagName().equals("synonym")) {
                Taxon taxon3 = (Taxon)this.taxaStack.peek();
                taxon3.addSynonymTsn(l);
                Utility.debug(15, "Adding child tsn: " + l);
            } else if (element2.getTagName().equals("child")) {
                Taxon taxon4 = (Taxon)this.taxaStack.peek();
                taxon4.addChildTsn(l);
                Utility.debug(15, "Adding child tsn: " + l);
            }
        } else if (string2.equals("concatenatedname")) {
            taxon.setScientificName(string);
            Utility.debug(15, "Setting name to: " + string);
        } else if (string2.equals("synonymname")) {
            taxon.setScientificName(string);
            Utility.debug(15, "Setting name to: " + string);
        } else if (string2.equals("rank")) {
            taxon.setTaxonRank(string);
            Utility.debug(15, "Setting rank to: " + string);
        } else if (string2.equals("taxonauthor")) {
            taxon.setTaxonAuthor(string);
            Utility.debug(15, "Setting author to: " + string);
        } else if (string2.equals("commonname")) {
            taxon.addVernacularName(string);
            Utility.debug(15, "Adding common name: " + string);
        }
        if (taxon != null) {
            this.taxaStack.push(taxon);
        }
    }

    private void loadConfigurationParameters() {
        this.parserName = "org.apache.xerces.parsers.SAXParser";
    }
}

