/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis;

import java.io.IOException;
import java.util.Random;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionLengthAttribute;
import org.apache.lucene.util.TestUtil;

public final class MockHoleInjectingTokenFilter
extends TokenFilter {
    private final long randomSeed;
    private Random random;
    private final PositionIncrementAttribute posIncAtt = (PositionIncrementAttribute)this.addAttribute(PositionIncrementAttribute.class);
    private final PositionLengthAttribute posLenAtt = (PositionLengthAttribute)this.addAttribute(PositionLengthAttribute.class);
    private int maxPos;
    private int pos;

    public MockHoleInjectingTokenFilter(Random random, TokenStream in) {
        super(in);
        this.randomSeed = random.nextLong();
    }

    public void reset() throws IOException {
        super.reset();
        this.random = new Random(this.randomSeed);
        this.maxPos = -1;
        this.pos = -1;
    }

    public boolean incrementToken() throws IOException {
        if (this.input.incrementToken()) {
            int posInc = this.posIncAtt.getPositionIncrement();
            int nextPos = this.pos + posInc;
            if (posInc > 0 && this.maxPos <= nextPos && this.random.nextInt(5) == 3) {
                int holeSize = TestUtil.nextInt(this.random, 1, 5);
                this.posIncAtt.setPositionIncrement(posInc + holeSize);
                nextPos += holeSize;
            }
            this.pos = nextPos;
            this.maxPos = Math.max(this.maxPos, this.pos + this.posLenAtt.getPositionLength());
            return true;
        }
        return false;
    }
}

