/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.graph;

import java.awt.Font;
import java.awt.Paint;
import org.rrd4j.core.Util;
import org.rrd4j.graph.Axis;
import org.rrd4j.graph.ElementsNames;
import org.rrd4j.graph.ImageParameters;
import org.rrd4j.graph.ImageWorker;
import org.rrd4j.graph.Mapper;
import org.rrd4j.graph.RrdGraph;
import org.rrd4j.graph.RrdGraphDef;

class ValueAxisLogarithmic
extends Axis {
    private static final double[][] yloglab = new double[][]{{1.0E9, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {1000.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {10.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {10.0, 1.0, 2.5, 5.0, 7.5, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {10.0, 1.0, 2.0, 4.0, 6.0, 8.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {10.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
    private final ImageParameters im;
    private final ImageWorker worker;
    private final RrdGraphDef gdef;
    private final int fontHeight;
    private final Mapper mapper;

    ValueAxisLogarithmic(RrdGraph rrdGraph) {
        this(rrdGraph, rrdGraph.worker);
    }

    ValueAxisLogarithmic(RrdGraph rrdGraph, ImageWorker worker) {
        this.im = rrdGraph.im;
        this.gdef = rrdGraph.gdef;
        this.worker = worker;
        this.fontHeight = (int)Math.ceil(worker.getFontHeight(this.gdef.getFont(FONTTAG_AXIS)));
        this.mapper = rrdGraph.mapper;
    }

    @Override
    boolean draw() {
        int length;
        String graph_label;
        int y;
        int i;
        double value;
        int y2;
        Font font = this.gdef.getFont(FONTTAG_AXIS);
        Paint gridColor = this.gdef.getColor(ElementsNames.grid);
        Paint mGridColor = this.gdef.getColor(ElementsNames.mgrid);
        Paint fontColor = this.gdef.getColor(ElementsNames.font);
        int labelOffset = (int)(this.worker.getFontAscent(font) / 2.0);
        if (this.im.maxval == this.im.minval) {
            return false;
        }
        double pixpex = (double)this.im.ysize / (ValueAxisLogarithmic.log10(this.im.maxval) - ValueAxisLogarithmic.log10(this.im.minval));
        if (Double.isNaN(pixpex)) {
            return false;
        }
        int minoridx = 0;
        int majoridx = 0;
        int i2 = 0;
        while (yloglab[i2][0] > 0.0) {
            double pixperstep;
            double minstep = ValueAxisLogarithmic.log10(yloglab[i2][0]);
            int ii = 1;
            while (yloglab[i2][ii + 1] > 0.0) {
                if (yloglab[i2][ii + 2] == 0.0) {
                    minstep = ValueAxisLogarithmic.log10(yloglab[i2][ii + 1]) - ValueAxisLogarithmic.log10(yloglab[i2][ii]);
                    break;
                }
                ++ii;
            }
            if ((pixperstep = pixpex * minstep) > 5.0) {
                minoridx = i2;
            }
            if (pixperstep > (double)(2 * this.fontHeight)) {
                majoridx = i2;
            }
            ++i2;
        }
        double positiveMin = this.im.minval > 0.0 ? this.im.minval : 0.0;
        int x0 = this.im.xorigin;
        int x1 = x0 + this.im.xsize;
        if (yloglab[minoridx][0] == 0.0 || yloglab[majoridx][0] == 0.0) {
            return false;
        }
        for (double value2 = Math.pow(10.0, ValueAxisLogarithmic.log10(positiveMin) - ValueAxisLogarithmic.log10(positiveMin) % ValueAxisLogarithmic.log10(yloglab[minoridx][0])); value2 <= this.im.maxval; value2 *= yloglab[minoridx][0]) {
            if (value2 < positiveMin) continue;
            int i3 = 0;
            while (yloglab[minoridx][++i3] > 0.0 && (y2 = this.mapper.ytr(value2 * yloglab[minoridx][i3])) > this.im.yorigin - this.im.ysize) {
                this.worker.drawLine(x0 - 1, y2, x0 + 1, y2, gridColor, this.gdef.tickStroke);
                this.worker.drawLine(x1 - 1, y2, x1 + 1, y2, gridColor, this.gdef.tickStroke);
                this.worker.drawLine(x0, y2, x1, y2, gridColor, this.gdef.gridStroke);
            }
        }
        double negativeMin = -1.0 * (this.im.maxval < 0.0 ? this.im.maxval : 0.0);
        for (double value3 = Math.pow(10.0, ValueAxisLogarithmic.log10(negativeMin) - ValueAxisLogarithmic.log10(negativeMin) % ValueAxisLogarithmic.log10(yloglab[minoridx][0])); value3 <= -1.0 * this.im.minval; value3 *= yloglab[minoridx][0]) {
            int y3;
            if (value3 < negativeMin) continue;
            int i4 = 0;
            while (yloglab[minoridx][++i4] > 0.0 && (y3 = this.mapper.ytr(-1.0 * value3 * yloglab[minoridx][i4])) > this.im.yorigin - this.im.ysize) {
                this.worker.drawLine(x0 - 1, y3, x0 + 1, y3, gridColor, this.gdef.tickStroke);
                this.worker.drawLine(x1 - 1, y3, x1 + 1, y3, gridColor, this.gdef.tickStroke);
                this.worker.drawLine(x0, y3, x1, y3, gridColor, this.gdef.gridStroke);
            }
        }
        boolean skipFirst = false;
        if (this.im.minval < 0.0 && this.im.maxval > 0.0) {
            skipFirst = true;
            y2 = this.mapper.ytr(0.0);
            this.worker.drawLine(x0 - 2, y2, x0 + 2, y2, mGridColor, this.gdef.tickStroke);
            this.worker.drawLine(x1 - 2, y2, x1 + 2, y2, mGridColor, this.gdef.tickStroke);
            this.worker.drawLine(x0, y2, x1, y2, mGridColor, this.gdef.gridStroke);
            String graph_label2 = Util.sprintf(this.gdef.locale, "%3.0e", 0.0);
            int length2 = (int)this.worker.getStringWidth(graph_label2, font);
            this.worker.drawString(graph_label2, x0 - length2 - 7, y2 + labelOffset, font, fontColor);
        }
        int iter = 0;
        for (value = Math.pow(10.0, ValueAxisLogarithmic.log10(positiveMin) - ValueAxisLogarithmic.log10(positiveMin) % ValueAxisLogarithmic.log10(yloglab[majoridx][0])); value <= this.im.maxval; value *= yloglab[majoridx][0]) {
            if (value < positiveMin || skipFirst && ++iter == 1) continue;
            i = 0;
            while (yloglab[majoridx][++i] > 0.0 && (y = this.mapper.ytr(value * yloglab[majoridx][i])) > this.im.yorigin - this.im.ysize) {
                this.worker.drawLine(x0 - 2, y, x0 + 2, y, mGridColor, this.gdef.tickStroke);
                this.worker.drawLine(x1 - 2, y, x1 + 2, y, mGridColor, this.gdef.tickStroke);
                this.worker.drawLine(x0, y, x1, y, mGridColor, this.gdef.gridStroke);
                graph_label = Util.sprintf(this.gdef.locale, "%3.0e", value * yloglab[majoridx][i]);
                length = (int)this.worker.getStringWidth(graph_label, font);
                this.worker.drawString(graph_label, x0 - length - 7, y + labelOffset, font, fontColor);
            }
        }
        iter = 0;
        for (value = Math.pow(10.0, ValueAxisLogarithmic.log10(negativeMin) - ValueAxisLogarithmic.log10(negativeMin) % ValueAxisLogarithmic.log10(yloglab[majoridx][0])); value <= -1.0 * this.im.minval; value *= yloglab[majoridx][0]) {
            if (value < negativeMin || skipFirst && ++iter == 1) continue;
            i = 0;
            while (yloglab[majoridx][++i] > 0.0 && (y = this.mapper.ytr(-1.0 * value * yloglab[majoridx][i])) > this.im.yorigin - this.im.ysize) {
                this.worker.drawLine(x0 - 2, y, x0 + 2, y, mGridColor, this.gdef.tickStroke);
                this.worker.drawLine(x1 - 2, y, x1 + 2, y, mGridColor, this.gdef.tickStroke);
                this.worker.drawLine(x0, y, x1, y, mGridColor, this.gdef.gridStroke);
                graph_label = Util.sprintf(this.gdef.locale, "%3.0e", -1.0 * value * yloglab[majoridx][i]);
                length = (int)this.worker.getStringWidth(graph_label, font);
                this.worker.drawString(graph_label, x0 - length - 7, y + labelOffset, font, fontColor);
            }
        }
        return true;
    }

    static double log10(double v) {
        double lv = Math.log10(Math.abs(v));
        if (lv < 0.0) {
            return 0.0;
        }
        return Math.copySign(lv, v);
    }
}

