/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.core;

import java.util.Locale;

public enum JoinRelType {
    INNER,
    LEFT,
    RIGHT,
    FULL;

    public final String lowerName = this.name().toLowerCase(Locale.ROOT);

    public boolean generatesNullsOnRight() {
        return this == LEFT || this == FULL;
    }

    public boolean generatesNullsOnLeft() {
        return this == RIGHT || this == FULL;
    }

    public JoinRelType swap() {
        switch (this) {
            case LEFT: {
                return RIGHT;
            }
            case RIGHT: {
                return LEFT;
            }
        }
        return this;
    }

    public boolean generatesNullsOn(int i) {
        switch (i) {
            case 0: {
                return this.generatesNullsOnLeft();
            }
            case 1: {
                return this.generatesNullsOnRight();
            }
        }
        throw new IllegalArgumentException("invalid: " + i);
    }

    public JoinRelType cancelNullsOnLeft() {
        switch (this) {
            case RIGHT: {
                return INNER;
            }
            case FULL: {
                return LEFT;
            }
        }
        return this;
    }

    public JoinRelType cancelNullsOnRight() {
        switch (this) {
            case LEFT: {
                return INNER;
            }
            case FULL: {
                return RIGHT;
            }
        }
        return this;
    }
}

